(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7663,        274]
NotebookOptionsPosition[      5900,        216]
NotebookOutlinePosition[      6859,        243]
CellTagsIndexPosition[      6816,        240]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Parsec" :> Documentation`HelpLookup["paclet:Units/ref/Parsec"],
           "Mile" :> Documentation`HelpLookup["paclet:Units/ref/Mile"], 
          "AstronomicalUnit" :> 
          Documentation`HelpLookup["paclet:Units/ref/AstronomicalUnit"], "AU" :> 
          Documentation`HelpLookup["paclet:Units/ref/AU"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Parsec\"\>", 2->"\<\"Mile\"\>", 
       3->"\<\"AstronomicalUnit\"\>", 4->"\<\"AU\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LightYear", "ObjectName",
 CellID->15740],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["LightYear"], "InlineFormula"],
     " \[LineSeparator]is a unit of length."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->588]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["LightYear"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"9.46073", "\[Times]", 
   SuperscriptBox["10", "15"], " ", 
   ButtonBox["Meter",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Meter"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->15795],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "LightYear"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "LightYear"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->16614],

Cell[TextData[{
 "One ",
 Cell[BoxData["LightYear"], "InlineFormula"],
 " is the distance light travels in a year in a vacuum."
}], "Notes",
 CellID->24135],

Cell[TextData[{
 Cell[BoxData["LightYear"], "InlineFormula"],
 " is typically abbreviated as ly."
}], "Notes",
 CellID->31660]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->673],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Parsec",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Parsec"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mile",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Mile"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AstronomicalUnit",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/AstronomicalUnit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AU",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/AU"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27781]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17299],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->18826]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LightYear - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 10, 43.2906800}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "LightYear is a unit of length.", "synonyms" -> {}, "title" -> 
    "LightYear", "type" -> "Symbol", "uri" -> "Units/ref/LightYear"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1434, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2057, 61, 47, 1, 70, "ObjectName",
 CellID->15740],
Cell[2107, 64, 317, 10, 70, "Usage",
 CellID->588]
}, Open  ]],
Cell[CellGroupData[{
Cell[2461, 79, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2939, 96, 324, 11, 70, "Notes",
 CellID->15795],
Cell[3266, 109, 509, 19, 70, "Notes",
 CellID->16614],
Cell[3778, 130, 156, 5, 70, "Notes",
 CellID->24135],
Cell[3937, 137, 126, 4, 70, "Notes",
 CellID->31660]
}, Closed]],
Cell[CellGroupData[{
Cell[4100, 146, 309, 9, 70, "SeeAlsoSection",
 CellID->673],
Cell[4412, 157, 957, 35, 70, "SeeAlso",
 CellID->27781]
}, Open  ]],
Cell[CellGroupData[{
Cell[5406, 197, 314, 9, 70, "TutorialsSection",
 CellID->17299],
Cell[5723, 208, 135, 3, 70, "Tutorials",
 CellID->18826]
}, Open  ]],
Cell[5873, 214, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

