(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9147,        321]
NotebookOptionsPosition[      7386,        263]
NotebookOutlinePosition[      8337,        290]
CellTagsIndexPosition[      8294,        287]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hundredweight" :> 
          Documentation`HelpLookup["paclet:Units/ref/Hundredweight"], 
          "GrossHundredweight" :> 
          Documentation`HelpLookup["paclet:Units/ref/GrossHundredweight"], 
          "Stone" :> Documentation`HelpLookup["paclet:Units/ref/Stone"], 
          "AvoirdupoisPound" :> 
          Documentation`HelpLookup["paclet:Units/ref/AvoirdupoisPound"], 
          "ShortTon" :> Documentation`HelpLookup["paclet:Units/ref/ShortTon"],
           "Tonne" :> Documentation`HelpLookup["paclet:Units/ref/Tonne"], 
          "MetricTon" :> 
          Documentation`HelpLookup["paclet:Units/ref/MetricTon"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Hundredweight\"\>", 
       2->"\<\"GrossHundredweight\"\>", 3->"\<\"Stone\"\>", 
       4->"\<\"AvoirdupoisPound\"\>", 5->"\<\"ShortTon\"\>", 
       6->"\<\"Tonne\"\>", 7->"\<\"MetricTon\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LongTon", "ObjectName", "Ton",
 CellID->28954],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["LongTon"], "InlineFormula"],
     " \[LineSeparator]is a unit of weight."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23231]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["LongTon"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"1016.05", " ", 
   ButtonBox["Kilogram",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Kilogram"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->27428],

Cell[TextData[{
 Cell[BoxData["LongTon"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"2240", " ", 
   ButtonBox["Pound",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Pound"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->8739],

Cell[TextData[{
 Cell[BoxData["LongTon"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"28", "/", "25"}], ")"}], " ", 
   ButtonBox["Ton",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Ton"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->5134],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "LongTon"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "LongTon"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->19269]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13995],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hundredweight",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Hundredweight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GrossHundredweight",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/GrossHundredweight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Stone",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Stone"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AvoirdupoisPound",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/AvoirdupoisPound"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShortTon",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/ShortTon"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tonne",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Tonne"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MetricTon",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/MetricTon"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24129]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18863],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->16759]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LongTon - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 10, 43.7750674}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "LongTon is a unit of weight.", "synonyms" -> {}, "title" -> 
    "LongTon", "type" -> "Symbol", "uri" -> "Units/ref/LongTon"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1858, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2481, 69, 52, 1, 70, "ObjectName",
 CellID->28954],
Cell[2536, 72, 317, 10, 70, "Usage",
 CellID->23231]
}, Open  ]],
Cell[CellGroupData[{
Cell[2890, 87, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3368, 104, 298, 10, 70, "Notes",
 CellID->27428],
Cell[3669, 116, 263, 10, 70, "Notes",
 CellID->8739],
Cell[3935, 128, 307, 12, 70, "Notes",
 CellID->5134],
Cell[4245, 142, 505, 19, 70, "Notes",
 CellID->19269]
}, Closed]],
Cell[CellGroupData[{
Cell[4787, 166, 311, 9, 70, "SeeAlsoSection",
 CellID->13995],
Cell[5101, 177, 1754, 62, 70, "SeeAlso",
 CellID->24129]
}, Open  ]],
Cell[CellGroupData[{
Cell[6892, 244, 314, 9, 70, "TutorialsSection",
 CellID->18863],
Cell[7209, 255, 135, 3, 70, "Tutorials",
 CellID->16759]
}, Open  ]],
Cell[7359, 261, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

