(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7642,        266]
NotebookOptionsPosition[      5971,        211]
NotebookOutlinePosition[      6939,        239]
CellTagsIndexPosition[      6896,        236]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Lux" :> Documentation`HelpLookup["paclet:Units/ref/Lux"], 
          "Lambert" :> Documentation`HelpLookup["paclet:Units/ref/Lambert"], 
          "Talbot" :> Documentation`HelpLookup["paclet:Units/ref/Talbot"], 
          "Apostilb" :> Documentation`HelpLookup["paclet:Units/ref/Apostilb"],
           "Candle" :> Documentation`HelpLookup["paclet:Units/ref/Candle"], 
          "FootCandle" :> 
          Documentation`HelpLookup["paclet:Units/ref/FootCandle"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Lux\"\>", 2->"\<\"Lambert\"\>", 
       3->"\<\"Talbot\"\>", 4->"\<\"Apostilb\"\>", 5->"\<\"Candle\"\>", 
       6->"\<\"FootCandle\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Lumen", "ObjectName",
 CellID->30336],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Lumen"], "InlineFormula"],
     " \[LineSeparator]is the derived SI unit of luminous flux."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28007]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Lumen"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Candela",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Candela"], " ", 
   ButtonBox["Steradian",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Steradian"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->17646],

Cell[TextData[{
 Cell[BoxData["Lumen"], "InlineFormula"],
 " is typically abbreviated as lm."
}], "Notes",
 CellID->12436]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3144],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lux",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Lux"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lambert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Lambert"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Talbot",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Talbot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Apostilb",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Apostilb"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Candle",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Candle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FootCandle",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/FootCandle"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->776437234]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25126],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->20049]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Lumen - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 10, 50.5721164}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Lumen is the derived SI unit of luminous flux.", 
    "synonyms" -> {}, "title" -> "Lumen", "type" -> "Symbol", "uri" -> 
    "Units/ref/Lumen"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1636, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2259, 64, 43, 1, 70, "ObjectName",
 CellID->30336],
Cell[2305, 67, 335, 10, 70, "Usage",
 CellID->28007]
}, Open  ]],
Cell[CellGroupData[{
Cell[2677, 82, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3155, 99, 355, 13, 70, "Notes",
 CellID->17646],
Cell[3513, 114, 122, 4, 70, "Notes",
 CellID->12436]
}, Closed]],
Cell[CellGroupData[{
Cell[3672, 123, 310, 9, 70, "SeeAlsoSection",
 CellID->3144],
Cell[3985, 134, 1455, 53, 70, "SeeAlso",
 CellID->776437234]
}, Open  ]],
Cell[CellGroupData[{
Cell[5477, 192, 314, 9, 70, "TutorialsSection",
 CellID->25126],
Cell[5794, 203, 135, 3, 70, "Tutorials",
 CellID->20049]
}, Open  ]],
Cell[5944, 209, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

