(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7187,        259]
NotebookOptionsPosition[      5452,        202]
NotebookOutlinePosition[      6425,        230]
CellTagsIndexPosition[      6382,        227]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FootCandle" :> 
          Documentation`HelpLookup["paclet:Units/ref/FootCandle"], "Phot" :> 
          Documentation`HelpLookup["paclet:Units/ref/Phot"], "Candela" :> 
          Documentation`HelpLookup["paclet:Units/ref/Candela"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FootCandle\"\>", 2->"\<\"Phot\"\>", 
       3->"\<\"Candela\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Lux", "ObjectName",
 CellID->23704],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Lux"], "InlineFormula"],
     " \[LineSeparator]is the derived SI unit of illumination (illuminance)."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22655]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Lux"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Lumen",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Lumen"], "/", 
   SuperscriptBox[
    ButtonBox["Meter",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Meter"], "2"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->32535],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Lux"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Lux"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->248156716],

Cell[TextData[{
 Cell[BoxData["Lux"], "InlineFormula"],
 " is typically abbreviated as lx."
}], "Notes",
 CellID->21780]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25764],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FootCandle",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/FootCandle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Phot",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Phot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Candela",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Candela"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->268562895]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27582],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->15371]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Lux - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 10, 50.9158752}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Lux is the derived SI unit of illumination (illuminance).", 
    "synonyms" -> {}, "title" -> "Lux", "type" -> "Symbol", "uri" -> 
    "Units/ref/Lux"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1334, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1957, 60, 41, 1, 70, "ObjectName",
 CellID->23704],
Cell[2001, 63, 346, 10, 70, "Usage",
 CellID->22655]
}, Open  ]],
Cell[CellGroupData[{
Cell[2384, 78, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2862, 95, 369, 14, 70, "Notes",
 CellID->32535],
Cell[3234, 111, 501, 19, 70, "Notes",
 CellID->248156716],
Cell[3738, 132, 120, 4, 70, "Notes",
 CellID->21780]
}, Closed]],
Cell[CellGroupData[{
Cell[3895, 141, 311, 9, 70, "SeeAlsoSection",
 CellID->25764],
Cell[4209, 152, 712, 26, 70, "SeeAlso",
 CellID->268562895]
}, Open  ]],
Cell[CellGroupData[{
Cell[4958, 183, 314, 9, 70, "TutorialsSection",
 CellID->27582],
Cell[5275, 194, 135, 3, 70, "Tutorials",
 CellID->15371]
}, Open  ]],
Cell[5425, 200, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

