(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7861,        278]
NotebookOptionsPosition[      6131,        221]
NotebookOutlinePosition[      7108,        249]
CellTagsIndexPosition[      7065,        246]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Gauss" :> Documentation`HelpLookup["paclet:Units/ref/Gauss"], 
          "Oersted" :> Documentation`HelpLookup["paclet:Units/ref/Oersted"], 
          "BohrMagneton" :> 
          Documentation`HelpLookup["paclet:Units/ref/BohrMagneton"], 
          "NuclearMagneton" :> 
          Documentation`HelpLookup["paclet:Units/ref/NuclearMagneton"], "CGS" :> 
          Documentation`HelpLookup["paclet:Units/ref/CGS"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Gauss\"\>", 2->"\<\"Oersted\"\>", 
       3->"\<\"BohrMagneton\"\>", 4->"\<\"NuclearMagneton\"\>", 
       5->"\<\"CGS\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Maxwell", "ObjectName",
 CellID->21693],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Maxwell"], "InlineFormula"],
     " \[LineSeparator]is the derived CGS unit of magnetic flux."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26945]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Maxwell"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Weber",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Weber"], "/", 
   SuperscriptBox["10", "8"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->11859],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Maxwell"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Maxwell"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->31665],

Cell[TextData[{
 Cell[BoxData["Maxwell"], "InlineFormula"],
 " is typically abbreviated as Mx."
}], "Notes",
 CellID->4233]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21067],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gauss",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Gauss"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Oersted",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Oersted"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BohrMagneton",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/BohrMagneton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NuclearMagneton",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/NuclearMagneton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CGS",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/CGS"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13933]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8989],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->24636]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Maxwell - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 10, 51.2283832}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Maxwell is the derived CGS unit of magnetic flux.", 
    "synonyms" -> {}, "title" -> "Maxwell", "type" -> "Symbol", "uri" -> 
    "Units/ref/Maxwell"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1574, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2197, 64, 45, 1, 70, "ObjectName",
 CellID->21693],
Cell[2245, 67, 338, 10, 70, "Usage",
 CellID->26945]
}, Open  ]],
Cell[CellGroupData[{
Cell[2620, 82, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3098, 99, 298, 11, 70, "Notes",
 CellID->11859],
Cell[3399, 112, 505, 19, 70, "Notes",
 CellID->31665],
Cell[3907, 133, 123, 4, 70, "Notes",
 CellID->4233]
}, Closed]],
Cell[CellGroupData[{
Cell[4067, 142, 311, 9, 70, "SeeAlsoSection",
 CellID->21067],
Cell[4381, 153, 1220, 44, 70, "SeeAlso",
 CellID->13933]
}, Open  ]],
Cell[CellGroupData[{
Cell[5638, 202, 313, 9, 70, "TutorialsSection",
 CellID->8989],
Cell[5954, 213, 135, 3, 70, "Tutorials",
 CellID->24636]
}, Open  ]],
Cell[6104, 219, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

