(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6766,        248]
NotebookOptionsPosition[      5061,        192]
NotebookOutlinePosition[      6010,        219]
CellTagsIndexPosition[      5967,        216]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Abmho" :> Documentation`HelpLookup["paclet:Units/ref/Abmho"], 
          "Siemens" :> 
          Documentation`HelpLookup["paclet:Units/ref/Siemens"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Abmho\"\>", 
       2->"\<\"Siemens\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Mho", "ObjectName",
 CellID->15431],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Mho"], "InlineFormula"],
     " \[LineSeparator]is a unit of electric conductance."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2080]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Mho"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"1", "/", 
   ButtonBox["Ohm",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Ohm"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->21459],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Mho"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Mho"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->31985],

Cell[TextData[{
 Cell[BoxData["Mho"], "InlineFormula"],
 " is typically abbreviated as ",
 Cell[BoxData[
  SuperscriptBox["\[CapitalOmega]", 
   RowBox[{"-", "1"}]]], "InlineFormula"],
 "."
}], "Notes",
 CellID->179905296]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14319],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Abmho",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Abmho"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Siemens",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Siemens"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4588]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20260],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->22871]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Mho - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 10, 51.8846500}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Mho is a unit of electric conductance.", "synonyms" -> {}, 
    "title" -> "Mho", "type" -> "Symbol", "uri" -> "Units/ref/Mho"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1228, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1851, 59, 41, 1, 70, "ObjectName",
 CellID->15431],
Cell[1895, 62, 326, 10, 70, "Usage",
 CellID->2080]
}, Open  ]],
Cell[CellGroupData[{
Cell[2258, 77, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2736, 94, 264, 10, 70, "Notes",
 CellID->21459],
Cell[3003, 106, 497, 19, 70, "Notes",
 CellID->31985],
Cell[3503, 127, 222, 8, 70, "Notes",
 CellID->179905296]
}, Closed]],
Cell[CellGroupData[{
Cell[3762, 140, 311, 9, 70, "SeeAlsoSection",
 CellID->14319],
Cell[4076, 151, 454, 17, 70, "SeeAlso",
 CellID->4588]
}, Open  ]],
Cell[CellGroupData[{
Cell[4567, 173, 314, 9, 70, "TutorialsSection",
 CellID->20260],
Cell[4884, 184, 135, 3, 70, "Tutorials",
 CellID->22871]
}, Open  ]],
Cell[5034, 190, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

