(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6254,        222]
NotebookOptionsPosition[      4581,        167]
NotebookOutlinePosition[      5554,        195]
CellTagsIndexPosition[      5511,        192]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AtomicMassUnit" :> 
          Documentation`HelpLookup["paclet:Units/ref/AtomicMassUnit"], 
          "AvogadroConstant" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/AvogadroConstant"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AtomicMassUnit\"\>", 
       2->"\<\"AvogadroConstant\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Mole", "ObjectName",
 CellID->3398],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Mole"], "InlineFormula"],
     " \[LineSeparator]is the fundamental SI unit of amount of substance."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31728]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Mole"], "InlineFormula"],
 " is equal to approximately ",
 Cell[BoxData[
  RowBox[{"6.0221367", "\[Times]", 
   SuperscriptBox["10", "23"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->10049],

Cell[TextData[{
 Cell[BoxData["Mole"], "InlineFormula"],
 " is typically abbreviated as mol."
}], "Notes",
 CellID->25668]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11723],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AtomicMassUnit",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/AtomicMassUnit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AvogadroConstant",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/AvogadroConstant"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->304326185]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24456],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->4973]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Mole - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 11, 6.8537832}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Mole is the fundamental SI unit of amount of substance.", 
    "synonyms" -> {}, "title" -> "Mole", "type" -> "Symbol", "uri" -> 
    "Units/ref/Mole"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1317, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1940, 61, 41, 1, 70, "ObjectName",
 CellID->3398],
Cell[1984, 64, 344, 10, 70, "Usage",
 CellID->31728]
}, Open  ]],
Cell[CellGroupData[{
Cell[2365, 79, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2843, 96, 225, 8, 70, "Notes",
 CellID->10049],
Cell[3071, 106, 122, 4, 70, "Notes",
 CellID->25668]
}, Closed]],
Cell[CellGroupData[{
Cell[3230, 115, 311, 9, 70, "SeeAlsoSection",
 CellID->11723],
Cell[3544, 126, 507, 17, 70, "SeeAlso",
 CellID->304326185]
}, Open  ]],
Cell[CellGroupData[{
Cell[4088, 148, 314, 9, 70, "TutorialsSection",
 CellID->24456],
Cell[4405, 159, 134, 3, 70, "Tutorials",
 CellID->4973]
}, Open  ]],
Cell[4554, 165, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

