(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8881,        312]
NotebookOptionsPosition[      7187,        256]
NotebookOutlinePosition[      8127,        283]
CellTagsIndexPosition[      8084,        280]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Day" :> Documentation`HelpLookup["paclet:Units/ref/Day"], 
          "Week" :> Documentation`HelpLookup["paclet:Units/ref/Week"], "Hour" :> 
          Documentation`HelpLookup["paclet:Units/ref/Hour"], "Minute" :> 
          Documentation`HelpLookup["paclet:Units/ref/Minute"], "Decade" :> 
          Documentation`HelpLookup["paclet:Units/ref/Decade"], "Century" :> 
          Documentation`HelpLookup["paclet:Units/ref/Century"], "Millennium" :> 
          Documentation`HelpLookup["paclet:Units/ref/Millennium"], 
          "Fortnight" :> 
          Documentation`HelpLookup["paclet:Units/ref/Fortnight"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Day\"\>", 2->"\<\"Week\"\>", 
       3->"\<\"Hour\"\>", 4->"\<\"Minute\"\>", 5->"\<\"Decade\"\>", 
       6->"\<\"Century\"\>", 7->"\<\"Millennium\"\>", 
       8->"\<\"Fortnight\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Month", "ObjectName",
 CellID->25020],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Month"], "InlineFormula"],
     " \[LineSeparator]is a unit of time."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28522]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Month"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"2628000", " ", 
   ButtonBox["Second",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Second"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->29454],

Cell[TextData[{
 Cell[BoxData["Month"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Year",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Year"], "/", "12"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->19398],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Month"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Month"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->6564]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19293],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Day",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Day"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Week",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Week"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hour",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Hour"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Minute",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Minute"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Decade",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Decade"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Century",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Century"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Millennium",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Millennium"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fortnight",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Fortnight"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2287]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24365],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->7063]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Month - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 11, 6.9944118}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Month is a unit of time.", "synonyms" -> {}, "title" -> 
    "Month", "type" -> "Symbol", "uri" -> "Units/ref/Month"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1829, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2452, 67, 43, 1, 70, "ObjectName",
 CellID->25020],
Cell[2498, 70, 313, 10, 70, "Usage",
 CellID->28522]
}, Open  ]],
Cell[CellGroupData[{
Cell[2848, 85, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3326, 102, 278, 10, 70, "Notes",
 CellID->29454],
Cell[3607, 114, 258, 10, 70, "Notes",
 CellID->19398],
Cell[3868, 126, 500, 19, 70, "Notes",
 CellID->6564]
}, Closed]],
Cell[CellGroupData[{
Cell[4405, 150, 311, 9, 70, "SeeAlsoSection",
 CellID->19293],
Cell[4719, 161, 1938, 71, 70, "SeeAlso",
 CellID->2287]
}, Open  ]],
Cell[CellGroupData[{
Cell[6694, 237, 314, 9, 70, "TutorialsSection",
 CellID->24365],
Cell[7011, 248, 134, 3, 70, "Tutorials",
 CellID->7063]
}, Open  ]],
Cell[7160, 254, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

