(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8176,        283]
NotebookOptionsPosition[      6514,        229]
NotebookOutlinePosition[      7472,        256]
CellTagsIndexPosition[      7429,        253]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Joule" :> Documentation`HelpLookup["paclet:Units/ref/Joule"], 
          "Pascal" :> Documentation`HelpLookup["paclet:Units/ref/Pascal"], 
          "PoundForce" :> 
          Documentation`HelpLookup["paclet:Units/ref/PoundForce"], 
          "KilogramForce" :> 
          Documentation`HelpLookup["paclet:Units/ref/KilogramForce"], 
          "Poundal" :> Documentation`HelpLookup["paclet:Units/ref/Poundal"], 
          "Dyne" :> Documentation`HelpLookup["paclet:Units/ref/Dyne"], 
          "TonForce" :> 
          Documentation`HelpLookup["paclet:Units/ref/TonForce"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Joule\"\>", 2->"\<\"Pascal\"\>", 
       3->"\<\"PoundForce\"\>", 4->"\<\"KilogramForce\"\>", 
       5->"\<\"Poundal\"\>", 6->"\<\"Dyne\"\>", 
       7->"\<\"TonForce\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Newton", "ObjectName",
 CellID->25830],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Newton"], "InlineFormula"],
     " \[LineSeparator]is the derived SI unit of force."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16724]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Newton"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Kilogram",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Kilogram"], " ", 
   RowBox[{
    ButtonBox["Meter",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Meter"], "/", 
    SuperscriptBox[
     ButtonBox["Second",
      BaseStyle->"Link",
      ButtonData->"paclet:Units/ref/Second"], "2"]}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->4854],

Cell[TextData[{
 Cell[BoxData["Newton"], "InlineFormula"],
 " is typically abbreviated as N."
}], "Notes",
 CellID->13179]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22923],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Joule",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Joule"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pascal",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Pascal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PoundForce",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/PoundForce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["KilogramForce",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/KilogramForce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Poundal",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Poundal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dyne",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Dyne"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TonForce",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/TonForce"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->321918758]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29472],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->27718]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Newton - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 11, 7.6194278}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Newton is the derived SI unit of force.", "synonyms" -> {}, 
    "title" -> "Newton", "type" -> "Symbol", "uri" -> "Units/ref/Newton"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1784, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2407, 68, 44, 1, 70, "ObjectName",
 CellID->25830],
Cell[2454, 71, 328, 10, 70, "Usage",
 CellID->16724]
}, Open  ]],
Cell[CellGroupData[{
Cell[2819, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3297, 103, 494, 18, 70, "Notes",
 CellID->4854],
Cell[3794, 123, 122, 4, 70, "Notes",
 CellID->13179]
}, Closed]],
Cell[CellGroupData[{
Cell[3953, 132, 311, 9, 70, "SeeAlsoSection",
 CellID->22923],
Cell[4267, 143, 1716, 62, 70, "SeeAlso",
 CellID->321918758]
}, Open  ]],
Cell[CellGroupData[{
Cell[6020, 210, 314, 9, 70, "TutorialsSection",
 CellID->29472],
Cell[6337, 221, 135, 3, 70, "Tutorials",
 CellID->27718]
}, Open  ]],
Cell[6487, 227, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

