(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7451,        267]
NotebookOptionsPosition[      5755,        211]
NotebookOutlinePosition[      6702,        238]
CellTagsIndexPosition[      6659,        235]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AstronomicalUnit" :> 
          Documentation`HelpLookup["paclet:Units/ref/AstronomicalUnit"], 
          "Mile" :> Documentation`HelpLookup["paclet:Units/ref/Mile"], 
          "LightYear" :> 
          Documentation`HelpLookup["paclet:Units/ref/LightYear"], "AU" :> 
          Documentation`HelpLookup["paclet:Units/ref/AU"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AstronomicalUnit\"\>", 
       2->"\<\"Mile\"\>", 3->"\<\"LightYear\"\>", 
       4->"\<\"AU\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Parsec", "ObjectName",
 CellID->16972],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Parsec"], "InlineFormula"],
     " \[LineSeparator]is a unit of length."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2715]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Parsec"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"30.857", "\[Times]", 
   SuperscriptBox["10", "15"], " ", 
   ButtonBox["Meter",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Meter"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->8663],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Parsec"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Parsec"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->6493],

Cell[TextData[{
 Cell[BoxData["Parsec"], "InlineFormula"],
 " is typically abbreviated as pc."
}], "Notes",
 CellID->4623]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17395],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AstronomicalUnit",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/AstronomicalUnit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mile",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Mile"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LightYear",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/LightYear"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AU",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/AU"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27905]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1368],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->25036]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Parsec - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 11, 15.9477660}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Parsec is a unit of length.", "synonyms" -> {}, "title" -> 
    "Parsec", "type" -> "Symbol", "uri" -> "Units/ref/Parsec"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1462, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2085, 63, 44, 1, 70, "ObjectName",
 CellID->16972],
Cell[2132, 66, 315, 10, 70, "Usage",
 CellID->2715]
}, Open  ]],
Cell[CellGroupData[{
Cell[2484, 81, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2962, 98, 319, 11, 70, "Notes",
 CellID->8663],
Cell[3284, 111, 502, 19, 70, "Notes",
 CellID->6493],
Cell[3789, 132, 122, 4, 70, "Notes",
 CellID->4623]
}, Closed]],
Cell[CellGroupData[{
Cell[3948, 141, 311, 9, 70, "SeeAlsoSection",
 CellID->17395],
Cell[4262, 152, 963, 35, 70, "SeeAlso",
 CellID->27905]
}, Open  ]],
Cell[CellGroupData[{
Cell[5262, 192, 313, 9, 70, "TutorialsSection",
 CellID->1368],
Cell[5578, 203, 135, 3, 70, "Tutorials",
 CellID->25036]
}, Open  ]],
Cell[5728, 209, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

