(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8128,        288]
NotebookOptionsPosition[      6405,        231]
NotebookOutlinePosition[      7379,        259]
CellTagsIndexPosition[      7336,        256]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Reyn" :> Documentation`HelpLookup["paclet:Units/ref/Reyn"], 
          "Centi" :> Documentation`HelpLookup["paclet:Units/ref/Centi"], 
          "Deci" :> Documentation`HelpLookup["paclet:Units/ref/Deci"], 
          "Stokes" :> Documentation`HelpLookup["paclet:Units/ref/Stokes"], 
          "CGS" :> Documentation`HelpLookup["paclet:Units/ref/CGS"], "Rhes" :> 
          Documentation`HelpLookup["paclet:Units/ref/Rhes"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Reyn\"\>", 2->"\<\"Centi\"\>", 
       3->"\<\"Deci\"\>", 4->"\<\"Stokes\"\>", 5->"\<\"CGS\"\>", 
       6->"\<\"Rhes\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Poise", "ObjectName",
 CellID->9720],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Poise"], "InlineFormula"],
     " \[LineSeparator]is the derived CGS unit of absolute viscosity."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17253]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Poise"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"0.1", " ", 
   ButtonBox["Pascal",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Pascal"], " ", 
   ButtonBox["Second",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Second"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->3041],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Poise"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Poise"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->7833],

Cell[TextData[{
 Cell[BoxData["Poise"], "InlineFormula"],
 " is typically abbreviated as P."
}], "Notes",
 CellID->30361]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10863],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reyn",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Reyn"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Centi",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Centi"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Deci",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Deci"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Stokes",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Stokes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CGS",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/CGS"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rhes",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Rhes"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10502]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->10602]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Poise - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 11, 30.8075214}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Poise is the derived CGS unit of absolute viscosity.", 
    "synonyms" -> {}, "title" -> "Poise", "type" -> "Symbol", "uri" -> 
    "Units/ref/Poise"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1583, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2206, 63, 42, 1, 70, "ObjectName",
 CellID->9720],
Cell[2251, 66, 341, 10, 70, "Usage",
 CellID->17253]
}, Open  ]],
Cell[CellGroupData[{
Cell[2629, 81, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3107, 98, 369, 13, 70, "Notes",
 CellID->3041],
Cell[3479, 113, 500, 19, 70, "Notes",
 CellID->7833],
Cell[3982, 134, 121, 4, 70, "Notes",
 CellID->30361]
}, Closed]],
Cell[CellGroupData[{
Cell[4140, 143, 311, 9, 70, "SeeAlsoSection",
 CellID->10863],
Cell[4454, 154, 1423, 53, 70, "SeeAlso",
 CellID->10502]
}, Open  ]],
Cell[CellGroupData[{
Cell[5914, 212, 311, 9, 70, "TutorialsSection",
 CellID->19],
Cell[6228, 223, 135, 3, 70, "Tutorials",
 CellID->10602]
}, Open  ]],
Cell[6378, 229, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

