(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10411,        357]
NotebookOptionsPosition[      8660,        299]
NotebookOutlinePosition[      9603,        326]
CellTagsIndexPosition[      9560,        323]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AvoirdupoisPound" :> 
          Documentation`HelpLookup["paclet:Units/ref/AvoirdupoisPound"], 
          "Gram" :> Documentation`HelpLookup["paclet:Units/ref/Gram"], 
          "AvoirdupoisOunce" :> 
          Documentation`HelpLookup["paclet:Units/ref/AvoirdupoisOunce"], 
          "Grain" :> Documentation`HelpLookup["paclet:Units/ref/Grain"], 
          "Stone" :> Documentation`HelpLookup["paclet:Units/ref/Stone"], 
          "Hundredweight" :> 
          Documentation`HelpLookup["paclet:Units/ref/Hundredweight"], 
          "ShortHundredweight" :> 
          Documentation`HelpLookup["paclet:Units/ref/ShortHundredweight"], 
          "NetHundredweight" :> 
          Documentation`HelpLookup["paclet:Units/ref/NetHundredweight"], 
          "Ton" :> Documentation`HelpLookup["paclet:Units/ref/Ton"], 
          "ShortTon" :> Documentation`HelpLookup["paclet:Units/ref/ShortTon"],
           "LongTon" :> 
          Documentation`HelpLookup["paclet:Units/ref/LongTon"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AvoirdupoisPound\"\>", 
       2->"\<\"Gram\"\>", 3->"\<\"AvoirdupoisOunce\"\>", 4->"\<\"Grain\"\>", 
       5->"\<\"Stone\"\>", 6->"\<\"Hundredweight\"\>", 
       7->"\<\"ShortHundredweight\"\>", 8->"\<\"NetHundredweight\"\>", 
       9->"\<\"Ton\"\>", 10->"\<\"ShortTon\"\>", 
       11->"\<\"LongTon\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Pound", "ObjectName",
 CellID->11485],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Pound"], "InlineFormula"],
     " \[LineSeparator]is a unit of weight."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13462]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Pound"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"0.453592", " ", 
   ButtonBox["Kilogram",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Kilogram"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->22576],

Cell[TextData[{
 Cell[BoxData["Pound"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"16", " ", 
   ButtonBox["Ounce",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Ounce"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->17789],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Pound"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Pound"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->7159],

Cell[TextData[{
 Cell[BoxData["Pound"], "InlineFormula"],
 " is typically abbreviated as lb."
}], "Notes",
 CellID->2386]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23224],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AvoirdupoisPound",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/AvoirdupoisPound"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gram",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Gram"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AvoirdupoisOunce",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/AvoirdupoisOunce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Grain",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Grain"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Stone",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Stone"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hundredweight",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Hundredweight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShortHundredweight",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/ShortHundredweight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NetHundredweight",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/NetHundredweight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ton",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Ton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShortTon",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/ShortTon"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LongTon",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/LongTon"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28886]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19222],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->5055]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Pound - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 11, 31.9325502}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Pound is a unit of weight.", "synonyms" -> {}, "title" -> 
    "Pound", "type" -> "Symbol", "uri" -> "Units/ref/Pound"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2325, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2948, 77, 43, 1, 70, "ObjectName",
 CellID->11485],
Cell[2994, 80, 315, 10, 70, "Usage",
 CellID->13462]
}, Open  ]],
Cell[CellGroupData[{
Cell[3346, 95, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3824, 112, 297, 10, 70, "Notes",
 CellID->22576],
Cell[4124, 124, 260, 10, 70, "Notes",
 CellID->17789],
Cell[4387, 136, 500, 19, 70, "Notes",
 CellID->7159],
Cell[4890, 157, 121, 4, 70, "Notes",
 CellID->2386]
}, Closed]],
Cell[CellGroupData[{
Cell[5048, 166, 311, 9, 70, "SeeAlsoSection",
 CellID->23224],
Cell[5362, 177, 2768, 98, 70, "SeeAlso",
 CellID->28886]
}, Open  ]],
Cell[CellGroupData[{
Cell[8167, 280, 314, 9, 70, "TutorialsSection",
 CellID->19222],
Cell[8484, 291, 134, 3, 70, "Tutorials",
 CellID->5055]
}, Open  ]],
Cell[8633, 297, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

