(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7788,        277]
NotebookOptionsPosition[      6075,        220]
NotebookOutlinePosition[      7035,        248]
CellTagsIndexPosition[      6992,        245]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Becquerel" :> 
          Documentation`HelpLookup["paclet:Units/ref/Becquerel"], 
          "Rutherford" :> 
          Documentation`HelpLookup["paclet:Units/ref/Rutherford"], "Curie" :> 
          Documentation`HelpLookup["paclet:Units/ref/Curie"], "Rontgen" :> 
          Documentation`HelpLookup["paclet:Units/ref/Rontgen"], "Roentgen" :> 
          Documentation`HelpLookup["paclet:Units/ref/Roentgen"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Becquerel\"\>", 
       2->"\<\"Rutherford\"\>", 3->"\<\"Curie\"\>", 4->"\<\"Rontgen\"\>", 
       5->"\<\"Roentgen\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Rad", "ObjectName",
 CellID->32282],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Rad"], "InlineFormula"],
     " \[LineSeparator]is a unit of absorbed dose of radiation."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11983]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Rad"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"0.01", " ", 
   ButtonBox["GrayDose",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/GrayDose"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->1792],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Rad"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Rad"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->27307],

Cell[TextData[{
 Cell[BoxData["Rad"], "InlineFormula"],
 " is typically abbreviated as rad."
}], "Notes",
 CellID->14693]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19824],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Becquerel",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Becquerel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rutherford",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Rutherford"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Curie",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Curie"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rontgen",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Rontgen"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Roentgen",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Roentgen"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4990]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25786],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->19999]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Rad - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 11, 40.1202598}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Rad is a unit of absorbed dose of radiation.", 
    "synonyms" -> {}, "title" -> "Rad", "type" -> "Symbol", "uri" -> 
    "Units/ref/Rad"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1565, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2188, 64, 41, 1, 70, "ObjectName",
 CellID->32282],
Cell[2232, 67, 333, 10, 70, "Usage",
 CellID->11983]
}, Open  ]],
Cell[CellGroupData[{
Cell[2602, 82, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3080, 99, 276, 10, 70, "Notes",
 CellID->1792],
Cell[3359, 111, 497, 19, 70, "Notes",
 CellID->27307],
Cell[3859, 132, 121, 4, 70, "Notes",
 CellID->14693]
}, Closed]],
Cell[CellGroupData[{
Cell[4017, 141, 311, 9, 70, "SeeAlsoSection",
 CellID->19824],
Cell[4331, 152, 1213, 44, 70, "SeeAlso",
 CellID->4990]
}, Open  ]],
Cell[CellGroupData[{
Cell[5581, 201, 314, 9, 70, "TutorialsSection",
 CellID->25786],
Cell[5898, 212, 135, 3, 70, "Tutorials",
 CellID->19999]
}, Open  ]],
Cell[6048, 218, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

