(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8275,        291]
NotebookOptionsPosition[      6547,        234]
NotebookOutlinePosition[      7521,        262]
CellTagsIndexPosition[      7478,        259]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RightAngle" :> 
          Documentation`HelpLookup["paclet:Units/ref/RightAngle"], 
          "Steradian" :> 
          Documentation`HelpLookup["paclet:Units/ref/Steradian"], "Quadrant" :> 
          Documentation`HelpLookup["paclet:Units/ref/Quadrant"], "Grade" :> 
          Documentation`HelpLookup["paclet:Units/ref/Grade"], "ArcMinute" :> 
          Documentation`HelpLookup["paclet:Units/ref/ArcMinute"], "ArcSecond" :> 
          Documentation`HelpLookup["paclet:Units/ref/ArcSecond"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"RightAngle\"\>", 
       2->"\<\"Steradian\"\>", 3->"\<\"Quadrant\"\>", 4->"\<\"Grade\"\>", 
       5->"\<\"ArcMinute\"\>", 6->"\<\"ArcSecond\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Radian", "ObjectName",
 CellID->9324],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Radian"], "InlineFormula"],
     " \[LineSeparator]is a dimensionless measure of plane angle."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31792]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Radian"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Radian"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->5786],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"2", " ", 
   ButtonBox["Pi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pi"], " ", "Radian"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"360", " ", 
   ButtonBox["Degree",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Degree"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->11559],

Cell[TextData[{
 Cell[BoxData["Radian"], "InlineFormula"],
 " is typically abbreviated as rad."
}], "Notes",
 CellID->10863]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27025],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RightAngle",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/RightAngle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Steradian",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Steradian"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Quadrant",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Quadrant"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Grade",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Grade"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcMinute",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/ArcMinute"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcSecond",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/ArcSecond"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17993]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29707],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->21803]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Radian - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 11, 39.9483804}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Radian is a dimensionless measure of plane angle.", 
    "synonyms" -> {}, "title" -> "Radian", "type" -> "Symbol", "uri" -> 
    "Units/ref/Radian"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1677, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2300, 65, 43, 1, 70, "ObjectName",
 CellID->9324],
Cell[2346, 68, 338, 10, 70, "Usage",
 CellID->31792]
}, Open  ]],
Cell[CellGroupData[{
Cell[2721, 83, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3199, 100, 502, 19, 70, "Notes",
 CellID->5786],
Cell[3704, 121, 363, 14, 70, "Notes",
 CellID->11559],
Cell[4070, 137, 124, 4, 70, "Notes",
 CellID->10863]
}, Closed]],
Cell[CellGroupData[{
Cell[4231, 146, 311, 9, 70, "SeeAlsoSection",
 CellID->27025],
Cell[4545, 157, 1471, 53, 70, "SeeAlso",
 CellID->17993]
}, Open  ]],
Cell[CellGroupData[{
Cell[6053, 215, 314, 9, 70, "TutorialsSection",
 CellID->29707],
Cell[6370, 226, 135, 3, 70, "Tutorials",
 CellID->21803]
}, Open  ]],
Cell[6520, 232, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

