(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6986,        248]
NotebookOptionsPosition[      5333,        194]
NotebookOutlinePosition[      6289,        221]
CellTagsIndexPosition[      6246,        218]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Celsius" :> 
          Documentation`HelpLookup["paclet:Units/ref/Celsius"], "Fahrenheit" :> 
          Documentation`HelpLookup["paclet:Units/ref/Fahrenheit"], 
          "Centigrade" :> 
          Documentation`HelpLookup["paclet:Units/ref/Centigrade"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Celsius\"\>", 
       2->"\<\"Fahrenheit\"\>", 3->"\<\"Centigrade\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Rankine", "ObjectName",
 CellID->31690],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Rankine"], "InlineFormula"],
     " \[LineSeparator]is a unit of temperature."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20117]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A temperature range of one ",
 Cell[BoxData["Rankine"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"5", "/", "9"}], " ", 
   ButtonBox["Kelvin",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Kelvin"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->6254],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ConvertTemperature",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/ConvertTemperature"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", " ", "Rankine", ",", " ", 
    StyleBox["newscale", "TI"]}], "]"}]], "InlineFormula"],
 " converts ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " degrees in the Rankine scale into the temperature scale ",
 Cell[BoxData[
  StyleBox["newscale", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->12901]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11410],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Celsius",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Celsius"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fahrenheit",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Fahrenheit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Centigrade",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Centigrade"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->874],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->25426]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Rankine - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 11, 46.6204262}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Rankine is a unit of temperature.", "synonyms" -> {}, 
    "title" -> "Rankine", "type" -> "Symbol", "uri" -> "Units/ref/Rankine"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1371, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1994, 62, 45, 1, 70, "ObjectName",
 CellID->31690],
Cell[2042, 65, 322, 10, 70, "Usage",
 CellID->20117]
}, Open  ]],
Cell[CellGroupData[{
Cell[2401, 80, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2879, 97, 329, 12, 70, "Notes",
 CellID->6254],
Cell[3211, 111, 522, 17, 70, "Notes",
 CellID->12901]
}, Closed]],
Cell[CellGroupData[{
Cell[3770, 133, 311, 9, 70, "SeeAlsoSection",
 CellID->11410],
Cell[4084, 144, 720, 26, 70, "SeeAlso",
 CellID->26938]
}, Open  ]],
Cell[CellGroupData[{
Cell[4841, 175, 312, 9, 70, "TutorialsSection",
 CellID->874],
Cell[5156, 186, 135, 3, 70, "Tutorials",
 CellID->25426]
}, Open  ]],
Cell[5306, 192, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

