(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8250,        293]
NotebookOptionsPosition[      6457,        234]
NotebookOutlinePosition[      7443,        262]
CellTagsIndexPosition[      7400,        259]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Becquerel" :> 
          Documentation`HelpLookup["paclet:Units/ref/Becquerel"], "GrayDose" :> 
          Documentation`HelpLookup["paclet:Units/ref/GrayDose"], "Rad" :> 
          Documentation`HelpLookup["paclet:Units/ref/Rad"], "Rutherford" :> 
          Documentation`HelpLookup["paclet:Units/ref/Rutherford"], "Curie" :> 
          Documentation`HelpLookup["paclet:Units/ref/Curie"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Becquerel\"\>", 
       2->"\<\"GrayDose\"\>", 3->"\<\"Rad\"\>", 4->"\<\"Rutherford\"\>", 
       5->"\<\"Curie\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Roentgen", "ObjectName",
 CellID->31483],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Roentgen"], "InlineFormula"],
     " \[LineSeparator]is a unit of exposure to X or gamma radiation."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14955]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Roentgen"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"0.000258", " ", 
   RowBox[{
    ButtonBox["Coulomb",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Coulomb"], "/", 
    ButtonBox["Kilogram",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Kilogram"]}]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->21902],

Cell[TextData[{
 Cell[BoxData["Roentgen"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  ButtonBox["Rontgen",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Rontgen"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->17021],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Roentgen"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Roentgen"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->8347],

Cell[TextData[{
 Cell[BoxData["Roentgen"], "InlineFormula"],
 " is typically abbreviated as R."
}], "Notes",
 CellID->14258]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5389],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Becquerel",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Becquerel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GrayDose",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/GrayDose"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rad",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Rad"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rutherford",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Rutherford"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Curie",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Curie"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28234]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15754],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->27740]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Roentgen - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 11, 47.8235820}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Roentgen is a unit of exposure to X or gamma radiation.", 
    "synonyms" -> {}, "title" -> "Roentgen", "type" -> "Symbol", "uri" -> 
    "Units/ref/Roentgen"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1542, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2165, 63, 46, 1, 70, "ObjectName",
 CellID->31483],
Cell[2214, 66, 344, 10, 70, "Usage",
 CellID->14955]
}, Open  ]],
Cell[CellGroupData[{
Cell[2595, 81, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3073, 98, 418, 14, 70, "Notes",
 CellID->21902],
Cell[3494, 114, 240, 9, 70, "Notes",
 CellID->17021],
Cell[3737, 125, 506, 19, 70, "Notes",
 CellID->8347],
Cell[4246, 146, 124, 4, 70, "Notes",
 CellID->14258]
}, Closed]],
Cell[CellGroupData[{
Cell[4407, 155, 310, 9, 70, "SeeAlsoSection",
 CellID->5389],
Cell[4720, 166, 1206, 44, 70, "SeeAlso",
 CellID->28234]
}, Open  ]],
Cell[CellGroupData[{
Cell[5963, 215, 314, 9, 70, "TutorialsSection",
 CellID->15754],
Cell[6280, 226, 135, 3, 70, "Tutorials",
 CellID->27740]
}, Open  ]],
Cell[6430, 232, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

