(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8297,        290]
NotebookOptionsPosition[      6562,        233]
NotebookOutlinePosition[      7544,        261]
CellTagsIndexPosition[      7501,        258]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Roentgen" :> 
          Documentation`HelpLookup["paclet:Units/ref/Roentgen"], "Becquerel" :> 
          Documentation`HelpLookup["paclet:Units/ref/Becquerel"], "GrayDose" :> 
          Documentation`HelpLookup["paclet:Units/ref/GrayDose"], "Rad" :> 
          Documentation`HelpLookup["paclet:Units/ref/Rad"], "Rutherford" :> 
          Documentation`HelpLookup["paclet:Units/ref/Rutherford"], "Curie" :> 
          Documentation`HelpLookup["paclet:Units/ref/Curie"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Roentgen\"\>", 
       2->"\<\"Becquerel\"\>", 3->"\<\"GrayDose\"\>", 4->"\<\"Rad\"\>", 
       5->"\<\"Rutherford\"\>", 6->"\<\"Curie\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Rontgen", "ObjectName",
 CellID->6772],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Rontgen"], "InlineFormula"],
     " \[LineSeparator]is a unit of exposure to X or gamma radiation."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5528]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Rontgen"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"0.000258", " ", 
   RowBox[{
    ButtonBox["Coulomb",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Coulomb"], "/", 
    ButtonBox["Kilogram",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Kilogram"]}]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->27185],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Rontgen"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Rontgen"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->22861],

Cell[TextData[{
 Cell[BoxData["Rontgen"], "InlineFormula"],
 " is typically abbreviated as R."
}], "Notes",
 CellID->18548]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14207],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Roentgen",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Roentgen"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Becquerel",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Becquerel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GrayDose",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/GrayDose"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rad",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Rad"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rutherford",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Rutherford"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Curie",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Curie"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14232]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31741],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->31508]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Rontgen - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 11, 48.0110868}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Rontgen is a unit of exposure to X or gamma radiation.", 
    "synonyms" -> {}, "title" -> "Rontgen", "type" -> "Symbol", "uri" -> 
    "Units/ref/Rontgen"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1645, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2268, 64, 44, 1, 70, "ObjectName",
 CellID->6772],
Cell[2315, 67, 342, 10, 70, "Usage",
 CellID->5528]
}, Open  ]],
Cell[CellGroupData[{
Cell[2694, 82, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3172, 99, 417, 14, 70, "Notes",
 CellID->27185],
Cell[3592, 115, 505, 19, 70, "Notes",
 CellID->22861],
Cell[4100, 136, 123, 4, 70, "Notes",
 CellID->18548]
}, Closed]],
Cell[CellGroupData[{
Cell[4260, 145, 311, 9, 70, "SeeAlsoSection",
 CellID->14207],
Cell[4574, 156, 1457, 53, 70, "SeeAlso",
 CellID->14232]
}, Open  ]],
Cell[CellGroupData[{
Cell[6068, 214, 314, 9, 70, "TutorialsSection",
 CellID->31741],
Cell[6385, 225, 135, 3, 70, "Tutorials",
 CellID->31508]
}, Open  ]],
Cell[6535, 231, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

