(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7856,        282]
NotebookOptionsPosition[      6168,        226]
NotebookOutlinePosition[      7105,        253]
CellTagsIndexPosition[      7062,        250]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hectare" :> 
          Documentation`HelpLookup["paclet:Units/ref/Hectare"], "Are" :> 
          Documentation`HelpLookup["paclet:Units/ref/Are"], "Section" :> 
          Documentation`HelpLookup["paclet:Units/ref/Section"], "Township" :> 
          Documentation`HelpLookup["paclet:Units/ref/Township"], "Barn" :> 
          Documentation`HelpLookup["paclet:Units/ref/Barn"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Hectare\"\>", 2->"\<\"Are\"\>", 
       3->"\<\"Section\"\>", 4->"\<\"Township\"\>", 
       5->"\<\"Barn\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Rood", "ObjectName",
 CellID->17468],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Rood"], "InlineFormula"],
     " \[LineSeparator]is a unit of area."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5590]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Rood"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"1011.71", " ", 
   SuperscriptBox[
    ButtonBox["Meter",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Meter"], "2"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->31987],

Cell[TextData[{
 Cell[BoxData["Rood"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Acre",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Acre"], "/", "4"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->16846],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Rood"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Rood"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->6878]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8583],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hectare",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Hectare"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Are",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Are"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Section",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Section"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Township",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Township"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Barn",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Barn"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9966]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5692],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->22567]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Rood - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 11, 48.1985916}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Rood is a unit of area.", "synonyms" -> {}, "title" -> 
    "Rood", "type" -> "Symbol", "uri" -> "Units/ref/Rood"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1524, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2147, 63, 42, 1, 70, "ObjectName",
 CellID->17468],
Cell[2192, 66, 311, 10, 70, "Usage",
 CellID->5590]
}, Open  ]],
Cell[CellGroupData[{
Cell[2540, 81, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3018, 98, 317, 11, 70, "Notes",
 CellID->31987],
Cell[3338, 111, 256, 10, 70, "Notes",
 CellID->16846],
Cell[3597, 123, 498, 19, 70, "Notes",
 CellID->6878]
}, Closed]],
Cell[CellGroupData[{
Cell[4132, 147, 310, 9, 70, "SeeAlsoSection",
 CellID->8583],
Cell[4445, 158, 1193, 44, 70, "SeeAlso",
 CellID->9966]
}, Open  ]],
Cell[CellGroupData[{
Cell[5675, 207, 313, 9, 70, "TutorialsSection",
 CellID->5692],
Cell[5991, 218, 135, 3, 70, "Tutorials",
 CellID->22567]
}, Open  ]],
Cell[6141, 224, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

