(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8289,        294]
NotebookOptionsPosition[      6528,        236]
NotebookOutlinePosition[      7478,        263]
CellTagsIndexPosition[      7435,        260]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ElectronVolt" :> 
          Documentation`HelpLookup["paclet:Units/ref/ElectronVolt"], 
          "Calorie" :> Documentation`HelpLookup["paclet:Units/ref/Calorie"], 
          "BritishThermalUnit" :> 
          Documentation`HelpLookup["paclet:Units/ref/BritishThermalUnit"], 
          "BTU" :> Documentation`HelpLookup["paclet:Units/ref/BTU"], "Therm" :> 
          Documentation`HelpLookup["paclet:Units/ref/Therm"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ElectronVolt\"\>", 
       2->"\<\"Calorie\"\>", 3->"\<\"BritishThermalUnit\"\>", 
       4->"\<\"BTU\"\>", 5->"\<\"Therm\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Rydberg", "ObjectName",
 CellID->16376],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Rydberg"], "InlineFormula"],
     " \[LineSeparator]is a unit of energy."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23711]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Rydberg"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"2.1799", "\[Times]", 
   SuperscriptBox["10", 
    RowBox[{"-", "18"}]], " ", 
   ButtonBox["Joule",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Joule"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->21942],

Cell[TextData[{
 Cell[BoxData["Rydberg"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"2.1799", "\[Times]", 
   SuperscriptBox["10", 
    RowBox[{"-", "11"}]], " ", 
   ButtonBox["Erg",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Erg"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->24314],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Rydberg"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Rydberg"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->128],

Cell[TextData[{
 Cell[BoxData["Rydberg"], "InlineFormula"],
 " is typically abbreviated as Ry."
}], "Notes",
 CellID->378570212]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31032],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ElectronVolt",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/ElectronVolt"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Calorie",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Calorie"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BritishThermalUnit",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/BritishThermalUnit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BTU",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/BTU"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Therm",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Therm"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2100]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21289],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->10223]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Rydberg - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 12, 1.0739212}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Rydberg is a unit of energy.", "synonyms" -> {}, "title" -> 
    "Rydberg", "type" -> "Symbol", "uri" -> "Units/ref/Rydberg"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1583, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2206, 64, 45, 1, 70, "ObjectName",
 CellID->16376],
Cell[2254, 67, 317, 10, 70, "Usage",
 CellID->23711]
}, Open  ]],
Cell[CellGroupData[{
Cell[2608, 82, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3086, 99, 355, 12, 70, "Notes",
 CellID->21942],
Cell[3444, 113, 340, 12, 70, "Notes",
 CellID->24314],
Cell[3787, 127, 503, 19, 70, "Notes",
 CellID->128],
Cell[4293, 148, 128, 4, 70, "Notes",
 CellID->378570212]
}, Closed]],
Cell[CellGroupData[{
Cell[4458, 157, 311, 9, 70, "SeeAlsoSection",
 CellID->31032],
Cell[4772, 168, 1225, 44, 70, "SeeAlso",
 CellID->2100]
}, Open  ]],
Cell[CellGroupData[{
Cell[6034, 217, 314, 9, 70, "TutorialsSection",
 CellID->21289],
Cell[6351, 228, 135, 3, 70, "Tutorials",
 CellID->10223]
}, Open  ]],
Cell[6501, 234, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

