(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8918,        306]
NotebookOptionsPosition[      7164,        249]
NotebookOutlinePosition[      8163,        277]
CellTagsIndexPosition[      8120,        274]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NetHundredweight" :> 
          Documentation`HelpLookup["paclet:Units/ref/NetHundredweight"], 
          "Cental" :> Documentation`HelpLookup["paclet:Units/ref/Cental"], 
          "AvoirdupoisPound" :> 
          Documentation`HelpLookup["paclet:Units/ref/AvoirdupoisPound"], 
          "Ton" :> Documentation`HelpLookup["paclet:Units/ref/Ton"], 
          "ShortTon" :> Documentation`HelpLookup["paclet:Units/ref/ShortTon"],
           "GrossHundredweight" :> 
          Documentation`HelpLookup["paclet:Units/ref/GrossHundredweight"], 
          "Hundredweight" :> 
          Documentation`HelpLookup["paclet:Units/ref/Hundredweight"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"NetHundredweight\"\>", 
       2->"\<\"Cental\"\>", 3->"\<\"AvoirdupoisPound\"\>", 4->"\<\"Ton\"\>", 
       5->"\<\"ShortTon\"\>", 6->"\<\"GrossHundredweight\"\>", 
       7->"\<\"Hundredweight\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ShortHundredweight", "ObjectName",
 CellID->21056],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["ShortHundredweight"], "InlineFormula"],
     " \[LineSeparator]is a unit of weight."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29410]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["ShortHundredweight"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"45.3592", " ", 
   ButtonBox["Kilogram",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Kilogram"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->10395],

Cell[TextData[{
 Cell[BoxData["ShortHundredweight"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"100", " ", 
   ButtonBox["Pound",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Pound"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->11841],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "ShortHundredweight"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "ShortHundredweight"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->8141]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26040],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NetHundredweight",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/NetHundredweight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cental",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Cental"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AvoirdupoisPound",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/AvoirdupoisPound"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ton",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Ton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShortTon",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/ShortTon"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GrossHundredweight",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/GrossHundredweight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hundredweight",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Hundredweight"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20877]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7905],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->21740]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ShortHundredweight - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 12, 1.9645690}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "ShortHundredweight is a unit of weight.", "synonyms" -> {}, 
    "title" -> "ShortHundredweight", "type" -> "Symbol", "uri" -> 
    "Units/ref/ShortHundredweight"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1877, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2500, 69, 56, 1, 70, "ObjectName",
 CellID->21056],
Cell[2559, 72, 328, 10, 70, "Usage",
 CellID->29410]
}, Open  ]],
Cell[CellGroupData[{
Cell[2924, 87, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3402, 104, 309, 10, 70, "Notes",
 CellID->10395],
Cell[3714, 116, 274, 10, 70, "Notes",
 CellID->11841],
Cell[3991, 128, 526, 19, 70, "Notes",
 CellID->8141]
}, Closed]],
Cell[CellGroupData[{
Cell[4554, 152, 311, 9, 70, "SeeAlsoSection",
 CellID->26040],
Cell[4868, 163, 1766, 62, 70, "SeeAlso",
 CellID->20877]
}, Open  ]],
Cell[CellGroupData[{
Cell[6671, 230, 313, 9, 70, "TutorialsSection",
 CellID->7905],
Cell[6987, 241, 135, 3, 70, "Tutorials",
 CellID->21740]
}, Open  ]],
Cell[7137, 247, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

