(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6468,        234]
NotebookOptionsPosition[      4734,        177]
NotebookOutlinePosition[      5712,        205]
CellTagsIndexPosition[      5669,        202]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Abfarad" :> 
          Documentation`HelpLookup["paclet:Units/ref/Abfarad"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Abfarad\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Statfarad", "ObjectName",
 CellID->24002],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Statfarad"], "InlineFormula"],
     " \[LineSeparator]is a unit of electric capacitance."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17058]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Statfarad"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"1.11265", "\[Times]", 
   SuperscriptBox["10", 
    RowBox[{"-", "12"}]], " ", 
   ButtonBox["Farad",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Farad"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->14651],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Statfarad"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Statfarad"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->14519],

Cell[TextData[{
 Cell[BoxData["Statfarad"], "InlineFormula"],
 " is typically abbreviated as statF."
}], "Notes",
 CellID->264719504]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17740],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Abfarad",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Abfarad"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->22940]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22426],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->3418]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Statfarad - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 12, 11.0898026}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Statfarad is a unit of electric capacitance.", 
    "synonyms" -> {}, "title" -> "Statfarad", "type" -> "Symbol", "uri" -> 
    "Units/ref/Statfarad"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1126, 30, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1749, 57, 47, 1, 70, "ObjectName",
 CellID->24002],
Cell[1799, 60, 333, 10, 70, "Usage",
 CellID->17058]
}, Open  ]],
Cell[CellGroupData[{
Cell[2169, 75, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2647, 92, 358, 12, 70, "Notes",
 CellID->14651],
Cell[3008, 106, 509, 19, 70, "Notes",
 CellID->14519],
Cell[3520, 127, 133, 4, 70, "Notes",
 CellID->264719504]
}, Closed]],
Cell[CellGroupData[{
Cell[3690, 136, 311, 9, 70, "SeeAlsoSection",
 CellID->17740],
Cell[4004, 147, 200, 6, 70, "SeeAlso",
 CellID->22940]
}, Open  ]],
Cell[CellGroupData[{
Cell[4241, 158, 314, 9, 70, "TutorialsSection",
 CellID->22426],
Cell[4558, 169, 134, 3, 70, "Tutorials",
 CellID->3418]
}, Open  ]],
Cell[4707, 175, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

