(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6626,        243]
NotebookOptionsPosition[      4934,        187]
NotebookOutlinePosition[      5877,        214]
CellTagsIndexPosition[      5834,        211]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Liter" :> Documentation`HelpLookup["paclet:Units/ref/Liter"], 
          "Cord" :> Documentation`HelpLookup["paclet:Units/ref/Cord"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Liter\"\>", 
       2->"\<\"Cord\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Stere", "ObjectName",
 CellID->2891],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Stere"], "InlineFormula"],
     " \[LineSeparator]is a unit of volume."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4222]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Stere"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  SuperscriptBox[
   ButtonBox["Meter",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Meter"], "3"]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->22659],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Stere"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Stere"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->7045],

Cell[TextData[{
 Cell[BoxData["Stere"], "InlineFormula"],
 " is typically abbreviated as st."
}], "Notes",
 CellID->23422]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9474],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Liter",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Liter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cord",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Cord"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13982]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12810],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->5808]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Stere - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 12, 18.5899946}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Stere is a unit of volume.", "synonyms" -> {}, "title" -> 
    "Stere", "type" -> "Symbol", "uri" -> "Units/ref/Stere"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1209, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1832, 58, 42, 1, 70, "ObjectName",
 CellID->2891],
Cell[1877, 61, 314, 10, 70, "Usage",
 CellID->4222]
}, Open  ]],
Cell[CellGroupData[{
Cell[2228, 76, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2706, 93, 271, 10, 70, "Notes",
 CellID->22659],
Cell[2980, 105, 500, 19, 70, "Notes",
 CellID->7045],
Cell[3483, 126, 122, 4, 70, "Notes",
 CellID->23422]
}, Closed]],
Cell[CellGroupData[{
Cell[3642, 135, 310, 9, 70, "SeeAlsoSection",
 CellID->9474],
Cell[3955, 146, 449, 17, 70, "SeeAlso",
 CellID->13982]
}, Open  ]],
Cell[CellGroupData[{
Cell[4441, 168, 314, 9, 70, "TutorialsSection",
 CellID->12810],
Cell[4758, 179, 134, 3, 70, "Tutorials",
 CellID->5808]
}, Open  ]],
Cell[4907, 185, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

