(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6853,        249]
NotebookOptionsPosition[      5120,        192]
NotebookOutlinePosition[      6099,        220]
CellTagsIndexPosition[      6056,        217]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Poise" :> Documentation`HelpLookup["paclet:Units/ref/Poise"], 
          "CGS" :> Documentation`HelpLookup["paclet:Units/ref/CGS"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Poise\"\>", 
       2->"\<\"CGS\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Stokes", "ObjectName",
 CellID->18692],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Stokes"], "InlineFormula"],
     " \[LineSeparator]is the derived CGS unit of kinematic viscosity."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8234]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Stokes"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"0.0001", " ", 
   RowBox[{
    SuperscriptBox[
     ButtonBox["Meter",
      BaseStyle->"Link",
      ButtonData->"paclet:Units/ref/Meter"], "2"], "/", 
    ButtonBox["Second",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Second"]}]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->21370],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Stokes"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Stokes"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->7985],

Cell[TextData[{
 Cell[BoxData["Stokes"], "InlineFormula"],
 " is typically abbreviated as S or St."
}], "Notes",
 CellID->6985]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24919],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Poise",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Poise"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CGS",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/CGS"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->207997394]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6330],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->23789]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Stokes - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 12, 18.9181280}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Stokes is the derived CGS unit of kinematic viscosity.", 
    "synonyms" -> {}, "title" -> "Stokes", "type" -> "Symbol", "uri" -> 
    "Units/ref/Stokes"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1205, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1828, 58, 44, 1, 70, "ObjectName",
 CellID->18692],
Cell[1875, 61, 342, 10, 70, "Usage",
 CellID->8234]
}, Open  ]],
Cell[CellGroupData[{
Cell[2254, 76, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2732, 93, 421, 15, 70, "Notes",
 CellID->21370],
Cell[3156, 110, 502, 19, 70, "Notes",
 CellID->7985],
Cell[3661, 131, 127, 4, 70, "Notes",
 CellID->6985]
}, Closed]],
Cell[CellGroupData[{
Cell[3825, 140, 311, 9, 70, "SeeAlsoSection",
 CellID->24919],
Cell[4139, 151, 451, 17, 70, "SeeAlso",
 CellID->207997394]
}, Open  ]],
Cell[CellGroupData[{
Cell[4627, 173, 313, 9, 70, "TutorialsSection",
 CellID->6330],
Cell[4943, 184, 135, 3, 70, "Tutorials",
 CellID->23789]
}, Open  ]],
Cell[5093, 190, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

