(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7928,        281]
NotebookOptionsPosition[      6197,        224]
NotebookOutlinePosition[      7173,        252]
CellTagsIndexPosition[      7130,        249]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Gauss" :> Documentation`HelpLookup["paclet:Units/ref/Gauss"], 
          "BohrMagneton" :> 
          Documentation`HelpLookup["paclet:Units/ref/BohrMagneton"], 
          "NuclearMagneton" :> 
          Documentation`HelpLookup["paclet:Units/ref/NuclearMagneton"], 
          "Ampere" :> Documentation`HelpLookup["paclet:Units/ref/Ampere"], 
          "Amp" :> Documentation`HelpLookup["paclet:Units/ref/Amp"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Gauss\"\>", 
       2->"\<\"BohrMagneton\"\>", 3->"\<\"NuclearMagneton\"\>", 
       4->"\<\"Ampere\"\>", 5->"\<\"Amp\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Tesla", "ObjectName",
 CellID->2987],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Tesla"], "InlineFormula"],
     " \[LineSeparator]is the derived SI unit of magnetic flux density."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5546]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Tesla"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Weber",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Weber"], "/", 
   SuperscriptBox[
    ButtonBox["Meter",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Meter"], "2"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->2074],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Tesla"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Tesla"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->16911],

Cell[TextData[{
 Cell[BoxData["Tesla"], "InlineFormula"],
 " is typically abbreviated as T."
}], "Notes",
 CellID->22898]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17314],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gauss",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Gauss"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BohrMagneton",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/BohrMagneton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NuclearMagneton",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/NuclearMagneton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ampere",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Ampere"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Amp",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Amp"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->791613027]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7589],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->20937]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Tesla - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 12, 26.7777042}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Tesla is the derived SI unit of magnetic flux density.", 
    "synonyms" -> {}, "title" -> "Tesla", "type" -> "Symbol", "uri" -> 
    "Units/ref/Tesla"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1571, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2194, 64, 42, 1, 70, "ObjectName",
 CellID->2987],
Cell[2239, 67, 342, 10, 70, "Usage",
 CellID->5546]
}, Open  ]],
Cell[CellGroupData[{
Cell[2618, 82, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3096, 99, 370, 14, 70, "Notes",
 CellID->2074],
Cell[3469, 115, 501, 19, 70, "Notes",
 CellID->16911],
Cell[3973, 136, 121, 4, 70, "Notes",
 CellID->22898]
}, Closed]],
Cell[CellGroupData[{
Cell[4131, 145, 311, 9, 70, "SeeAlsoSection",
 CellID->17314],
Cell[4445, 156, 1222, 44, 70, "SeeAlso",
 CellID->791613027]
}, Open  ]],
Cell[CellGroupData[{
Cell[5704, 205, 313, 9, 70, "TutorialsSection",
 CellID->7589],
Cell[6020, 216, 135, 3, 70, "Tutorials",
 CellID->20937]
}, Open  ]],
Cell[6170, 222, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

