(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8329,        298]
NotebookOptionsPosition[      6583,        240]
NotebookOutlinePosition[      7524,        267]
CellTagsIndexPosition[      7481,        264]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Ton" :> Documentation`HelpLookup["paclet:Units/ref/Ton"], 
          "ShortTon" :> Documentation`HelpLookup["paclet:Units/ref/ShortTon"],
           "Gram" :> Documentation`HelpLookup["paclet:Units/ref/Gram"], 
          "LongTon" :> Documentation`HelpLookup["paclet:Units/ref/LongTon"], 
          "Pound" :> Documentation`HelpLookup["paclet:Units/ref/Pound"], 
          "Quintal" :> 
          Documentation`HelpLookup["paclet:Units/ref/Quintal"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Ton\"\>", 2->"\<\"ShortTon\"\>", 
       3->"\<\"Gram\"\>", 4->"\<\"LongTon\"\>", 5->"\<\"Pound\"\>", 
       6->"\<\"Quintal\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Tonne", "ObjectName",
 CellID->4331],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Tonne"], "InlineFormula"],
     " \[LineSeparator]is a unit of mass."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3461]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Tonne"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"1000", " ", 
   ButtonBox["Kilogram",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Kilogram"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->28484],

Cell[TextData[{
 Cell[BoxData["Tonne"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  ButtonBox["MetricTon",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/MetricTon"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->32127],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Tonne"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Tonne"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->18193],

Cell[TextData[{
 Cell[BoxData["Tonne"], "InlineFormula"],
 " is typically abbreviated as t."
}], "Notes",
 CellID->16866]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26009],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ton",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Ton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShortTon",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/ShortTon"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gram",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Gram"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LongTon",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/LongTon"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pound",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Pound"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Quintal",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Quintal"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8415]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6693],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->19403]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Tonne - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 12, 27.5277234}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Tonne is a unit of mass.", "synonyms" -> {}, "title" -> 
    "Tonne", "type" -> "Symbol", "uri" -> "Units/ref/Tonne"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1618, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2241, 64, 42, 1, 70, "ObjectName",
 CellID->4331],
Cell[2286, 67, 312, 10, 70, "Usage",
 CellID->3461]
}, Open  ]],
Cell[CellGroupData[{
Cell[2635, 82, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3113, 99, 279, 10, 70, "Notes",
 CellID->28484],
Cell[3395, 111, 241, 9, 70, "Notes",
 CellID->32127],
Cell[3639, 122, 501, 19, 70, "Notes",
 CellID->18193],
Cell[4143, 143, 121, 4, 70, "Notes",
 CellID->16866]
}, Closed]],
Cell[CellGroupData[{
Cell[4301, 152, 311, 9, 70, "SeeAlsoSection",
 CellID->26009],
Cell[4615, 163, 1438, 53, 70, "SeeAlso",
 CellID->8415]
}, Open  ]],
Cell[CellGroupData[{
Cell[6090, 221, 313, 9, 70, "TutorialsSection",
 CellID->6693],
Cell[6406, 232, 135, 3, 70, "Tutorials",
 CellID->19403]
}, Open  ]],
Cell[6556, 238, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

