(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7904,        282]
NotebookOptionsPosition[      6198,        226]
NotebookOutlinePosition[      7151,        253]
CellTagsIndexPosition[      7108,        250]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Acre" :> Documentation`HelpLookup["paclet:Units/ref/Acre"], 
          "Hectare" :> Documentation`HelpLookup["paclet:Units/ref/Hectare"], 
          "Are" :> Documentation`HelpLookup["paclet:Units/ref/Are"], "Rood" :> 
          Documentation`HelpLookup["paclet:Units/ref/Rood"], "Barn" :> 
          Documentation`HelpLookup["paclet:Units/ref/Barn"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Acre\"\>", 2->"\<\"Hectare\"\>", 
       3->"\<\"Are\"\>", 4->"\<\"Rood\"\>", 
       5->"\<\"Barn\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Township", "ObjectName",
 CellID->6492],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Township"], "InlineFormula"],
     " \[LineSeparator]is a unit of area."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6866]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Township"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"9.32396", "\[Times]", 
   SuperscriptBox["10", "7"], " ", 
   SuperscriptBox[
    ButtonBox["Meter",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Meter"], "2"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->6654],

Cell[TextData[{
 Cell[BoxData["Township"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"36", " ", 
   ButtonBox["Section",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Section"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->31615],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Township"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Township"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->15584]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32313],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Acre",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Acre"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hectare",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Hectare"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Are",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Are"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rood",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Rood"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Barn",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Barn"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14978]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32322],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->17407]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Township - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 12, 31.2153178}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Township is a unit of area.", "synonyms" -> {}, "title" -> 
    "Township", "type" -> "Symbol", "uri" -> "Units/ref/Township"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1492, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2115, 62, 45, 1, 70, "ObjectName",
 CellID->6492],
Cell[2163, 65, 315, 10, 70, "Usage",
 CellID->6866]
}, Open  ]],
Cell[CellGroupData[{
Cell[2515, 80, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2993, 97, 363, 12, 70, "Notes",
 CellID->6654],
Cell[3359, 111, 267, 10, 70, "Notes",
 CellID->31615],
Cell[3629, 123, 507, 19, 70, "Notes",
 CellID->15584]
}, Closed]],
Cell[CellGroupData[{
Cell[4173, 147, 311, 9, 70, "SeeAlsoSection",
 CellID->32313],
Cell[4487, 158, 1180, 44, 70, "SeeAlso",
 CellID->14978]
}, Open  ]],
Cell[CellGroupData[{
Cell[5704, 207, 314, 9, 70, "TutorialsSection",
 CellID->32322],
Cell[6021, 218, 135, 3, 70, "Tutorials",
 CellID->17407]
}, Open  ]],
Cell[6171, 224, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

