(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7866,        277]
NotebookOptionsPosition[      6183,        221]
NotebookOutlinePosition[      7168,        250]
CellTagsIndexPosition[      7125,        247]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Amp" :> Documentation`HelpLookup["paclet:Units/ref/Amp"], 
          "Abvolt" :> Documentation`HelpLookup["paclet:Units/ref/Abvolt"], 
          "Statvolt" :> Documentation`HelpLookup["paclet:Units/ref/Statvolt"],
           "Farad" :> Documentation`HelpLookup["paclet:Units/ref/Farad"], 
          "Henry" :> Documentation`HelpLookup["paclet:Units/ref/Henry"], 
          "Siemens" :> 
          Documentation`HelpLookup["paclet:Units/ref/Siemens"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Amp\"\>", 2->"\<\"Abvolt\"\>", 
       3->"\<\"Statvolt\"\>", 4->"\<\"Farad\"\>", 5->"\<\"Henry\"\>", 
       6->"\<\"Siemens\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Volt", "ObjectName",
 CellID->31635],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Volt"], "InlineFormula"],
     " \[LineSeparator]is the derived SI unit of electric potential \
difference."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12483]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Volt"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Watt",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Watt"], "/", 
   ButtonBox["Ampere",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Ampere"]}]], "InlineFormula"],
 ", and to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Joule",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Joule"], "/", 
   ButtonBox["Coulomb",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Coulomb"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->7917],

Cell[TextData[{
 Cell[BoxData["Volt"], "InlineFormula"],
 " is typically abbreviated as V."
}], "Notes",
 CellID->8944]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21559],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Amp",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Amp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Abvolt",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Abvolt"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Statvolt",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Statvolt"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Farad",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Farad"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Henry",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Henry"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Siemens",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Siemens"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->32621]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1108],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->19732]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Volt - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 12, 35.4185504}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> 
    "Volt is the derived SI unit of electric potential difference.", 
    "synonyms" -> {}, "title" -> "Volt", "type" -> "Symbol", "uri" -> 
    "Units/ref/Volt"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1618, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2241, 64, 42, 1, 70, "ObjectName",
 CellID->31635],
Cell[2286, 67, 352, 11, 70, "Usage",
 CellID->12483]
}, Open  ]],
Cell[CellGroupData[{
Cell[2675, 83, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3153, 100, 588, 22, 70, "Notes",
 CellID->7917],
Cell[3744, 124, 119, 4, 70, "Notes",
 CellID->8944]
}, Closed]],
Cell[CellGroupData[{
Cell[3900, 133, 311, 9, 70, "SeeAlsoSection",
 CellID->21559],
Cell[4214, 144, 1439, 53, 70, "SeeAlso",
 CellID->32621]
}, Open  ]],
Cell[CellGroupData[{
Cell[5690, 202, 313, 9, 70, "TutorialsSection",
 CellID->1108],
Cell[6006, 213, 135, 3, 70, "Tutorials",
 CellID->19732]
}, Open  ]],
Cell[6156, 219, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

