(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7596,        266]
NotebookOptionsPosition[      5947,        212]
NotebookOutlinePosition[      6898,        239]
CellTagsIndexPosition[      6855,        236]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Horsepower" :> 
          Documentation`HelpLookup["paclet:Units/ref/Horsepower"], 
          "ChevalVapeur" :> 
          Documentation`HelpLookup["paclet:Units/ref/ChevalVapeur"], "Amp" :> 
          Documentation`HelpLookup["paclet:Units/ref/Amp"], "Ampere" :> 
          Documentation`HelpLookup["paclet:Units/ref/Ampere"], "Ohm" :> 
          Documentation`HelpLookup["paclet:Units/ref/Ohm"], "Volt" :> 
          Documentation`HelpLookup["paclet:Units/ref/Volt"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Horsepower\"\>", 
       2->"\<\"ChevalVapeur\"\>", 3->"\<\"Amp\"\>", 4->"\<\"Ampere\"\>", 
       5->"\<\"Ohm\"\>", 6->"\<\"Volt\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Watt", "ObjectName",
 CellID->10770],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Watt"], "InlineFormula"],
     " \[LineSeparator]is the derived SI unit of power."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28393]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Watt"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Joule",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Joule"], "/", 
   ButtonBox["Second",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Second"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->11363],

Cell[TextData[{
 Cell[BoxData["Watt"], "InlineFormula"],
 " is written in the literature as W."
}], "Notes",
 CellID->29802]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6509],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Horsepower",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Horsepower"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ChevalVapeur",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/ChevalVapeur"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Amp",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Amp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ampere",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Ampere"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ohm",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Ohm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Volt",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Volt"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->410]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28069],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->21999]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Watt - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 12, 35.5904298}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Watt is the derived SI unit of power.", "synonyms" -> {}, 
    "title" -> "Watt", "type" -> "Symbol", "uri" -> "Units/ref/Watt"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1641, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2264, 65, 42, 1, 70, "ObjectName",
 CellID->10770],
Cell[2309, 68, 326, 10, 70, "Usage",
 CellID->28393]
}, Open  ]],
Cell[CellGroupData[{
Cell[2672, 83, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3150, 100, 344, 13, 70, "Notes",
 CellID->11363],
Cell[3497, 115, 124, 4, 70, "Notes",
 CellID->29802]
}, Closed]],
Cell[CellGroupData[{
Cell[3658, 124, 310, 9, 70, "SeeAlsoSection",
 CellID->6509],
Cell[3971, 135, 1445, 53, 70, "SeeAlso",
 CellID->410]
}, Open  ]],
Cell[CellGroupData[{
Cell[5453, 193, 314, 9, 70, "TutorialsSection",
 CellID->28069],
Cell[5770, 204, 135, 3, 70, "Tutorials",
 CellID->21999]
}, Open  ]],
Cell[5920, 210, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

