(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9120,        321]
NotebookOptionsPosition[      7373,        263]
NotebookOutlinePosition[      8310,        290]
CellTagsIndexPosition[      8267,        287]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Month" :> Documentation`HelpLookup["paclet:Units/ref/Month"], 
          "Week" :> Documentation`HelpLookup["paclet:Units/ref/Week"], 
          "TropicalYear" :> 
          Documentation`HelpLookup["paclet:Units/ref/TropicalYear"], 
          "SiderealYear" :> 
          Documentation`HelpLookup["paclet:Units/ref/SiderealYear"], "Decade" :> 
          Documentation`HelpLookup["paclet:Units/ref/Decade"], "Century" :> 
          Documentation`HelpLookup["paclet:Units/ref/Century"], "Millennium" :> 
          Documentation`HelpLookup["paclet:Units/ref/Millennium"], "Hour" :> 
          Documentation`HelpLookup["paclet:Units/ref/Hour"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Month\"\>", 2->"\<\"Week\"\>", 
       3->"\<\"TropicalYear\"\>", 4->"\<\"SiderealYear\"\>", 
       5->"\<\"Decade\"\>", 6->"\<\"Century\"\>", 7->"\<\"Millennium\"\>", 
       8->"\<\"Hour\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Year", "ObjectName",
 CellID->24361],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Year"], "InlineFormula"],
     " \[LineSeparator]is a unit of time."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->25245]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Year"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"31536000", " ", 
   ButtonBox["Second",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Second"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->13489],

Cell[TextData[{
 Cell[BoxData["Year"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"365", " ", 
   ButtonBox["Day",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Day"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->23574],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Year"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Year"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->13369],

Cell[TextData[{
 Cell[BoxData["Year"], "InlineFormula"],
 " is typically abbreviated as yr."
}], "Notes",
 CellID->2896]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20527],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Month",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Month"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Week",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Week"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TropicalYear",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/TropicalYear"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SiderealYear",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/SiderealYear"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Decade",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Decade"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Century",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Century"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Millennium",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Millennium"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hour",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Hour"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30789]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18490],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->26847]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Year - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 12, 43.2156250}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Year is a unit of time.", "synonyms" -> {}, "title" -> 
    "Year", "type" -> "Symbol", "uri" -> "Units/ref/Year"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1873, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2496, 68, 42, 1, 70, "ObjectName",
 CellID->24361],
Cell[2541, 71, 312, 10, 70, "Usage",
 CellID->25245]
}, Open  ]],
Cell[CellGroupData[{
Cell[2890, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3368, 103, 278, 10, 70, "Notes",
 CellID->13489],
Cell[3649, 115, 256, 10, 70, "Notes",
 CellID->23574],
Cell[3908, 127, 499, 19, 70, "Notes",
 CellID->13369],
Cell[4410, 148, 120, 4, 70, "Notes",
 CellID->2896]
}, Closed]],
Cell[CellGroupData[{
Cell[4567, 157, 311, 9, 70, "SeeAlsoSection",
 CellID->20527],
Cell[4881, 168, 1961, 71, 70, "SeeAlso",
 CellID->30789]
}, Open  ]],
Cell[CellGroupData[{
Cell[6879, 244, 314, 9, 70, "TutorialsSection",
 CellID->18490],
Cell[7196, 255, 135, 3, 70, "Tutorials",
 CellID->26847]
}, Open  ]],
Cell[7346, 261, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

