(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     73776,       2103]
NotebookOptionsPosition[     67140,       1886]
NotebookOutlinePosition[     68814,       1932]
CellTagsIndexPosition[     68728,       1927]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Abampere" :> 
         Documentation`HelpLookup["paclet:Units/ref/Abampere"], "Abcoulomb" :> 
         Documentation`HelpLookup["paclet:Units/ref/Abcoulomb"], "Abfarad" :> 
         Documentation`HelpLookup["paclet:Units/ref/Abfarad"], "Abhenry" :> 
         Documentation`HelpLookup["paclet:Units/ref/Abhenry"], "Abmho" :> 
         Documentation`HelpLookup["paclet:Units/ref/Abmho"], "Abohm" :> 
         Documentation`HelpLookup["paclet:Units/ref/Abohm"], "Abvolt" :> 
         Documentation`HelpLookup["paclet:Units/ref/Abvolt"], "Acre" :> 
         Documentation`HelpLookup["paclet:Units/ref/Acre"], "Amp" :> 
         Documentation`HelpLookup["paclet:Units/ref/Amp"], "AMU" :> 
         Documentation`HelpLookup["paclet:Units/ref/AMU"], "Apostilb" :> 
         Documentation`HelpLookup["paclet:Units/ref/Apostilb"], "ArcMinute" :> 
         Documentation`HelpLookup["paclet:Units/ref/ArcMinute"], "ArcSecond" :> 
         Documentation`HelpLookup["paclet:Units/ref/ArcSecond"], "Are" :> 
         Documentation`HelpLookup["paclet:Units/ref/Are"], "AssayTon" :> 
         Documentation`HelpLookup["paclet:Units/ref/AssayTon"], "Atmosphere" :> 
         Documentation`HelpLookup["paclet:Units/ref/Atmosphere"], 
         "AtomicMassUnit" :> 
         Documentation`HelpLookup["paclet:Units/ref/AtomicMassUnit"], "AU" :> 
         Documentation`HelpLookup["paclet:Units/ref/AU"], "AvoirdupoisOunce" :> 
         Documentation`HelpLookup["paclet:Units/ref/AvoirdupoisOunce"], 
         "AvoirdupoisPound" :> 
         Documentation`HelpLookup["paclet:Units/ref/AvoirdupoisPound"], "Bag" :> 
         Documentation`HelpLookup["paclet:Units/ref/Bag"], "BakersDozen" :> 
         Documentation`HelpLookup["paclet:Units/ref/BakersDozen"], "Bale" :> 
         Documentation`HelpLookup["paclet:Units/ref/Bale"], "Bar" :> 
         Documentation`HelpLookup["paclet:Units/ref/Bar"], "Barn" :> 
         Documentation`HelpLookup["paclet:Units/ref/Barn"], "Barrel" :> 
         Documentation`HelpLookup["paclet:Units/ref/Barrel"], "Barye" :> 
         Documentation`HelpLookup["paclet:Units/ref/Barye"], "Baud" :> 
         Documentation`HelpLookup["paclet:Units/ref/Baud"], "Becquerel" :> 
         Documentation`HelpLookup["paclet:Units/ref/Becquerel"], "Biot" :> 
         Documentation`HelpLookup["paclet:Units/ref/Biot"], "Bit" :> 
         Documentation`HelpLookup["paclet:Units/ref/Bit"], "BoardFoot" :> 
         Documentation`HelpLookup["paclet:Units/ref/BoardFoot"], 
         "BohrMagneton" :> 
         Documentation`HelpLookup["paclet:Units/ref/BohrMagneton"], "Bolt" :> 
         Documentation`HelpLookup["paclet:Units/ref/Bolt"], 
         "BritishThermalUnit" :> 
         Documentation`HelpLookup["paclet:Units/ref/BritishThermalUnit"], 
         "BTU" :> Documentation`HelpLookup["paclet:Units/ref/BTU"], "Bucket" :> 
         Documentation`HelpLookup["paclet:Units/ref/Bucket"], "Bushel" :> 
         Documentation`HelpLookup["paclet:Units/ref/Bushel"], "Butt" :> 
         Documentation`HelpLookup["paclet:Units/ref/Butt"], "Byte" :> 
         Documentation`HelpLookup["paclet:ref/Byte"], "Cable" :> 
         Documentation`HelpLookup["paclet:Units/ref/Cable"], "Caliber" :> 
         Documentation`HelpLookup["paclet:Units/ref/Caliber"], "Calorie" :> 
         Documentation`HelpLookup["paclet:Units/ref/Calorie"], "Candela" :> 
         Documentation`HelpLookup["paclet:Units/ref/Candela"], "Candle" :> 
         Documentation`HelpLookup["paclet:Units/ref/Candle"], "Carat" :> 
         Documentation`HelpLookup["paclet:Units/ref/Carat"], "Celsius" :> 
         Documentation`HelpLookup["paclet:Units/ref/Celsius"], "Cental" :> 
         Documentation`HelpLookup["paclet:Units/ref/Cental"], "Centigrade" :> 
         Documentation`HelpLookup["paclet:Units/ref/Centigrade"], 
         "Centimeter" :> 
         Documentation`HelpLookup["paclet:Units/ref/Centimeter"], "Century" :> 
         Documentation`HelpLookup["paclet:Units/ref/Century"], "CGS" :> 
         Documentation`HelpLookup["paclet:Units/ref/CGS"], "Chain" :> 
         Documentation`HelpLookup["paclet:Units/ref/Chain"], "ChevalVapeur" :> 
         Documentation`HelpLookup["paclet:Units/ref/ChevalVapeur"], "Cicero" :> 
         Documentation`HelpLookup["paclet:Units/ref/Cicero"], "Circle" :> 
         Documentation`HelpLookup["paclet:ref/Circle"], "Convert" :> 
         Documentation`HelpLookup["paclet:Units/ref/Convert"], 
         "ConvertTemperature" :> 
         Documentation`HelpLookup["paclet:Units/ref/ConvertTemperature"], 
         "Cord" :> Documentation`HelpLookup["paclet:Units/ref/Cord"], 
         "Coulomb" :> Documentation`HelpLookup["paclet:Units/ref/Coulomb"], 
         "Cubit" :> Documentation`HelpLookup["paclet:Units/ref/Cubit"], "Cup" :> 
         Documentation`HelpLookup["paclet:ref/Cup"], "Curie" :> 
         Documentation`HelpLookup["paclet:Units/ref/Curie"], "Dalton" :> 
         Documentation`HelpLookup["paclet:Units/ref/Dalton"], "Day" :> 
         Documentation`HelpLookup["paclet:Units/ref/Day"], "Decade" :> 
         Documentation`HelpLookup["paclet:Units/ref/Decade"], "Degree" :> 
         Documentation`HelpLookup["paclet:ref/Degree"], "Denier" :> 
         Documentation`HelpLookup["paclet:Units/ref/Denier"], "Didot" :> 
         Documentation`HelpLookup["paclet:Units/ref/Didot"], "DidotPoint" :> 
         Documentation`HelpLookup["paclet:Units/ref/DidotPoint"], "Diopter" :> 
         Documentation`HelpLookup["paclet:Units/ref/Diopter"], "Dozen" :> 
         Documentation`HelpLookup["paclet:Units/ref/Dozen"], "Drachma" :> 
         Documentation`HelpLookup["paclet:Units/ref/Drachma"], "Drop" :> 
         Documentation`HelpLookup["paclet:ref/Drop"], "Dyne" :> 
         Documentation`HelpLookup["paclet:Units/ref/Dyne"], "ElectronVolt" :> 
         Documentation`HelpLookup["paclet:Units/ref/ElectronVolt"], "Ell" :> 
         Documentation`HelpLookup["paclet:Units/ref/Ell"], "Ephah" :> 
         Documentation`HelpLookup["paclet:Units/ref/Ephah"], "Erg" :> 
         Documentation`HelpLookup["paclet:Units/ref/Erg"], "Fahrenheit" :> 
         Documentation`HelpLookup["paclet:Units/ref/Fahrenheit"], "Farad" :> 
         Documentation`HelpLookup["paclet:Units/ref/Farad"], "Fathom" :> 
         Documentation`HelpLookup["paclet:Units/ref/Fathom"], "Feet" :> 
         Documentation`HelpLookup["paclet:Units/ref/Feet"], "Fermi" :> 
         Documentation`HelpLookup["paclet:Units/ref/Fermi"], "Fifth" :> 
         Documentation`HelpLookup["paclet:Units/ref/Fifth"], "Firkin" :> 
         Documentation`HelpLookup["paclet:Units/ref/Firkin"], "FluidDram" :> 
         Documentation`HelpLookup["paclet:Units/ref/FluidDram"], "FluidOunce" :> 
         Documentation`HelpLookup["paclet:Units/ref/FluidOunce"], "Foot" :> 
         Documentation`HelpLookup["paclet:Units/ref/Foot"], "FootCandle" :> 
         Documentation`HelpLookup["paclet:Units/ref/FootCandle"], "Fortnight" :> 
         Documentation`HelpLookup["paclet:Units/ref/Fortnight"], "Furlong" :> 
         Documentation`HelpLookup["paclet:Units/ref/Furlong"], "Gal" :> 
         Documentation`HelpLookup["paclet:Units/ref/Gal"], "Gallon" :> 
         Documentation`HelpLookup["paclet:Units/ref/Gallon"], "Gamma" :> 
         Documentation`HelpLookup["paclet:ref/Gamma"], "Gauss" :> 
         Documentation`HelpLookup["paclet:Units/ref/Gauss"], "Geepound" :> 
         Documentation`HelpLookup["paclet:Units/ref/Geepound"], "Gilbert" :> 
         Documentation`HelpLookup["paclet:Units/ref/Gilbert"], "Gill" :> 
         Documentation`HelpLookup["paclet:Units/ref/Gill"], "Grade" :> 
         Documentation`HelpLookup["paclet:Units/ref/Grade"], "Grain" :> 
         Documentation`HelpLookup["paclet:Units/ref/Grain"], "Gram" :> 
         Documentation`HelpLookup["paclet:Units/ref/Gram"], "GramWeight" :> 
         Documentation`HelpLookup["paclet:Units/ref/GramWeight"], "Gravity" :> 
         Documentation`HelpLookup["paclet:Units/ref/Gravity"], "GrayDose" :> 
         Documentation`HelpLookup["paclet:Units/ref/GrayDose"], "Gross" :> 
         Documentation`HelpLookup["paclet:Units/ref/Gross"], 
         "GrossHundredweight" :> 
         Documentation`HelpLookup["paclet:Units/ref/GrossHundredweight"], 
         "Hand" :> Documentation`HelpLookup["paclet:Units/ref/Hand"], 
         "Hectare" :> Documentation`HelpLookup["paclet:Units/ref/Hectare"], 
         "Hefner" :> Documentation`HelpLookup["paclet:Units/ref/Hefner"], 
         "Henry" :> Documentation`HelpLookup["paclet:Units/ref/Henry"], 
         "Hertz" :> Documentation`HelpLookup["paclet:Units/ref/Hertz"], 
         "Hogshead" :> Documentation`HelpLookup["paclet:Units/ref/Hogshead"], 
         "Horsepower" :> 
         Documentation`HelpLookup["paclet:Units/ref/Horsepower"], "Hour" :> 
         Documentation`HelpLookup["paclet:Units/ref/Hour"], "Hundredweight" :> 
         Documentation`HelpLookup["paclet:Units/ref/Hundredweight"], "Inch" :> 
         Documentation`HelpLookup["paclet:Units/ref/Inch"], "InchMercury" :> 
         Documentation`HelpLookup["paclet:Units/ref/InchMercury"], "Jeroboam" :> 
         Documentation`HelpLookup["paclet:Units/ref/Jeroboam"], "Jigger" :> 
         Documentation`HelpLookup["paclet:Units/ref/Jigger"], "Joule" :> 
         Documentation`HelpLookup["paclet:Units/ref/Joule"], "Kayser" :> 
         Documentation`HelpLookup["paclet:Units/ref/Kayser"], "Kelvin" :> 
         Documentation`HelpLookup["paclet:Units/ref/Kelvin"], "Kilogram" :> 
         Documentation`HelpLookup["paclet:Units/ref/Kilogram"], 
         "KilogramForce" :> 
         Documentation`HelpLookup["paclet:Units/ref/KilogramForce"], 
         "KilogramWeight" :> 
         Documentation`HelpLookup["paclet:Units/ref/KilogramWeight"], "Knot" :> 
         Documentation`HelpLookup["paclet:Units/ref/Knot"], "Lambert" :> 
         Documentation`HelpLookup["paclet:Units/ref/Lambert"], "Last" :> 
         Documentation`HelpLookup["paclet:ref/Last"], "League" :> 
         Documentation`HelpLookup["paclet:Units/ref/League"], "Libra" :> 
         Documentation`HelpLookup["paclet:Units/ref/Libra"], "LightYear" :> 
         Documentation`HelpLookup["paclet:Units/ref/LightYear"], "Link" :> 
         Documentation`HelpLookup["paclet:Units/ref/Link"], "Liter" :> 
         Documentation`HelpLookup["paclet:Units/ref/Liter"], "LongTon" :> 
         Documentation`HelpLookup["paclet:Units/ref/LongTon"], "Lumerg" :> 
         Documentation`HelpLookup["paclet:Units/ref/Lumerg"], "Magnum" :> 
         Documentation`HelpLookup["paclet:Units/ref/Magnum"], "Maxwell" :> 
         Documentation`HelpLookup["paclet:Units/ref/Maxwell"], "Meter" :> 
         Documentation`HelpLookup["paclet:Units/ref/Meter"], "MetricTon" :> 
         Documentation`HelpLookup["paclet:Units/ref/MetricTon"], "Mho" :> 
         Documentation`HelpLookup["paclet:Units/ref/Mho"], "Micron" :> 
         Documentation`HelpLookup["paclet:Units/ref/Micron"], "Mil" :> 
         Documentation`HelpLookup["paclet:Units/ref/Mil"], "Mile" :> 
         Documentation`HelpLookup["paclet:Units/ref/Mile"], "Millennium" :> 
         Documentation`HelpLookup["paclet:Units/ref/Millennium"], 
         "MillimeterMercury" :> 
         Documentation`HelpLookup["paclet:Units/ref/MillimeterMercury"], 
         "Mina" :> Documentation`HelpLookup["paclet:Units/ref/Mina"], "Minim" :> 
         Documentation`HelpLookup["paclet:Units/ref/Minim"], "Minute" :> 
         Documentation`HelpLookup["paclet:Units/ref/Minute"], "MKS" :> 
         Documentation`HelpLookup["paclet:Units/ref/MKS"], "Mole" :> 
         Documentation`HelpLookup["paclet:Units/ref/Mole"], "Month" :> 
         Documentation`HelpLookup["paclet:Units/ref/Month"], "NauticalMile" :> 
         Documentation`HelpLookup["paclet:Units/ref/NauticalMile"], 
         "NetHundredweight" :> 
         Documentation`HelpLookup["paclet:Units/ref/NetHundredweight"], 
         "Newton" :> Documentation`HelpLookup["paclet:Units/ref/Newton"], 
         "Nibble" :> Documentation`HelpLookup["paclet:Units/ref/Nibble"], 
         "Nit" :> Documentation`HelpLookup["paclet:Units/ref/Nit"], "Noggin" :> 
         Documentation`HelpLookup["paclet:Units/ref/Noggin"], 
         "NuclearMagneton" :> 
         Documentation`HelpLookup["paclet:Units/ref/NuclearMagneton"], 
         "Obolos" :> Documentation`HelpLookup["paclet:Units/ref/Obolos"], 
         "Oersted" :> Documentation`HelpLookup["paclet:Units/ref/Oersted"], 
         "Ohm" :> Documentation`HelpLookup["paclet:Units/ref/Ohm"], "Omer" :> 
         Documentation`HelpLookup["paclet:Units/ref/Omer"], "Ounce" :> 
         Documentation`HelpLookup["paclet:Units/ref/Ounce"], "Parsec" :> 
         Documentation`HelpLookup["paclet:Units/ref/Parsec"], "Pascal" :> 
         Documentation`HelpLookup["paclet:Units/ref/Pascal"], "Pennyweight" :> 
         Documentation`HelpLookup["paclet:Units/ref/Pennyweight"], "Percent" :> 
         Documentation`HelpLookup["paclet:Units/ref/Percent"], "Perch" :> 
         Documentation`HelpLookup["paclet:Units/ref/Perch"], "Phot" :> 
         Documentation`HelpLookup["paclet:Units/ref/Phot"], "Pica" :> 
         Documentation`HelpLookup["paclet:Units/ref/Pica"], "Pint" :> 
         Documentation`HelpLookup["paclet:Units/ref/Pint"], "Point" :> 
         Documentation`HelpLookup["paclet:ref/Point"], "Poise" :> 
         Documentation`HelpLookup["paclet:Units/ref/Poise"], "Pole" :> 
         Documentation`HelpLookup["paclet:Units/ref/Pole"], "Pondus" :> 
         Documentation`HelpLookup["paclet:Units/ref/Pondus"], "Pony" :> 
         Documentation`HelpLookup["paclet:Units/ref/Pony"], "Pound" :> 
         Documentation`HelpLookup["paclet:Units/ref/Pound"], "Poundal" :> 
         Documentation`HelpLookup["paclet:Units/ref/Poundal"], "PoundForce" :> 
         Documentation`HelpLookup["paclet:Units/ref/PoundForce"], 
         "PoundWeight" :> 
         Documentation`HelpLookup["paclet:Units/ref/PoundWeight"], 
         "PrintersPoint" :> 
         Documentation`HelpLookup["paclet:Units/ref/PrintersPoint"], 
         "Puncheon" :> Documentation`HelpLookup["paclet:Units/ref/Puncheon"], 
         "Quadrant" :> Documentation`HelpLookup["paclet:Units/ref/Quadrant"], 
         "Quart" :> Documentation`HelpLookup["paclet:Units/ref/Quart"], 
         "Quintal" :> Documentation`HelpLookup["paclet:Units/ref/Quintal"], 
         "Rad" :> Documentation`HelpLookup["paclet:Units/ref/Rad"], "Radian" :> 
         Documentation`HelpLookup["paclet:Units/ref/Radian"], "Rankine" :> 
         Documentation`HelpLookup["paclet:Units/ref/Rankine"], "RegisterTon" :> 
         Documentation`HelpLookup["paclet:Units/ref/RegisterTon"], "Reyn" :> 
         Documentation`HelpLookup["paclet:Units/ref/Reyn"], "Rhes" :> 
         Documentation`HelpLookup["paclet:Units/ref/Rhes"], "RightAngle" :> 
         Documentation`HelpLookup["paclet:Units/ref/RightAngle"], "Rod" :> 
         Documentation`HelpLookup["paclet:Units/ref/Rod"], "Roentgen" :> 
         Documentation`HelpLookup["paclet:Units/ref/Roentgen"], "Rontgen" :> 
         Documentation`HelpLookup["paclet:Units/ref/Rontgen"], "Rood" :> 
         Documentation`HelpLookup["paclet:Units/ref/Rood"], "Rope" :> 
         Documentation`HelpLookup["paclet:Units/ref/Rope"], "Rutherford" :> 
         Documentation`HelpLookup["paclet:Units/ref/Rutherford"], "Rydberg" :> 
         Documentation`HelpLookup["paclet:Units/ref/Rydberg"], "Seam" :> 
         Documentation`HelpLookup["paclet:Units/ref/Seam"], "Second" :> 
         Documentation`HelpLookup["paclet:Units/ref/Second"], "Section" :> 
         Documentation`HelpLookup["paclet:Units/ref/Section"], "Shekel" :> 
         Documentation`HelpLookup["paclet:Units/ref/Shekel"], 
         "ShortHundredweight" :> 
         Documentation`HelpLookup["paclet:Units/ref/ShortHundredweight"], 
         "ShortTon" :> Documentation`HelpLookup["paclet:Units/ref/ShortTon"], 
         "Shot" :> Documentation`HelpLookup["paclet:Units/ref/Shot"], "SI" :> 
         Documentation`HelpLookup["paclet:Units/ref/SI"], "SiderealSecond" :> 
         Documentation`HelpLookup["paclet:Units/ref/SiderealSecond"], 
         "SiderealYear" :> 
         Documentation`HelpLookup["paclet:Units/ref/SiderealYear"], "Siemens" :> 
         Documentation`HelpLookup["paclet:Units/ref/Siemens"], "Skein" :> 
         Documentation`HelpLookup["paclet:Units/ref/Skein"], "Slug" :> 
         Documentation`HelpLookup["paclet:Units/ref/Slug"], "SolarMass" :> 
         Documentation`HelpLookup["paclet:Units/ref/SolarMass"], "Span" :> 
         Documentation`HelpLookup["paclet:ref/Span"], "Stadion" :> 
         Documentation`HelpLookup["paclet:Units/ref/Stadion"], "Stadium" :> 
         Documentation`HelpLookup["paclet:Units/ref/Stadium"], "Statampere" :> 
         Documentation`HelpLookup["paclet:Units/ref/Statampere"], 
         "Statcoulomb" :> 
         Documentation`HelpLookup["paclet:Units/ref/Statcoulomb"], 
         "Statfarad" :> 
         Documentation`HelpLookup["paclet:Units/ref/Statfarad"], "Stathenry" :> 
         Documentation`HelpLookup["paclet:Units/ref/Stathenry"], "Statohm" :> 
         Documentation`HelpLookup["paclet:Units/ref/Statohm"], "StatuteMile" :> 
         Documentation`HelpLookup["paclet:Units/ref/StatuteMile"], "Statvolt" :> 
         Documentation`HelpLookup["paclet:Units/ref/Statvolt"], "Steradian" :> 
         Documentation`HelpLookup["paclet:Units/ref/Steradian"], "Stere" :> 
         Documentation`HelpLookup["paclet:Units/ref/Stere"], "Stilb" :> 
         Documentation`HelpLookup["paclet:Units/ref/Stilb"], "Stokes" :> 
         Documentation`HelpLookup["paclet:Units/ref/Stokes"], "Stone" :> 
         Documentation`HelpLookup["paclet:Units/ref/Stone"], "SurveyMile" :> 
         Documentation`HelpLookup["paclet:Units/ref/SurveyMile"], 
         "Tablespoon" :> 
         Documentation`HelpLookup["paclet:Units/ref/Tablespoon"], "Talbot" :> 
         Documentation`HelpLookup["paclet:Units/ref/Talbot"], "Talent" :> 
         Documentation`HelpLookup["paclet:Units/ref/Talent"], "Teaspoon" :> 
         Documentation`HelpLookup["paclet:Units/ref/Teaspoon"], "Tesla" :> 
         Documentation`HelpLookup["paclet:Units/ref/Tesla"], "Therm" :> 
         Documentation`HelpLookup["paclet:Units/ref/Therm"], "Ton" :> 
         Documentation`HelpLookup["paclet:Units/ref/Ton"], "TonForce" :> 
         Documentation`HelpLookup["paclet:Units/ref/TonForce"], "Tonne" :> 
         Documentation`HelpLookup["paclet:Units/ref/Tonne"], "Torr" :> 
         Documentation`HelpLookup["paclet:Units/ref/Torr"], "Township" :> 
         Documentation`HelpLookup["paclet:Units/ref/Township"], 
         "TropicalYear" :> 
         Documentation`HelpLookup["paclet:Units/ref/TropicalYear"], 
         "TroyOunce" :> 
         Documentation`HelpLookup["paclet:Units/ref/TroyOunce"], "Tun" :> 
         Documentation`HelpLookup["paclet:Units/ref/Tun"], "UKGallon" :> 
         Documentation`HelpLookup["paclet:Units/ref/UKGallon"], "UKPint" :> 
         Documentation`HelpLookup["paclet:Units/ref/UKPint"], "Volt" :> 
         Documentation`HelpLookup["paclet:Units/ref/Volt"], "Watt" :> 
         Documentation`HelpLookup["paclet:Units/ref/Watt"], "Weber" :> 
         Documentation`HelpLookup["paclet:Units/ref/Weber"], "Week" :> 
         Documentation`HelpLookup["paclet:Units/ref/Week"], "Wey" :> 
         Documentation`HelpLookup["paclet:Units/ref/Wey"], "WineBottle" :> 
         Documentation`HelpLookup["paclet:Units/ref/WineBottle"], "XUnit" :> 
         Documentation`HelpLookup["paclet:Units/ref/XUnit"], "Yard" :> 
         Documentation`HelpLookup["paclet:Units/ref/Yard"], "Year" :> 
         Documentation`HelpLookup["paclet:Units/ref/Year"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"Abampere\"\>", 
      2->"\<\"Abcoulomb\"\>", 3->"\<\"Abfarad\"\>", 4->"\<\"Abhenry\"\>", 
      5->"\<\"Abmho\"\>", 6->"\<\"Abohm\"\>", 7->"\<\"Abvolt\"\>", 
      8->"\<\"Acre\"\>", 9->"\<\"Amp\"\>", 10->"\<\"AMU\"\>", 
      11->"\<\"Apostilb\"\>", 12->"\<\"ArcMinute\"\>", 
      13->"\<\"ArcSecond\"\>", 14->"\<\"Are\"\>", 15->"\<\"AssayTon\"\>", 
      16->"\<\"Atmosphere\"\>", 17->"\<\"AtomicMassUnit\"\>", 
      18->"\<\"AU\"\>", 19->"\<\"AvoirdupoisOunce\"\>", 
      20->"\<\"AvoirdupoisPound\"\>", 21->"\<\"Bag\"\>", 
      22->"\<\"BakersDozen\"\>", 23->"\<\"Bale\"\>", 24->"\<\"Bar\"\>", 
      25->"\<\"Barn\"\>", 26->"\<\"Barrel\"\>", 27->"\<\"Barye\"\>", 
      28->"\<\"Baud\"\>", 29->"\<\"Becquerel\"\>", 30->"\<\"Biot\"\>", 
      31->"\<\"Bit\"\>", 32->"\<\"BoardFoot\"\>", 33->"\<\"BohrMagneton\"\>", 
      34->"\<\"Bolt\"\>", 35->"\<\"BritishThermalUnit\"\>", 36->"\<\"BTU\"\>",
       37->"\<\"Bucket\"\>", 38->"\<\"Bushel\"\>", 39->"\<\"Butt\"\>", 
      40->"\<\"Byte\"\>", 41->"\<\"Cable\"\>", 42->"\<\"Caliber\"\>", 
      43->"\<\"Calorie\"\>", 44->"\<\"Candela\"\>", 45->"\<\"Candle\"\>", 
      46->"\<\"Carat\"\>", 47->"\<\"Celsius\"\>", 48->"\<\"Cental\"\>", 
      49->"\<\"Centigrade\"\>", 50->"\<\"Centimeter\"\>", 
      51->"\<\"Century\"\>", 52->"\<\"CGS\"\>", 53->"\<\"Chain\"\>", 
      54->"\<\"ChevalVapeur\"\>", 55->"\<\"Cicero\"\>", 56->"\<\"Circle\"\>", 
      57->"\<\"Convert\"\>", 58->"\<\"ConvertTemperature\"\>", 
      59->"\<\"Cord\"\>", 60->"\<\"Coulomb\"\>", 61->"\<\"Cubit\"\>", 
      62->"\<\"Cup\"\>", 63->"\<\"Curie\"\>", 64->"\<\"Dalton\"\>", 
      65->"\<\"Day\"\>", 66->"\<\"Decade\"\>", 67->"\<\"Degree\"\>", 
      68->"\<\"Denier\"\>", 69->"\<\"Didot\"\>", 70->"\<\"DidotPoint\"\>", 
      71->"\<\"Diopter\"\>", 72->"\<\"Dozen\"\>", 73->"\<\"Drachma\"\>", 
      74->"\<\"Drop\"\>", 75->"\<\"Dyne\"\>", 76->"\<\"ElectronVolt\"\>", 
      77->"\<\"Ell\"\>", 78->"\<\"Ephah\"\>", 79->"\<\"Erg\"\>", 
      80->"\<\"Fahrenheit\"\>", 81->"\<\"Farad\"\>", 82->"\<\"Fathom\"\>", 
      83->"\<\"Feet\"\>", 84->"\<\"Fermi\"\>", 85->"\<\"Fifth\"\>", 
      86->"\<\"Firkin\"\>", 87->"\<\"FluidDram\"\>", 88->"\<\"FluidOunce\"\>",
       89->"\<\"Foot\"\>", 90->"\<\"FootCandle\"\>", 91->"\<\"Fortnight\"\>", 
      92->"\<\"Furlong\"\>", 93->"\<\"Gal\"\>", 94->"\<\"Gallon\"\>", 
      95->"\<\"Gamma\"\>", 96->"\<\"Gauss\"\>", 97->"\<\"Geepound\"\>", 
      98->"\<\"Gilbert\"\>", 99->"\<\"Gill\"\>", 100->"\<\"Grade\"\>", 
      101->"\<\"Grain\"\>", 102->"\<\"Gram\"\>", 103->"\<\"GramWeight\"\>", 
      104->"\<\"Gravity\"\>", 105->"\<\"GrayDose\"\>", 106->"\<\"Gross\"\>", 
      107->"\<\"GrossHundredweight\"\>", 108->"\<\"Hand\"\>", 
      109->"\<\"Hectare\"\>", 110->"\<\"Hefner\"\>", 111->"\<\"Henry\"\>", 
      112->"\<\"Hertz\"\>", 113->"\<\"Hogshead\"\>", 
      114->"\<\"Horsepower\"\>", 115->"\<\"Hour\"\>", 
      116->"\<\"Hundredweight\"\>", 117->"\<\"Inch\"\>", 
      118->"\<\"InchMercury\"\>", 119->"\<\"Jeroboam\"\>", 
      120->"\<\"Jigger\"\>", 121->"\<\"Joule\"\>", 122->"\<\"Kayser\"\>", 
      123->"\<\"Kelvin\"\>", 124->"\<\"Kilogram\"\>", 
      125->"\<\"KilogramForce\"\>", 126->"\<\"KilogramWeight\"\>", 
      127->"\<\"Knot\"\>", 128->"\<\"Lambert\"\>", 129->"\<\"Last\"\>", 
      130->"\<\"League\"\>", 131->"\<\"Libra\"\>", 132->"\<\"LightYear\"\>", 
      133->"\<\"Link\"\>", 134->"\<\"Liter\"\>", 135->"\<\"LongTon\"\>", 
      136->"\<\"Lumerg\"\>", 137->"\<\"Magnum\"\>", 138->"\<\"Maxwell\"\>", 
      139->"\<\"Meter\"\>", 140->"\<\"MetricTon\"\>", 141->"\<\"Mho\"\>", 
      142->"\<\"Micron\"\>", 143->"\<\"Mil\"\>", 144->"\<\"Mile\"\>", 
      145->"\<\"Millennium\"\>", 146->"\<\"MillimeterMercury\"\>", 
      147->"\<\"Mina\"\>", 148->"\<\"Minim\"\>", 149->"\<\"Minute\"\>", 
      150->"\<\"MKS\"\>", 151->"\<\"Mole\"\>", 152->"\<\"Month\"\>", 
      153->"\<\"NauticalMile\"\>", 154->"\<\"NetHundredweight\"\>", 
      155->"\<\"Newton\"\>", 156->"\<\"Nibble\"\>", 157->"\<\"Nit\"\>", 
      158->"\<\"Noggin\"\>", 159->"\<\"NuclearMagneton\"\>", 
      160->"\<\"Obolos\"\>", 161->"\<\"Oersted\"\>", 162->"\<\"Ohm\"\>", 
      163->"\<\"Omer\"\>", 164->"\<\"Ounce\"\>", 165->"\<\"Parsec\"\>", 
      166->"\<\"Pascal\"\>", 167->"\<\"Pennyweight\"\>", 
      168->"\<\"Percent\"\>", 169->"\<\"Perch\"\>", 170->"\<\"Phot\"\>", 
      171->"\<\"Pica\"\>", 172->"\<\"Pint\"\>", 173->"\<\"Point\"\>", 
      174->"\<\"Poise\"\>", 175->"\<\"Pole\"\>", 176->"\<\"Pondus\"\>", 
      177->"\<\"Pony\"\>", 178->"\<\"Pound\"\>", 179->"\<\"Poundal\"\>", 
      180->"\<\"PoundForce\"\>", 181->"\<\"PoundWeight\"\>", 
      182->"\<\"PrintersPoint\"\>", 183->"\<\"Puncheon\"\>", 
      184->"\<\"Quadrant\"\>", 185->"\<\"Quart\"\>", 186->"\<\"Quintal\"\>", 
      187->"\<\"Rad\"\>", 188->"\<\"Radian\"\>", 189->"\<\"Rankine\"\>", 
      190->"\<\"RegisterTon\"\>", 191->"\<\"Reyn\"\>", 192->"\<\"Rhes\"\>", 
      193->"\<\"RightAngle\"\>", 194->"\<\"Rod\"\>", 195->"\<\"Roentgen\"\>", 
      196->"\<\"Rontgen\"\>", 197->"\<\"Rood\"\>", 198->"\<\"Rope\"\>", 
      199->"\<\"Rutherford\"\>", 200->"\<\"Rydberg\"\>", 201->"\<\"Seam\"\>", 
      202->"\<\"Second\"\>", 203->"\<\"Section\"\>", 204->"\<\"Shekel\"\>", 
      205->"\<\"ShortHundredweight\"\>", 206->"\<\"ShortTon\"\>", 
      207->"\<\"Shot\"\>", 208->"\<\"SI\"\>", 209->"\<\"SiderealSecond\"\>", 
      210->"\<\"SiderealYear\"\>", 211->"\<\"Siemens\"\>", 
      212->"\<\"Skein\"\>", 213->"\<\"Slug\"\>", 214->"\<\"SolarMass\"\>", 
      215->"\<\"Span\"\>", 216->"\<\"Stadion\"\>", 217->"\<\"Stadium\"\>", 
      218->"\<\"Statampere\"\>", 219->"\<\"Statcoulomb\"\>", 
      220->"\<\"Statfarad\"\>", 221->"\<\"Stathenry\"\>", 
      222->"\<\"Statohm\"\>", 223->"\<\"StatuteMile\"\>", 
      224->"\<\"Statvolt\"\>", 225->"\<\"Steradian\"\>", 226->"\<\"Stere\"\>",
       227->"\<\"Stilb\"\>", 228->"\<\"Stokes\"\>", 229->"\<\"Stone\"\>", 
      230->"\<\"SurveyMile\"\>", 231->"\<\"Tablespoon\"\>", 
      232->"\<\"Talbot\"\>", 233->"\<\"Talent\"\>", 234->"\<\"Teaspoon\"\>", 
      235->"\<\"Tesla\"\>", 236->"\<\"Therm\"\>", 237->"\<\"Ton\"\>", 
      238->"\<\"TonForce\"\>", 239->"\<\"Tonne\"\>", 240->"\<\"Torr\"\>", 
      241->"\<\"Township\"\>", 242->"\<\"TropicalYear\"\>", 
      243->"\<\"TroyOunce\"\>", 244->"\<\"Tun\"\>", 245->"\<\"UKGallon\"\>", 
      246->"\<\"UKPint\"\>", 247->"\<\"Volt\"\>", 248->"\<\"Watt\"\>", 
      249->"\<\"Weber\"\>", 250->"\<\"Week\"\>", 251->"\<\"Wey\"\>", 
      252->"\<\"WineBottle\"\>", 253->"\<\"XUnit\"\>", 254->"\<\"Yard\"\>", 
      255->"\<\"Year\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Units Package", "Title",
 CellID->3338],

Cell[TextData[{
 "There are many systems of units. The particular set of units that is used \
depends on factors as various as the field of study and the author\
\[CloseCurlyQuote]s country of origin. The function ",
 Cell[BoxData[
  ButtonBox["Convert",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Convert"]], "InlineFormula"],
 " provides conversion between different units. "
}], "Text",
 CellID->22130],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     RowBox[{
      ButtonBox["Convert",
       BaseStyle->"Link",
       ButtonData->"paclet:Units/ref/Convert"], "[", 
      RowBox[{
       StyleBox["old", "TI"], ",", 
       StyleBox["newunits", "TI"]}], "]"}], " "}], Cell[TextData[{
     "convert ",
     StyleBox["old", "TI"],
     " to a form involving a combination of ",
     StyleBox["newunits", "TI"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->21890],

Cell["Converting units. ", "Caption",
 CellID->26276],

Cell["This loads the package. ", "MathCaption",
 CellID->26555],

Cell[BoxData[
 RowBox[{"<<", "Units`"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26799],

Cell["This converts meters per second into miles per hour. ", "MathCaption",
 CellID->13334],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convert", "[", 
  RowBox[{
   RowBox[{"12", 
    FractionBox[
     RowBox[{" ", "Meter"}], "Second"]}], ",", 
   FractionBox["Mile", "Hour"]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5707],

Cell[BoxData[
 FractionBox[
  RowBox[{"37500", " ", "Mile"}], 
  RowBox[{"1397", " ", "Hour"}]]], "Output",
 ImageSize->{77, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->38369171]
}, Open  ]],

Cell["You have to give prefixes for units as separate words. ", "MathCaption",
 CellID->4669],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convert", "[", 
  RowBox[{
   RowBox[{"3", 
    FractionBox[
     RowBox[{" ", 
      RowBox[{"Kilo", " ", "Meter"}]}], "Hour"]}], ",", 
   FractionBox["Inch", "Minute"]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->13512],

Cell[BoxData[
 FractionBox[
  RowBox[{"250000", " ", "Inch"}], 
  RowBox[{"127", " ", "Minute"}]]], "Output",
 ImageSize->{84, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1111812]
}, Open  ]],

Cell[TextData[{
 "The conversion of temperature units is different from most other unit \
conversions, because it is not multiplicative. This is simply because the \
zeros of various systems are set at different values. For example, zero \
degrees Centigrade is the same as ",
 Cell[BoxData[
  FormBox["32", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " degrees Fahrenheit. "
}], "Text",
 CellID->8775],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     RowBox[{
      ButtonBox["ConvertTemperature",
       BaseStyle->"Link",
       ButtonData->"paclet:Units/ref/ConvertTemperature"], "[", 
      RowBox[{
       StyleBox["temp", "TI"], ",", 
       StyleBox["oldunits", "TI"], ",", 
       StyleBox["newunits", "TI"]}], "]"}], " "}], Cell[TextData[{
     "convert ",
     Cell[BoxData[
      StyleBox["temp", "TI"]], "InlineFormula"],
     " from the ",
     Cell[BoxData[
      StyleBox["oldunits", "TI"]], "InlineFormula"],
     " scale to the ",
     Cell[BoxData[
      StyleBox["newunits", "TI"]], "InlineFormula"],
     " scale"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->3376],

Cell["Converting temperatures. ", "Caption",
 CellID->32426],

Cell[TextData[{
 "This converts the temperature. ",
 Cell[BoxData[
  ButtonBox["Convert",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Convert"]], "InlineFormula"],
 " only converts the units of temperature. "
}], "MathCaption",
 CellID->28875],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConvertTemperature", "[", 
  RowBox[{"20", ",", "Fahrenheit", ",", "Centigrade"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->28459],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["20", "3"]}]], "Output",
 ImageSize->{30, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->97646204]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Celsius",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Celsius"], 
    ButtonBox["Centigrade",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Centigrade"]},
   {
    ButtonBox["Fahrenheit",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Fahrenheit"], 
    ButtonBox["Kelvin",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Kelvin"]},
   {
    ButtonBox["Rankine",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Rankine"], "\[Null]"}
  }]], "DefinitionBox",
 CellID->26441],

Cell["Temperature scales.", "Caption",
 CellID->10983],

Cell[TextData[{
 "To organize the use of units, certain standardized systems have been \
developed. These include the International System (SI) and systems using \
particular metric units, such as the meter/kilogram/second system. The \
functions ",
 Cell[BoxData[
  ButtonBox["SI",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/SI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["MKS",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/MKS"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["CGS",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/CGS"]], "InlineFormula"],
 " convert various units into the standard systems. "
}], "Text",
 CellID->24361],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     RowBox[{
      ButtonBox["SI",
       BaseStyle->"Link",
       ButtonData->"paclet:Units/ref/SI"], "[", 
      StyleBox["expr", "TI"], "]"}], " "}], Cell[TextData[{
     "convert ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " to SI units (International System)"
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["MKS",
       BaseStyle->"Link",
       ButtonData->"paclet:Units/ref/MKS"], "[", 
      StyleBox["expr", "TI"], "]"}], " "}], Cell[TextData[{
     "convert ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " to MKS units (meter/kilogram/second)"
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["CGS",
       BaseStyle->"Link",
       ButtonData->"paclet:Units/ref/CGS"], "[", 
      StyleBox["expr", "TI"], "]"}], " "}], Cell[TextData[{
     "convert ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " to CGS units (centimeter/gram/second)"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->8896],

Cell["Conversion of units into standard systems. ", "Caption",
 CellID->24021],

Cell["The International Standard unit for pressure is the Pascal. ", \
"MathCaption",
 CellID->26171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SI", "[", 
  RowBox[{"3", " ", "Atmosphere"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->32395],

Cell[BoxData[
 RowBox[{"303975.`", " ", "Pascal"}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->29164619]
}, Open  ]],

Cell["You can request information about any unit. ", "MathCaption",
 CellID->4482],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Pascal"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->5176],

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"Pascal is the derived SI unit of pressure.\"\>", "MSG"], " ", 
  
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Pascal"]}]], "Print", "PrintUsage",
 CellTags->"Info3379239281-7406222",
 CellID->1124845741]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Yocto",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Yocto"], Cell[TextData[Cell[BoxData[
     SuperscriptBox["10", 
      RowBox[{"-", "24"}]]], "InlineFormula"]], "TableText"], 
    ButtonBox["Deca",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Deca"], Cell[TextData[Cell[BoxData[
     SuperscriptBox["10", "1"]], "InlineFormula"]], "TableText"]},
   {
    ButtonBox["Zepto",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Zepto"], Cell[TextData[Cell[BoxData[
     SuperscriptBox["10", 
      RowBox[{"-", "21"}]]], "InlineFormula"]], "TableText"], 
    ButtonBox["Hecto",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Hecto"], Cell[TextData[Cell[BoxData[
     SuperscriptBox["10", "2"]], "InlineFormula"]], "TableText"]},
   {
    ButtonBox["Atto",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Atto"], Cell[TextData[Cell[BoxData[
     SuperscriptBox["10", 
      RowBox[{"-", "18"}]]], "InlineFormula"]], "TableText"], 
    ButtonBox["Kilo",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Kilo"], Cell[TextData[Cell[BoxData[
     SuperscriptBox["10", "3"]], "InlineFormula"]], "TableText"]},
   {
    ButtonBox["Femto",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Femto"], Cell[TextData[Cell[BoxData[
     SuperscriptBox["10", 
      RowBox[{"-", "15"}]]], "InlineFormula"]], "TableText"], 
    ButtonBox["Mega",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Mega"], Cell[TextData[Cell[BoxData[
     SuperscriptBox["10", "6"]], "InlineFormula"]], "TableText"]},
   {
    ButtonBox["Pico",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Pico"], Cell[TextData[Cell[BoxData[
     SuperscriptBox["10", 
      RowBox[{"-", "12"}]]], "InlineFormula"]], "TableText"], 
    ButtonBox["Giga",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Giga"], Cell[TextData[Cell[BoxData[
     SuperscriptBox["10", "9"]], "InlineFormula"]], "TableText"]},
   {
    ButtonBox["Nano",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Nano"], Cell[TextData[Cell[BoxData[
     SuperscriptBox["10", 
      RowBox[{"-", "9"}]]], "InlineFormula"]], "TableText"], 
    ButtonBox["Tera",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Tera"], Cell[TextData[Cell[BoxData[
     SuperscriptBox["10", "12"]], "InlineFormula"]], "TableText"]},
   {
    ButtonBox["Micro",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Micro"], Cell[TextData[Cell[BoxData[
     SuperscriptBox["10", 
      RowBox[{"-", "6"}]]], "InlineFormula"]], "TableText"], 
    ButtonBox["Peta",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Peta"], Cell[TextData[Cell[BoxData[
     SuperscriptBox["10", "15"]], "InlineFormula"]], "TableText"]},
   {
    ButtonBox["Milli",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Milli"], Cell[TextData[Cell[BoxData[
     SuperscriptBox["10", 
      RowBox[{"-", "3"}]]], "InlineFormula"]], "TableText"], 
    ButtonBox["Exa",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Exa"], Cell[TextData[Cell[BoxData[
     SuperscriptBox["10", "18"]], "InlineFormula"]], "TableText"]},
   {
    ButtonBox["Centi",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Centi"], Cell[TextData[Cell[BoxData[
     SuperscriptBox["10", 
      RowBox[{"-", "2"}]]], "InlineFormula"]], "TableText"], 
    ButtonBox["Zetta",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Zetta"], Cell[TextData[Cell[BoxData[
     SuperscriptBox["10", "21"]], "InlineFormula"]], "TableText"]},
   {
    ButtonBox["Deci",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Deci"], Cell[TextData[Cell[BoxData[
     SuperscriptBox["10", 
      RowBox[{"-", "1"}]]], "InlineFormula"]], "TableText"], 
    ButtonBox["Yotta",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Yotta"], Cell[TextData[Cell[BoxData[
     SuperscriptBox["10", "24"]], "InlineFormula"]], "TableText"]}
  }]], "DefinitionBox4Col",
 CellID->20909],

Cell["SI unit prefixes.", "Caption",
 CellID->22317],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Abampere",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Abampere"], 
    ButtonBox["Abcoulomb",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Abcoulomb"]},
   {
    ButtonBox["Abfarad",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Abfarad"], 
    ButtonBox["Abhenry",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Abhenry"]},
   {
    ButtonBox["Abmho",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Abmho"], 
    ButtonBox["Abohm",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Abohm"]},
   {
    ButtonBox["Abvolt",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Abvolt"], 
    ButtonBox["Amp",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Amp"]},
   {
    ButtonBox["Biot",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Biot"], 
    ButtonBox["Coulomb",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Coulomb"]},
   {
    ButtonBox["Farad",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Farad"], 
    ButtonBox["Gilbert",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Gilbert"]},
   {
    ButtonBox["Henry",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Henry"], 
    ButtonBox["Mho",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Mho"]},
   {
    ButtonBox["Ohm",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Ohm"], 
    ButtonBox["Siemens",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Siemens"]},
   {
    ButtonBox["Statampere",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Statampere"], 
    ButtonBox["Statcoulomb",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Statcoulomb"]},
   {
    ButtonBox["Statfarad",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Statfarad"], 
    ButtonBox["Stathenry",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Stathenry"]},
   {
    ButtonBox["Statohm",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Statohm"], 
    ButtonBox["Statvolt",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Statvolt"]},
   {
    ButtonBox["Volt",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Volt"], "\[Null]"}
  }]], "DefinitionBox",
 CellID->27221],

Cell["Electrical units.", "Caption",
 CellID->6734],

Cell[BoxData[GridBox[{
   {
    ButtonBox["AU",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/AU"], 
    ButtonBox["Bolt",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Bolt"]},
   {
    ButtonBox["Cable",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Cable"], 
    ButtonBox["Caliber",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Caliber"]},
   {
    ButtonBox["Centimeter",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Centimeter"], 
    ButtonBox["Chain",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Chain"]},
   {
    ButtonBox["Cicero",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Cicero"], 
    ButtonBox["Cubit",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Cubit"]},
   {
    ButtonBox["Didot",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Didot"], 
    ButtonBox["DidotPoint",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/DidotPoint"]},
   {
    ButtonBox["Ell",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Ell"], 
    ButtonBox["Fathom",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Fathom"]},
   {
    ButtonBox["Feet",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Feet"], 
    ButtonBox["Fermi",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Fermi"]},
   {
    ButtonBox["Foot",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Foot"], 
    ButtonBox["Furlong",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Furlong"]},
   {
    ButtonBox["Hand",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Hand"], 
    ButtonBox["Inch",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Inch"]},
   {
    ButtonBox["League",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/League"], 
    ButtonBox["LightYear",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/LightYear"]},
   {
    ButtonBox["Link",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Link"], 
    ButtonBox["Meter",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Meter"]},
   {
    ButtonBox["Micron",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Micron"], 
    ButtonBox["Mil",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Mil"]},
   {
    ButtonBox["Mile",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Mile"], 
    ButtonBox["NauticalMile",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/NauticalMile"]},
   {
    ButtonBox["Parsec",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Parsec"], 
    ButtonBox["Perch",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Perch"]},
   {
    ButtonBox["Pica",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Pica"], 
    ButtonBox["Point",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Point"]},
   {
    ButtonBox["Pole",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Pole"], 
    ButtonBox["PrintersPoint",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/PrintersPoint"]},
   {
    ButtonBox["Rod",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Rod"], 
    ButtonBox["Rope",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Rope"]},
   {
    ButtonBox["Skein",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Skein"], 
    ButtonBox["Span",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Span"]},
   {
    ButtonBox["Stadion",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Stadion"], 
    ButtonBox["Stadium",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Stadium"]},
   {
    ButtonBox["StatuteMile",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/StatuteMile"], 
    ButtonBox["SurveyMile",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/SurveyMile"]},
   {
    ButtonBox["XUnit",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/XUnit"], 
    ButtonBox["Yard",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Yard"]}
  }]], "DefinitionBox",
 CellID->4288],

Cell["Units of length.", "Caption",
 CellID->4675],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Baud",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Baud"], 
    ButtonBox["Bit",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Bit"]},
   {
    ButtonBox["Byte",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Byte"], 
    ButtonBox["Nibble",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Nibble"]}
  }]], "DefinitionBox",
 CellID->14178],

Cell["Units of information.", "Caption",
 CellID->639],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Century",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Century"], 
    ButtonBox["Day",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Day"]},
   {
    ButtonBox["Decade",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Decade"], 
    ButtonBox["Fortnight",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Fortnight"]},
   {
    ButtonBox["Hour",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Hour"], 
    ButtonBox["Millennium",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Millennium"]},
   {
    ButtonBox["Minute",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Minute"], 
    ButtonBox["Month",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Month"]},
   {
    ButtonBox["Second",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Second"], 
    ButtonBox["SiderealSecond",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/SiderealSecond"]},
   {
    ButtonBox["SiderealYear",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/SiderealYear"], 
    ButtonBox["TropicalYear",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/TropicalYear"]},
   {
    ButtonBox["Week",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Week"], 
    ButtonBox["Year",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Year"]}
  }]], "DefinitionBox",
 CellID->2920],

Cell["Units of time.", "Caption",
 CellID->9439],

Cell[BoxData[GridBox[{
   {
    ButtonBox["AMU",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/AMU"], 
    ButtonBox["AtomicMassUnit",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/AtomicMassUnit"]},
   {
    ButtonBox["Dalton",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Dalton"], 
    ButtonBox["Geepound",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Geepound"]},
   {
    ButtonBox["Gram",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Gram"], 
    ButtonBox["Kilogram",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Kilogram"]},
   {
    ButtonBox["MetricTon",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/MetricTon"], 
    ButtonBox["Quintal",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Quintal"]},
   {
    ButtonBox["Slug",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Slug"], 
    ButtonBox["SolarMass",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/SolarMass"]},
   {
    ButtonBox["Tonne",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Tonne"], "\[Null]"}
  }]], "DefinitionBox",
 CellID->8985],

Cell["Units of mass.", "Caption",
 CellID->21242],

Cell[BoxData[GridBox[{
   {
    ButtonBox["AssayTon",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/AssayTon"], 
    ButtonBox["AvoirdupoisOunce",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/AvoirdupoisOunce"]},
   {
    ButtonBox["AvoirdupoisPound",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/AvoirdupoisPound"], 
    ButtonBox["Bale",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Bale"]},
   {
    ButtonBox["Carat",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Carat"], 
    ButtonBox["Cental",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Cental"]},
   {
    ButtonBox["Drachma",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Drachma"], 
    ButtonBox["Grain",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Grain"]},
   {
    ButtonBox["GrossHundredweight",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/GrossHundredweight"], 
    ButtonBox["Hundredweight",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Hundredweight"]},
   {
    ButtonBox["Libra",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Libra"], 
    ButtonBox["LongTon",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/LongTon"]},
   {
    ButtonBox["Mina",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Mina"], 
    ButtonBox["NetHundredweight",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/NetHundredweight"]},
   {
    ButtonBox["Obolos",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Obolos"], 
    ButtonBox["Ounce",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Ounce"]},
   {
    ButtonBox["Pennyweight",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Pennyweight"], 
    ButtonBox["Pondus",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Pondus"]},
   {
    ButtonBox["Pound",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Pound"], 
    ButtonBox["Shekel",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Shekel"]},
   {
    ButtonBox["ShortHundredweight",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/ShortHundredweight"], 
    ButtonBox["ShortTon",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/ShortTon"]},
   {
    ButtonBox["Stone",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Stone"], 
    ButtonBox["Talent",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Talent"]},
   {
    ButtonBox["Ton",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Ton"], 
    ButtonBox["TroyOunce",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/TroyOunce"]},
   {
    ButtonBox["Wey",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Wey"], "\[Null]"}
  }]], "DefinitionBox",
 CellID->25687],

Cell["Units of weight.", "Caption",
 CellID->11058],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Dyne",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Dyne"], 
    ButtonBox["GramWeight",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/GramWeight"]},
   {
    ButtonBox["KilogramForce",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/KilogramForce"], 
    ButtonBox["KilogramWeight",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/KilogramWeight"]},
   {
    ButtonBox["Newton",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Newton"], 
    ButtonBox["Poundal",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Poundal"]},
   {
    ButtonBox["PoundForce",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/PoundForce"], 
    ButtonBox["PoundWeight",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/PoundWeight"]},
   {
    ButtonBox["TonForce",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/TonForce"], "\[Null]"}
  }]], "DefinitionBox",
 CellID->3063],

Cell["Units of force.", "Caption",
 CellID->5915],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Diopter",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Diopter"], 
    ButtonBox["Kayser",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Kayser"]}
  }]], "DefinitionBox",
 CellID->17671],

Cell["Units of inverse length.", "Caption",
 CellID->1576],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Bag",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Bag"], 
    ButtonBox["Barrel",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Barrel"]},
   {
    ButtonBox["BoardFoot",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/BoardFoot"], 
    ButtonBox["Bucket",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Bucket"]},
   {
    ButtonBox["Bushel",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Bushel"], 
    ButtonBox["Butt",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Butt"]},
   {
    ButtonBox["Cord",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Cord"], 
    ButtonBox["Cup",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Cup"]},
   {
    ButtonBox["Drop",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Drop"], 
    ButtonBox["Ephah",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Ephah"]},
   {
    ButtonBox["Fifth",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Fifth"], 
    ButtonBox["Firkin",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Firkin"]},
   {
    ButtonBox["FluidDram",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/FluidDram"], 
    ButtonBox["FluidOunce",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/FluidOunce"]},
   {
    ButtonBox["Gallon",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Gallon"], 
    ButtonBox["Gill",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Gill"]},
   {
    ButtonBox["Hogshead",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Hogshead"], 
    ButtonBox["Jeroboam",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Jeroboam"]},
   {
    ButtonBox["Jigger",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Jigger"], 
    ButtonBox["Last",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Last"]},
   {
    ButtonBox["Liter",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Liter"], 
    ButtonBox["Magnum",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Magnum"]},
   {
    ButtonBox["Minim",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Minim"], 
    ButtonBox["Noggin",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Noggin"]},
   {
    ButtonBox["Omer",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Omer"], 
    ButtonBox["Pint",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Pint"]},
   {
    ButtonBox["Pony",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Pony"], 
    ButtonBox["Puncheon",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Puncheon"]},
   {
    ButtonBox["Quart",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Quart"], 
    ButtonBox["RegisterTon",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/RegisterTon"]},
   {
    ButtonBox["Seam",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Seam"], 
    ButtonBox["Shot",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Shot"]},
   {
    ButtonBox["Stere",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Stere"], 
    ButtonBox["Tablespoon",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Tablespoon"]},
   {
    ButtonBox["Teaspoon",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Teaspoon"], 
    ButtonBox["Tun",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Tun"]},
   {
    ButtonBox["UKGallon",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/UKGallon"], 
    ButtonBox["UKPint",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/UKPint"]},
   {
    ButtonBox["WineBottle",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/WineBottle"], "\[Null]"}
  }]], "DefinitionBox",
 CellID->30538],

Cell["Units of volume.", "Caption",
 CellID->1733],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Poise",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Poise"], 
    ButtonBox["Reyn",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Reyn"]},
   {
    ButtonBox["Rhes",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Rhes"], 
    ButtonBox["Stokes",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Stokes"]}
  }]], "DefinitionBox",
 CellID->28259],

Cell["Units of viscosity.", "Caption",
 CellID->31048],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Apostilb",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Apostilb"], 
    ButtonBox["Candela",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Candela"]},
   {
    ButtonBox["Candle",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Candle"], 
    ButtonBox["FootCandle",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/FootCandle"]},
   {
    ButtonBox["Hefner",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Hefner"], 
    ButtonBox["Lambert",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Lambert"]},
   {Cell["Lumen", "TableText"], 
    ButtonBox["Lumerg",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Lumerg"]},
   {Cell["Lux", "TableText"], 
    ButtonBox["Nit",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Nit"]},
   {
    ButtonBox["Phot",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Phot"], 
    ButtonBox["Stilb",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Stilb"]},
   {
    ButtonBox["Talbot",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Talbot"], "\[Null]"}
  }]], "DefinitionBox",
 CellID->18314],

Cell["Units of types of luminous energy and intensity.", "Caption",
 CellID->13151],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Becquerel",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Becquerel"], 
    ButtonBox["Curie",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Curie"]},
   {
    ButtonBox["GrayDose",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/GrayDose"], 
    ButtonBox["Rad",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Rad"]},
   {
    ButtonBox["Roentgen",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Roentgen"], 
    ButtonBox["Rontgen",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Rontgen"]},
   {
    ButtonBox["Rutherford",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Rutherford"], "\[Null]"}
  }]], "DefinitionBox",
 CellID->16836],

Cell["Units of radiation.", "Caption",
 CellID->24541],

Cell[BoxData[GridBox[{
   {
    ButtonBox["ArcMinute",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/ArcMinute"], 
    ButtonBox["ArcSecond",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/ArcSecond"]},
   {
    ButtonBox["Circle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Circle"], 
    ButtonBox["Degree",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Degree"]},
   {
    ButtonBox["Grade",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Grade"], 
    ButtonBox["Quadrant",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Quadrant"]},
   {
    ButtonBox["Radian",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Radian"], 
    ButtonBox["RightAngle",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/RightAngle"]},
   {
    ButtonBox["Steradian",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Steradian"], "\[Null]"}
  }]], "DefinitionBox",
 CellID->11500],

Cell["Angles.", "Caption",
 CellID->1564],

Cell[BoxData[GridBox[{
   {
    ButtonBox["ChevalVapeur",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/ChevalVapeur"], 
    ButtonBox["Horsepower",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Horsepower"]},
   {
    ButtonBox["Watt",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Watt"], "\[Null]"}
  }]], "DefinitionBox",
 CellID->22046],

Cell["Units of power.", "Caption",
 CellID->15699],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Acre",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Acre"], 
    ButtonBox["Are",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Are"]},
   {
    ButtonBox["Barn",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Barn"], 
    ButtonBox["Hectare",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Hectare"]},
   {
    ButtonBox["Rood",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Rood"], 
    ButtonBox["Section",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Section"]},
   {
    ButtonBox["Township",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Township"], "\[Null]"}
  }]], "DefinitionBox",
 CellID->1077],

Cell["Units of area.", "Caption",
 CellID->29568],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Dozen",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Dozen"], 
    ButtonBox["Gross",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Gross"]},
   {
    ButtonBox["Mole",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Mole"], "\[Null]"}
  }]], "DefinitionBox",
 CellID->28028],

Cell["Amounts of substances.", "Caption",
 CellID->11491],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Gal",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Gal"], 
    ButtonBox["Gravity",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Gravity"]}
  }]], "DefinitionBox",
 CellID->6092],

Cell["Acceleration due to gravity.", "Caption",
 CellID->2080],

Cell[BoxData[GridBox[{
   {
    ButtonBox["BohrMagneton",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/BohrMagneton"], 
    ButtonBox["Gauss",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Gauss"]},
   {
    ButtonBox["Gamma",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Gamma"], 
    ButtonBox["Maxwell",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Maxwell"]},
   {
    ButtonBox["NuclearMagneton",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/NuclearMagneton"], 
    ButtonBox["Oersted",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Oersted"]},
   {
    ButtonBox["Tesla",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Tesla"], 
    ButtonBox["Weber",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Weber"]}
  }]], "DefinitionBox",
 CellID->24233],

Cell["Magnetic units.", "Caption",
 CellID->29811],

Cell[BoxData[GridBox[{
   {
    ButtonBox["ArcSecond",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/ArcSecond"], 
    ButtonBox["BakersDozen",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/BakersDozen"]},
   {
    ButtonBox["Circle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Circle"], 
    ButtonBox["Degree",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Degree"]},
   {
    ButtonBox["Dozen",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Dozen"], 
    ButtonBox["Grade",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Grade"]},
   {
    ButtonBox["Gross",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Gross"], 
    ButtonBox["Percent",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Percent"]},
   {
    ButtonBox["Quadrant",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Quadrant"], 
    ButtonBox["RightAngle",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/RightAngle"]}
  }]], "DefinitionBox",
 CellID->30484],

Cell["Unit multipliers.", "Caption",
 CellID->12969],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Atmosphere",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Atmosphere"], 
    ButtonBox["Bar",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Bar"]},
   {
    ButtonBox["Barye",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Barye"], 
    ButtonBox["InchMercury",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/InchMercury"]},
   {
    ButtonBox["MillimeterMercury",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/MillimeterMercury"], 
    ButtonBox["Pascal",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Pascal"]},
   {
    ButtonBox["Torr",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Torr"], "\[Null]"}
  }]], "DefinitionBox",
 CellID->18224],

Cell["Units of pressure.", "Caption",
 CellID->16055],

Cell[BoxData[GridBox[{
   {
    ButtonBox["BritishThermalUnit",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/BritishThermalUnit"], 
    ButtonBox["BTU",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/BTU"]},
   {
    ButtonBox["Calorie",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Calorie"], 
    ButtonBox["ElectronVolt",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/ElectronVolt"]},
   {
    ButtonBox["Erg",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Erg"], 
    ButtonBox["Joule",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Joule"]},
   {
    ButtonBox["Rydberg",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Rydberg"], 
    ButtonBox["Therm",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Therm"]}
  }]], "DefinitionBox",
 CellID->22520],

Cell["Units of energy.", "Caption",
 CellID->28451],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Hertz",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Hertz"], "\[Null]"}
  }]], "DefinitionBox",
 CellID->6535],

Cell["Unit of frequency.", "Caption",
 CellID->16541],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Knot",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Knot"], "\[Null]"}
  }]], "DefinitionBox",
 CellID->14024],

Cell["Unit of speed.", "Caption",
 CellID->14199],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Denier",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Denier"], "\[Null]"}
  }]], "DefinitionBox",
 CellID->23432],

Cell["Unit of fineness for yarn or thread.", "Caption",
 CellID->19944]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Units Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 12, 44.3250284}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Tutorial", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> 
    "There are many systems of units. The particular set of units that is \
used depends on factors as various as the field of study and the author's \
country of origin. The function Convert provides conversion between different \
units. Converting units. This loads the package. ", "synonyms" -> {}, "title" -> 
    "Units Package", "type" -> "Tutorial", "uri" -> "Units/tutorial/Units"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3379239281-7406222"->{
  Cell[34816, 701, 323, 10, 70, "Print",
   CellTags->"Info3379239281-7406222",
   CellID->1124845741]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3379239281-7406222", 68600, 1920}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 26708, 384, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[27333, 411, 45, 1, 70, "Title",
 CellID->3338],
Cell[27381, 414, 417, 10, 70, "Text",
 CellID->22130],
Cell[27801, 426, 465, 16, 70, "DefinitionBox",
 CellID->21890],
Cell[28269, 444, 53, 1, 70, "Caption",
 CellID->26276],
Cell[28325, 447, 63, 1, 70, "MathCaption",
 CellID->26555],
Cell[28391, 450, 89, 3, 70, "Input",
 CellID->26799],
Cell[28483, 455, 92, 1, 70, "MathCaption",
 CellID->13334],
Cell[CellGroupData[{
Cell[28600, 460, 222, 8, 42, "Input",
 CellID->5707],
Cell[28825, 470, 236, 8, 52, "Output",
 CellID->38369171]
}, Open  ]],
Cell[29076, 481, 93, 1, 70, "MathCaption",
 CellID->4669],
Cell[CellGroupData[{
Cell[29194, 486, 252, 9, 70, "Input",
 CellID->13512],
Cell[29449, 497, 237, 8, 52, "Output",
 CellID->1111812]
}, Open  ]],
Cell[29701, 508, 538, 13, 70, "Text",
 CellID->8775],
Cell[30242, 523, 689, 23, 70, "DefinitionBox",
 CellID->3376],
Cell[30934, 548, 60, 1, 70, "Caption",
 CellID->32426],
Cell[30997, 551, 254, 8, 70, "MathCaption",
 CellID->28875],
Cell[CellGroupData[{
Cell[31276, 563, 162, 4, 70, "Input",
 CellID->28459],
Cell[31441, 569, 196, 7, 51, "Output",
 CellID->97646204]
}, Open  ]],
Cell[31652, 579, 577, 20, 70, "DefinitionBox",
 CellID->26441],
Cell[32232, 601, 54, 1, 70, "Caption",
 CellID->10983],
Cell[32289, 604, 692, 21, 70, "Text",
 CellID->24361],
Cell[32984, 627, 1089, 38, 70, "DefinitionBox",
 CellID->8896],
Cell[34076, 667, 78, 1, 70, "Caption",
 CellID->24021],
Cell[34157, 670, 101, 2, 70, "MathCaption",
 CellID->26171],
Cell[CellGroupData[{
Cell[34283, 676, 126, 4, 70, "Input",
 CellID->32395],
Cell[34412, 682, 192, 6, 36, "Output",
 CellID->29164619]
}, Open  ]],
Cell[34619, 691, 82, 1, 70, "MathCaption",
 CellID->4482],
Cell[CellGroupData[{
Cell[34726, 696, 87, 3, 70, "Input",
 CellID->5176],
Cell[34816, 701, 323, 10, 70, "Print",
 CellTags->"Info3379239281-7406222",
 CellID->1124845741]
}, Open  ]],
Cell[35154, 714, 4041, 102, 70, "DefinitionBox4Col",
 CellID->20909],
Cell[39198, 818, 52, 1, 70, "Caption",
 CellID->22317],
Cell[39253, 821, 2316, 83, 70, "DefinitionBox",
 CellID->27221],
Cell[41572, 906, 51, 1, 70, "Caption",
 CellID->6734],
Cell[41626, 909, 4081, 149, 70, "DefinitionBox",
 CellID->4288],
Cell[45710, 1060, 50, 1, 70, "Caption",
 CellID->4675],
Cell[45763, 1063, 427, 16, 70, "DefinitionBox",
 CellID->14178],
Cell[46193, 1081, 54, 1, 70, "Caption",
 CellID->639],
Cell[46250, 1084, 1447, 51, 70, "DefinitionBox",
 CellID->2920],
Cell[47700, 1137, 48, 1, 70, "Caption",
 CellID->9439],
Cell[47751, 1140, 1157, 41, 70, "DefinitionBox",
 CellID->8985],
Cell[48911, 1183, 49, 1, 70, "Caption",
 CellID->21242],
Cell[48963, 1186, 2798, 97, 70, "DefinitionBox",
 CellID->25687],
Cell[51764, 1285, 51, 1, 70, "Caption",
 CellID->11058],
Cell[51818, 1288, 1000, 34, 70, "DefinitionBox",
 CellID->3063],
Cell[52821, 1324, 49, 1, 70, "Caption",
 CellID->5915],
Cell[52873, 1327, 256, 9, 70, "DefinitionBox",
 CellID->17671],
Cell[53132, 1338, 58, 1, 70, "Caption",
 CellID->1576],
Cell[53193, 1341, 3816, 139, 70, "DefinitionBox",
 CellID->30538],
Cell[57012, 1482, 50, 1, 70, "Caption",
 CellID->1733],
Cell[57065, 1485, 437, 16, 70, "DefinitionBox",
 CellID->28259],
Cell[57505, 1503, 54, 1, 70, "Caption",
 CellID->31048],
Cell[57562, 1506, 1199, 42, 70, "DefinitionBox",
 CellID->18314],
Cell[58764, 1550, 83, 1, 70, "Caption",
 CellID->13151],
Cell[58850, 1553, 766, 27, 70, "DefinitionBox",
 CellID->16836],
Cell[59619, 1582, 54, 1, 70, "Caption",
 CellID->24541],
Cell[59676, 1585, 959, 34, 70, "DefinitionBox",
 CellID->11500],
Cell[60638, 1621, 41, 1, 70, "Caption",
 CellID->1564],
Cell[60682, 1624, 380, 13, 70, "DefinitionBox",
 CellID->22046],
Cell[61065, 1639, 50, 1, 70, "Caption",
 CellID->15699],
Cell[61118, 1642, 739, 27, 70, "DefinitionBox",
 CellID->1077],
Cell[61860, 1671, 49, 1, 70, "Caption",
 CellID->29568],
Cell[61912, 1674, 356, 13, 70, "DefinitionBox",
 CellID->28028],
Cell[62271, 1689, 57, 1, 70, "Caption",
 CellID->11491],
Cell[62331, 1692, 249, 9, 70, "DefinitionBox",
 CellID->6092],
Cell[62583, 1703, 62, 1, 70, "Caption",
 CellID->2080],
Cell[62648, 1706, 853, 30, 70, "DefinitionBox",
 CellID->24233],
Cell[63504, 1738, 50, 1, 70, "Caption",
 CellID->29811],
Cell[63557, 1741, 1038, 37, 70, "DefinitionBox",
 CellID->30484],
Cell[64598, 1780, 52, 1, 70, "Caption",
 CellID->12969],
Cell[64653, 1783, 778, 27, 70, "DefinitionBox",
 CellID->18224],
Cell[65434, 1812, 53, 1, 70, "Caption",
 CellID->16055],
Cell[65490, 1815, 857, 30, 70, "DefinitionBox",
 CellID->22520],
Cell[66350, 1847, 51, 1, 70, "Caption",
 CellID->28451],
Cell[66404, 1850, 168, 6, 70, "DefinitionBox",
 CellID->6535],
Cell[66575, 1858, 53, 1, 70, "Caption",
 CellID->16541],
Cell[66631, 1861, 167, 6, 70, "DefinitionBox",
 CellID->14024],
Cell[66801, 1869, 49, 1, 70, "Caption",
 CellID->14199],
Cell[66853, 1872, 171, 6, 70, "DefinitionBox",
 CellID->23432],
Cell[67027, 1880, 71, 1, 70, "Caption",
 CellID->19944]
}, Open  ]],
Cell[67113, 1884, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

