(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7961,        271]
NotebookOptionsPosition[      5509,        201]
NotebookOutlinePosition[      6873,        234]
CellTagsIndexPosition[      6830,        231]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Variational Methods Package", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[TextData[{
 Cell[TextData[ButtonBox["VariationalD",
  BaseStyle->"Link",
  ButtonData->"paclet:VariationalMethods/ref/VariationalD"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 StyleBox["first variational derivative of a functional ",
  GridBoxOptions->{
  GridBoxDividers->{
   "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
    "RowsIndexed" -> {}},
  GridBoxSpacings->{"Columns" -> {
      Offset[0.28], {
       Offset[0.56]}, 
      Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
      Offset[0.2], {
       Offset[0.16]}, 
      Offset[0.2]}, "RowsIndexed" -> {}}}]
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["EulerEquations",
  BaseStyle->"Link",
  ButtonData->"paclet:VariationalMethods/ref/EulerEquations"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 StyleBox["Euler equation for the functional",
  GridBoxOptions->{
  GridBoxDividers->{
   "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
    "RowsIndexed" -> {}},
  GridBoxSpacings->{"Columns" -> {
      Offset[0.28], {
       Offset[0.56]}, 
      Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
      Offset[0.2], {
       Offset[0.16]}, 
      Offset[0.2]}, "RowsIndexed" -> {}}}]
}], "GuideText",
 CellID->1463276848],

Cell["\t", "GuideDelimiter",
 CellID->209973613],

Cell[TextData[{
 Cell[TextData[ButtonBox["FirstIntegral",
  BaseStyle->"Link",
  ButtonData->"paclet:VariationalMethods/ref/FirstIntegral"]], 
  "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["FirstIntegrals",
  BaseStyle->"Link",
  ButtonData->"paclet:VariationalMethods/ref/FirstIntegrals"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 StyleBox["first integrals of the functional",
  GridBoxOptions->{
  GridBoxDividers->{
   "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
    "RowsIndexed" -> {}},
  GridBoxSpacings->{"Columns" -> {
      Offset[0.28], {
       Offset[0.56]}, 
      Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
      Offset[0.2], {
       Offset[0.16]}, 
      Offset[0.2]}, "RowsIndexed" -> {}}}]
}], "GuideText",
 CellID->357416231],

Cell["\t", "GuideDelimiter",
 CellID->920281956],

Cell[TextData[{
 Cell[TextData[ButtonBox["VariationalBound",
  BaseStyle->"Link",
  ButtonData->"paclet:VariationalMethods/ref/VariationalBound"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 StyleBox["upper bound for the eigenvalue and the optimal values of the \
range",
  GridBoxOptions->{
  GridBoxDividers->{
   "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
    "RowsIndexed" -> {}},
  GridBoxSpacings->{"Columns" -> {
      Offset[0.28], {
       Offset[0.56]}, 
      Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
      Offset[0.2], {
       Offset[0.16]}, 
      Offset[0.2]}, "RowsIndexed" -> {}}}]
}], "GuideText",
 CellID->96956342],

Cell[TextData[{
 Cell[TextData[ButtonBox["NVariationalBound",
  BaseStyle->"Link",
  ButtonData->"paclet:VariationalMethods/ref/NVariationalBound"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 StyleBox["evaluate variational bound numerically",
  GridBoxOptions->{
  GridBoxDividers->{
   "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
    "RowsIndexed" -> {}},
  GridBoxSpacings->{"Columns" -> {
      Offset[0.28], {
       Offset[0.56]}, 
      Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
      Offset[0.2], {
       Offset[0.16]}, 
      Offset[0.2]}, "RowsIndexed" -> {}}}]
}], "GuideText",
 CellID->4718227]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Packages for Symbolic Mathematics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PackagesForSymbolicMathematics"]], "GuideTutorial",
 CellID->164417897],

Cell[TextData[ButtonBox["Variational Methods",
 BaseStyle->"Link",
 ButtonData->
  "paclet:VariationalMethods/tutorial/VariationalMethods"]], "GuideTutorial",
 CellID->768490783]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:VectorAnalysis/guide/VectorAnalysisPackage"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Calculus",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Calculus"]], "GuideMoreAbout",
 CellID->396512973],

Cell[TextData[ButtonBox["Series Expansions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SeriesExpansions"]], "GuideMoreAbout",
 CellID->74771987]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Variational Methods Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 12, 50.5751884}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Variational Methods Package Guide", "language" -> "en", "paclet" -> 
    "VariationalMethods Package", "status" -> "None", "summary" -> 
    "VariationalD -- first variational derivative of a functional , \
EulerEquations -- Euler equation for the functional, FirstIntegral, \
FirstIntegrals -- first integrals of the functional, VariationalBound -- \
upper bound for the eigenvalue and the optimal values of the range, \
NVariationalBound -- evaluate variational bound numerically", 
    "synonyms" -> {}, "title" -> "Variational Methods Package", "type" -> 
    "Guide", "uri" -> "VariationalMethods/guide/VariationalMethodsPackage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 69, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[691, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[750, 31, 678, 21, 70, "GuideText",
 CellID->203374175],
Cell[1431, 54, 671, 21, 70, "GuideText",
 CellID->1463276848],
Cell[2105, 77, 48, 1, 70, "GuideDelimiter",
 CellID->209973613],
Cell[2156, 80, 829, 26, 70, "GuideText",
 CellID->357416231],
Cell[2988, 108, 48, 1, 70, "GuideDelimiter",
 CellID->920281956],
Cell[3039, 111, 708, 22, 70, "GuideText",
 CellID->96956342],
Cell[3750, 135, 679, 21, 70, "GuideText",
 CellID->4718227]
}, Open  ]],
Cell[CellGroupData[{
Cell[4466, 161, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[4531, 164, 185, 4, 70, "GuideTutorial",
 CellID->164417897],
Cell[4719, 170, 178, 4, 70, "GuideTutorial",
 CellID->768490783]
}, Open  ]],
Cell[CellGroupData[{
Cell[4934, 179, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[4999, 182, 180, 4, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[5182, 188, 133, 3, 70, "GuideMoreAbout",
 CellID->396512973],
Cell[5318, 193, 149, 3, 70, "GuideMoreAbout",
 CellID->74771987]
}, Open  ]],
Cell[5482, 199, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

