(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     52655,       1649]
NotebookOptionsPosition[     45665,       1408]
NotebookOutlinePosition[     47370,       1450]
CellTagsIndexPosition[     47284,       1445]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VARIATIONAL METHODS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Variational Methods" :> 
          Documentation`HelpLookup[
           "paclet:VariationalMethods/tutorial/VariationalMethods"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Variational Methods\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"VariationalD" :> 
          Documentation`HelpLookup[
           "paclet:VariationalMethods/ref/VariationalD"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"VariationalD\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["EulerEquations", "ObjectName",
 CellID->9515],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"EulerEquations", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{
         StyleBox["u", "TI"], "[", 
         RowBox[{
          StyleBox["x", "TI"], 
          RowBox[{"]", ","}], 
          StyleBox["x", "TI"]}], "]"}]}]}]], "InlineFormula"],
     "\[LineSeparator]returns the Euler-Lagrange differential equation obeyed \
by ",
     Cell[BoxData[
      RowBox[{
       StyleBox["u", "TI"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     " derived from the functional ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " depends on the function ",
     Cell[BoxData[
      RowBox[{
       StyleBox["u", "TI"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     " and its derivatives as well as the independent variable ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"EulerEquations", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{
         StyleBox["u", "TI"], "[", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns the Euler-Lagrange differential equation \
obeyed by ",
     Cell[BoxData[
      RowBox[{
       StyleBox["u", "TI"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"EulerEquations", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           StyleBox["u", "TI"], "[", 
           RowBox[{
            StyleBox["x", "TI"], ",", 
            StyleBox["y", "TI"], ",", 
            StyleBox["\[Ellipsis]", "TR"]}], "]"}], ",", 
          RowBox[{
           StyleBox["v", "TI"], "[", 
           RowBox[{
            StyleBox["x", "TI"], ",", 
            StyleBox["y", "TI"], ",", 
            StyleBox["\[Ellipsis]", "TR"]}], "]"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns a list of Euler-Lagrange differential equations \
obeyed by ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        StyleBox["u", "TI"], "[", 
        RowBox[{
         StyleBox["x", "TI"], ",", 
         StyleBox["y", "TI"], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "]"}], ",", 
       RowBox[{
        StyleBox["v", "TI"], "[", 
        RowBox[{
         StyleBox["x", "TI"], ",", 
         StyleBox["y", "TI"], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "]"}], ",", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->23542]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->103929230],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VariationalMethods`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->173292438],

Cell[TextData[{
 "The Euler equations for the arc length ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Integral]", 
    RowBox[{"\[DifferentialD]", "s"}]}], TraditionalForm]], "InlineMath"],
 " in 2 dimensions yields a straight line:"
}], "ExampleText",
 CellID->31665],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EulerEquations", "[", 
  RowBox[{
   SqrtBox[
    RowBox[{"1", "+", 
     SuperscriptBox[
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], "2"]}]], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18908],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["y", "\[Prime]\[Prime]",
      MultilineFunction->None], "[", "x", "]"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox[
        RowBox[{
         SuperscriptBox["y", "\[Prime]",
          MultilineFunction->None], "[", "x", "]"}], "2"]}], ")"}], 
     RowBox[{"3", "/", "2"}]]]}], "\[Equal]", "0"}]], "Output",
 ImageSize->{126, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->20340]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{"%", ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1360],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "+", 
     RowBox[{"x", " ", 
      RowBox[{"C", "[", "2", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{155, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2814]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21154],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VariationalMethods`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->434503559],

Cell[TextData[{
 "A simple pendulum has the Lagrangian ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     StyleBox["m", "TI"], " ", 
     SuperscriptBox[
      StyleBox["r", "TI"], "2"], " ", 
     SuperscriptBox[
      OverscriptBox[
       StyleBox["\[Theta]", "TR"], "."], "2"]}], "+", 
    RowBox[{
     StyleBox["m", "TI"], 
     StyleBox[" ", "TI"], 
     StyleBox["g", "TI"], " ", 
     StyleBox["r", "TI"], " ", 
     RowBox[{
      StyleBox["cos", "TR"], "(", 
      StyleBox["\[Theta]", "TR"], ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->18012],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EulerEquations", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], "m", " ", 
     SuperscriptBox["r", "2"], 
     SuperscriptBox[
      RowBox[{
       RowBox[{"\[Theta]", "'"}], "[", "t", "]"}], "2"]}], "+", 
    RowBox[{"m", " ", "g", " ", "r", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"\[Theta]", "[", "t", "]"}], "]"}]}]}], ",", 
   RowBox[{"\[Theta]", "[", "t", "]"}], ",", "t"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19752],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "m"}], " ", "r", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"g", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"\[Theta]", "[", "t", "]"}], "]"}]}], "+", 
     RowBox[{"r", " ", 
      RowBox[{
       SuperscriptBox["\[Theta]", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "t", "]"}]}]}], ")"}]}], "\[Equal]", 
  "0"}]], "Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10810198]
}, Open  ]],

Cell[TextData[{
 "The solution to the pendulum equation can be expressed using the function \
",
 Cell[BoxData[
  ButtonBox["JacobiAmplitude",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiAmplitude"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->8706],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\[Theta]", "[", "t", "]"}], ",", "t"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->12525],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->383974733],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Theta]", "[", "t", "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"JacobiAmplitude", "[", 
       RowBox[{
        FractionBox[
         SqrtBox[
          RowBox[{
           RowBox[{"2", " ", "g", " ", 
            SuperscriptBox["t", "2"]}], "+", 
           RowBox[{"r", " ", 
            SuperscriptBox["t", "2"], " ", 
            RowBox[{"C", "[", "1", "]"}]}], "+", 
           RowBox[{"4", " ", "g", " ", "t", " ", 
            RowBox[{"C", "[", "2", "]"}]}], "+", 
           RowBox[{"2", " ", "r", " ", "t", " ", 
            RowBox[{"C", "[", "1", "]"}], " ", 
            RowBox[{"C", "[", "2", "]"}]}], "+", 
           RowBox[{"2", " ", "g", " ", 
            SuperscriptBox[
             RowBox[{"C", "[", "2", "]"}], "2"]}], "+", 
           RowBox[{"r", " ", 
            RowBox[{"C", "[", "1", "]"}], " ", 
            SuperscriptBox[
             RowBox[{"C", "[", "2", "]"}], "2"]}]}]], 
         RowBox[{"2", " ", 
          SqrtBox["r"]}]], ",", 
        FractionBox[
         RowBox[{"4", " ", "g"}], 
         RowBox[{
          RowBox[{"2", " ", "g"}], "+", 
          RowBox[{"r", " ", 
           RowBox[{"C", "[", "1", "]"}]}]}]]}], "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Theta]", "[", "t", "]"}], "\[Rule]", 
     RowBox[{"2", " ", 
      RowBox[{"JacobiAmplitude", "[", 
       RowBox[{
        FractionBox[
         SqrtBox[
          RowBox[{
           RowBox[{"2", " ", "g", " ", 
            SuperscriptBox["t", "2"]}], "+", 
           RowBox[{"r", " ", 
            SuperscriptBox["t", "2"], " ", 
            RowBox[{"C", "[", "1", "]"}]}], "+", 
           RowBox[{"4", " ", "g", " ", "t", " ", 
            RowBox[{"C", "[", "2", "]"}]}], "+", 
           RowBox[{"2", " ", "r", " ", "t", " ", 
            RowBox[{"C", "[", "1", "]"}], " ", 
            RowBox[{"C", "[", "2", "]"}]}], "+", 
           RowBox[{"2", " ", "g", " ", 
            SuperscriptBox[
             RowBox[{"C", "[", "2", "]"}], "2"]}], "+", 
           RowBox[{"r", " ", 
            RowBox[{"C", "[", "1", "]"}], " ", 
            SuperscriptBox[
             RowBox[{"C", "[", "2", "]"}], "2"]}]}]], 
         RowBox[{"2", " ", 
          SqrtBox["r"]}]], ",", 
        FractionBox[
         RowBox[{"4", " ", "g"}], 
         RowBox[{
          RowBox[{"2", " ", "g"}], "+", 
          RowBox[{"r", " ", 
           RowBox[{"C", "[", "1", "]"}]}]}]]}], "]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{494, 178},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->212433079]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3079],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VariationalMethods`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->75593681],

Cell["\<\
The Lagrangian of a point particle in 2-dimensions has 2 dependent variables, \
and yields Newton's equations:\
\>", "ExampleText",
 CellID->8313],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EulerEquations", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], "m", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{
         RowBox[{"x", "'"}], "[", "t", "]"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{
         RowBox[{"y", "'"}], "[", "t", "]"}], "2"]}], ")"}]}], "-", 
    RowBox[{"V", "[", 
     RowBox[{
      RowBox[{"x", "[", "t", "]"}], ",", 
      RowBox[{"y", "[", "t", "]"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "[", "t", "]"}], ",", 
     RowBox[{"y", "[", "t", "]"}]}], "}"}], ",", "t"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28838],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWNtO4zAQdXNtKaXcxWUvSEgg8cblG0Ag8cAnVAgJBGhXwH/sR6z2efcH
VjzwYSZOx6lzMomdpghopTqd8fjM8cnYcXM+eLq+uh883VwOtk4eBj+vby4f
t45/PCQuvyVE668QYnFNJL9l8iv9qs+/5CtEkLQeuX7T7zDt8VXr62iZXv6A
z2sYuU0Zu3Q9pOss+EMYFydNQH6MU9evEL9O8V2IP5pQvm/OszXtLtj7ln60
fco+A/7AMg77NwnnC/gRF3EO3okv8uTVbidNLESW1TPuHaIrE7PMg53e4yCz
ARVHl6Gi3bb0u+IsUxxWbo9UiMDP3QMuz8JUqMBXSEc14dDO2uHY0Qxpd8A6
1uOyoAI6Wz/IKZcHWbvl0Tt4R/J7lzuKaUek5LBDfyIWSzPos3rGkl93brzY
+vs0KoasinGpisWa9RgeIa24otYRse9x7IEX2iHMWuF9Z3A8Zjex4c8BLqtu
xXjUZolVsEezMO9VXhuTA1uPDhohzufSCEe1Ur/bzjhudfXfUrHc2kcN6mpW
Z9dbKdUozwmftDZO5nPjY6vVfHeb6BO5RgVW9XPjHZ8yFQg9J1Ums8b5ygzZ
2KbVOd1KulWtOr2m68AfCa7PE2X/OpQ/ZDLMsTwwY2yxg7zKsvqUXsZlVnLr
G7mUjXZTWJ/YUbti3o5j3j6bZ3oVdKvRjfx8xlh3fGXCepbG6RQ5VeRCu+7Z
bLVmvJuyOwXN6u4yfC3a1MD+7Ez74RVrUovmezWlW7puImmsm1FsgXlkopXf
K+5d3xrYmssqcdgtsA1gxHwFW5NFppD1VD4uV7f3HpuFGe1ZqgH/86C2v6yI
HiDgGx/MeOc0k9OGvP+/CUtdH2cV6Bw7RH9WTQy1UsIMsW+l+S7/AqOFyJ21
M3TxwnrbhIYMH4f9rVeQ7p6d\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{431, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->386621683]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8421],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VariationalMethods`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->16412222],

Cell["\<\
The Lagrangian of a point particle in 2-dimensions with a central potential:\
\>", "ExampleText",
 CellID->14145],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EulerEquations", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], "m", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{
         RowBox[{"r", "'"}], "[", "t", "]"}], "2"], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"r", "[", "t", "]"}], "2"], 
        SuperscriptBox[
         RowBox[{
          RowBox[{"\[Theta]", "'"}], "[", "t", "]"}], "2"]}]}], ")"}]}], "-", 
    
    RowBox[{"V", "[", 
     RowBox[{"r", "[", "t", "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"r", "[", "t", "]"}], ",", 
     RowBox[{"\[Theta]", "[", "t", "]"}]}], "}"}], ",", "t"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->5991],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9Wc1u1DAQzuZn+7OUim4oFQi0wAUOiCNvAFyQ4MJ9VSHaAwKVvgGPACce
EHGmDxAyWXvX/TL2jONNV9ok4/F8M54f23HeLS/PPn1ZXp6fLhdvLpbfzs5P
vy9ef71om4pJlk3+ZVl2dJK1z0371P3pd9X+s6xsr7lp+mOeq45T0LWwvZvu
9hfa8sSex0bjLXOfORbQ/Sm010C/BPoh4D8B/gz494A/B/o+0MdAl4D3SD1q
l0arkEYtj4X+RwL/hcB/4Hg/1G8X6BOh/x2BL8nXAh/9jNnAR0MaFUlVTKyJ
LjztLr3DWLlj5GJwqSbKltxT9p+Dnn2lXG3aK2g/GGg3jt/6szJ39Lc0fm1/
1Gv1xfqbq0ZN3H1+HJaF2B9RO361pjsdfS2Sj0oHZX3NpqPozoFGLTrUWmUx
O1OI2IRC5Mp0+5uysnYdPRzRg1wl9aVQF84X24nWdkZwM5nF1lI0amw29Gse
7SKNFWgmaTZikpcCfG5mW8+Ew3I1QpuqzgN4+81mvRhY6QH0ORu/20ZnrtIZ
6yFuRxDix+bDoNoN8G2+jJ0ZsWset+PpxxKlJl07Yru7o5uowS2uvBFaU0eR
sNoGUGNm1ruj+ImNRmDOSq1Iaa2JtXfsPJFmLAkvfe0cUq85kxnj1elQbfRO
Fetffx3a05T0NdBfaUNGyr2NIU24+Jaq9WCqPakRTJ0R+BjoamGPleXOMWiE
K/HVj8P3vSO7NJ0FFA6WG8Ft4Eve8+HMlXZhloXw+p6tlVq0o5dm84LBjjml
ill5fDiHI0bXd0Ik4Wy/Zrg3tJSdjXRyq9l598birHqx6zzJE7nojNu09702
bM14Fomyy6KE1noONdWLsWPHc+pU/Zh1UhZKUXd3Bxuv6uqCItLNbdNmXefW
UDvHab/WEFbpqarQVxQ+O/E7DAk8h/bZdUnT60DQ77Mzh374NeiaXNBeHKG1
X3c2jN9NPjNoYf/94Ho49NuexCuVZb+ApssHVtJ65KfDNZnVvG/c746/GcyP
q96T//4BIEQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{498, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->371229768]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21839],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VariationalMethods`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->159366811],

Cell["\<\
Second and higher order derivatives may be included in the integrand. A \
Lagrangian for motion on a spring using higher order terms:\
\>", "ExampleText",
 CellID->24308],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EulerEquations", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], "m", " ", 
     RowBox[{"q", "[", "t", "]"}], 
     RowBox[{
      RowBox[{"q", "''"}], "[", "t", "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], "k", " ", 
     SuperscriptBox[
      RowBox[{"q", "[", "t", "]"}], "2"]}]}], ",", 
   RowBox[{"q", "[", "t", "]"}], ",", "t"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16565],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", "k"}], " ", 
    RowBox[{"q", "[", "t", "]"}]}], "-", 
   RowBox[{"m", " ", 
    RowBox[{
     SuperscriptBox["q", "\[Prime]\[Prime]",
      MultilineFunction->None], "[", "t", "]"}]}]}], "\[Equal]", 
  "0"}]], "Output",
 ImageSize->{131, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->23762]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19473],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VariationalMethods`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->613063760],

Cell[TextData[{
 "The integrand ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", "2"], 
    RowBox[{
     RowBox[{"\[Del]", "\[Phi]"}], ".", 
     RowBox[{"\[Del]", "\[Phi]"}]}]}], TraditionalForm]], "InlineMath"],
 " has several independent variables:"
}], "ExampleText",
 CellID->23681],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], 
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], "}"}]], 
    RowBox[{"\[Phi]", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], ".", 
   RowBox[{
    SubscriptBox["\[PartialD]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], "}"}]], 
    RowBox[{"\[Phi]", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}]}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21970],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWE1PwkAQXfoNokETEC+Gmx49q/GoJ6/GKyEmKBIN+P/4abWzuy3b16Hb
0h402oRtZ2b3zdu3H+3yOP2avyynX6+z6eRhNf2cv87Wk/uPVeJyO0J0VkKI
87FInuPkSf7oWic/9aie3KT0dXCReUTqkpfIxT0q3Swub+8y4jMR1SZgIm8y
EkKky9R8Ap9XwrPHtH8Gn5v1g5wHlVucgNcB+zIpHAaR+uiJonIDXf/0h+Gg
hqr3x5wXspl2rwSN/Kjm8Ifj4cx0dqpCpszmmbOTMB19R+UjsDFOI+Yz7fpg
B38oe7XxkF69S2SluOBqbRkLtZcR266+p3Zk4GWVrcr4f5gFP05q79xsNkJd
lFDaJtfa45iu3YHhF2Bz6LQH+Lpnvz1Lm+sixyE3J5BFO3Pv9+RrojJinVly
FVfkkYGbOZW3sHLrq/TPbxe/et8A3Jusju3m+cT592hfZ9Gfw/o6jPm35fCf
UyVO1UbYnJfaxcwWPB/YbALEr2qscwX26V5MfCGsbNphkp4v62rRlA0/jvhN
77GczTmR2YG5L6iSb81pT/PwKt5+/1L4pHpuPscuRnvnRuZuWZYG2XEs+dM1
ngvMESe2IdhYH7Ncgz2y4CNeAHHsrQ0f+SAe9seGz6uYrjc81bat5g3YeNpu
qqYNv6maiM/uN4UVgf+kyF6FsI4qKooZb8EelWDb1ER1WOwSLjY1WfzCfhKw
GvLvCdyvqa1j6Qm1G7NoUbw9sRajdxyGqQbDJ6yE1GV7vK5pRywKFYu9I55W
hDxL6aEn9R+w6HwD2gCLCw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{370, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->109316962]
}, Open  ]],

Cell["The Euler equations yield Laplace's equation:", "ExampleText",
 CellID->27053],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EulerEquations", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\[Phi]", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->22708],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    RowBox[{
     SuperscriptBox["\[Phi]", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "-", 
   RowBox[{
    SuperscriptBox["\[Phi]", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "2", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], "-", 
   RowBox[{
    SuperscriptBox["\[Phi]", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"2", ",", "0", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "\[Equal]", "0"}]], "Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->6508]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14663],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VariationalMethods`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->312502197],

Cell[TextData[{
 "The Euler equations for the integrand ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["f", "TI"], 
    StyleBox["[", "TI"], 
    RowBox[{
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["xx", "TI"]], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["x", "TI"]], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["x", "TI"]}], 
    StyleBox["]", "TI"]}], TraditionalForm]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->11771],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqn1", "=", 
  RowBox[{"EulerEquations", "[", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}], ",", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], ",", 
      RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}], ",", 
    RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5541],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXc2rJUcV73n33fcxeW/eSybzkQScF6OIShQ/MIhG0JjMyp0ggiDDGJkR
QiQzbl25cq0oZBHBVXCRRYiSjYo4gkZxJYqCf4bBgLS3q7re7f7VqTp1qqv7
dvetgbn9qrrqdNWpU9VVv1+d6q/cun/nxZdu3b97+9bZzVdufffO3dv3zl54
+ZVV1OJCUex8uiiK168Xq7/L1V/qv/n3mdX/dVCHTla/u6tEj66uO6vrQ/X1
ufq6qO8fwf1llXtxLr3Yr9MdBKZbMulO6/gq8LQq6cOQ4jKEH4LwFyG8y6TH
8KIuwUWiBjH5uOebfI9AfPXzUbcGdpstXOXfqa/U85ar4CdCyhUsFcMHlLaS
SdvtJG2PSV/1ARN89FzjO3XvaKbcaZeDsN8jCH+SKNtO3a9kkk3Ow/qKOpJL
wPvhEg7YlMtap1rZ5p+yimWzHYs6oGxa9X4jpSD0b/rKnlDrC5CL6V1yL0E+
1HloPtSOK9+JI/5yiN5a7YGjZCfNtSS7xi9SB62cOIKG58QeK9VfnDWekPex
LFQf6TZm4P2nQp5glRPbiS/HMSkHWy1Wjlwvth1gCq5fVBLsdt8BKZRdyt+v
C0aqNGyXwq7JRVFJj0gZewlkyDR2zNznWvUqpDdyyPeZZ+ZFvQUouaTlJgxT
z22GD9vaJWqKNSPnLZ70qFG8f61jC4VosLkqqNJXtw/qK6Yn5e01NaR/d2Pi
iXJBPyvsdYzLJs39647w1RLnnigJrQPDVyB8zKRvvhurVttnwqiTE0sXH4EU
1c/3o+wA02MP9b17Y+pS/fxa3VMWvg8WXedCDWJvOPbk5UqEYXxW9fMbde96
SfU5X9mq+/Qc5hByke8isn//Tv39OaKU76o7Jj2FOTxWagzA9AFzNdjAFYh/
thwPFqH0XDwBKXCtj+Mm6hXHZUyPep0ydnFBaayyv2VhzyJlMxdSj8G5l2VG
QPzpcb2k+zI9duyX614jm8+bnPjG4nNi+bYVVaHb6RRi8Z0SumLHmQG2U0g+
qnWmjr5U7VN1A61tRGNh/USMol69tXKG4l1BGp88akNbO75r1FOsUQrbgO+F
S1IOh/bIezuFTTXDGe0J1Zy2B0Q6qyctzotg/sEauuTfn7YMDjeSvaPNrCTj
RqEyONyo+lnPOm2bPGo/jZDAIUQupAnbEOWg5VKIz4KwhSVhdfNHl6of3Y6n
tV6OrTKaOZNZu10CGRzSsID8hyWNNJHIk2VZSmOjxpmqxHoN+6T1jDNCN74w
lx5HJA5xikOYvqpuPU+1j6f9+i579fMjde8FJQ4spc6FT32/Jy3OerkSUQjS
j9W9myVlu5j+A2Qqg6mQyBGJFP1U/W1iKTyoHTLoEKI3U0CHVJtY6BCHumwz
OqSnAS50SIadZHRoWHTovdK0nRsdkuMoGR3yS5CjQ7qdOHQoFFXJ6JAfHdLa
5tGhUDwlo0N+vdPWHoYOyVGOjA7F6W1z6JC2hzB0SIZlZHSoKXFK6NB61ulA
h9AmPbPbTWNDHFIRgh1NExvSrdjChoh22Agy5MJ6ZIgRUZt+kSG9fn0SJLyP
0IwvfMbcxxkkh2zE4UJfU7e+RLWOp/X6Lnv18xN1r/KwSYELcfN4LBGFC2mM
5sslZaFhuBDiQWYteUimrq6vqr9NLI8LuTyVvlC28R/cVeTCdQ4D03H4j5mX
PjHy8ql2E3tRfR7CaM/czicXZoRWmhprwnoiJrct9VYjR0fPMTMHpfAUSyfJ
sKyDpNK6IWNLJj3Oro3GMD7rvV+9q72xHbz2cA7+KaJ8ZqyVSUb8D9+XQyKI
+2xKyp7dGG/Wcyo9a/uN9X7ktIoIqwjta+RDnaZGWC854s14iPE4A876auur
YVVRvqFBeora+WijeSL0PgpHdmmLQ8xsHD7rjx/LhvKdleLl5KieYPcojXPL
+cJUeLm9Y4p7B5EzuNyCieQM0YK65w3h89wXO2GvGuyayHby0syCbPdFCnbi
iLkfxlPlVhx3K2rUhfLgXRB65riRvpihrjuIMWyzRBxqRc3Ufek5lgjvhzN8
zpXeCNuF6qvjbwu6T3B8DLJXSVi4Dju0W/isdyc61ft9PNy1+vpISfOZo9IU
zWMOqifNZ1Bs5y7RP24QT3H15ao+0hME7NX1hyHFPaYEqUtMrQRlJf6eU8M+
TfSt6TchzPWLvvX4lkqH+xNMb8TUilvv6YyItzyyU5aDXAs1wr9U6a5TqVr2
9sGSGknizqR4m4zFWj8V9UTDZaO0X6n8RlJ3zwb0XBiLZ8Op4/nPQfk2xWwr
LKuz1wXnNTEXrwvcB86VmztHdSpMuJr19+RpIvMJyZ4mUk+Tbvq+WGYeXWbP
6l3dm2eP3P8me/bQeojXKI6amYFvyO7NVyrUp2lbfKVi9cNZ71yYe22NffqS
xZwJVboscna+ZPH6CrLQ2XH+2l6H9b2Tv6Gybx0tR+5bl6pFMEfm/htyIuYv
w3k7ytZM2ZsxtTfjcYK6mvVx5v8lMrj7Sf1LRaMnyUu36kb5hIbGcbsC8P74
fEeviEtkxk+BZi2777oLYHqMv+4FIv9cq1VCGG1SMzRDPWL/22usZAq1C9ZH
S/Ker9aj2AWhOR30RL5hPQ9TSN9h3X2N71opkPmk1oySMnXfe/BNFX2nZ109
GLjer6n4uxDL7Y3knoqlfAD3qXFMUguOxf+Ziv8OPqVY87qtM/isEe2PkNMq
bxHLsf9cXU1MuMc28tHIG2+K137c8fy+ePeDwPIZdEphRhb6x/HFc/nu5ePC
cm+an8f4WJ5ascJ0qwevT6pnZYbZl96FuG8fs4/vgmGZ5g+Vxtrj2Nf8nVUd
E4bMzpuBv9hZz3K+WNsvemyHMjJz/14txfOiFiX1GhsvfhKpL473bVhVFDO6
HV/z5djIebHdNhKRmr3VVufe9dXtzZxZ1nVryN61YR7ZmQe/RMoZgnXVPYf2
uJZxhmbllhnSUBkcQ4q4As2FZx5byjGnZUw16uHzNStLNy/H6zH4C0pi3m56
/Cc9Tm6SZ+bCVF8bXs+oR64d3DbtY/Vc3zonWT0XVxfO9hEl64/jfLh0fcer
B6432nc5nR4eg7BhNzWyT+5L8MygOc/V9Oco37NSSPlWroyYny/TD1T0xwfW
1T96rvfvVbqPQS48szw11/hPRr60Vpj/AdlWVq2KWEby34Qk1xfKXF68f1Cy
jNRwVhO9XcdyzrM5hxrZyLGU77NKi8hvcV6kczmPWeqlPJd6P1M6W1286sp+
nKHsmovVlDGGWe9SvT9dGms3I6L1lhQhc9k7c90OKT2Ss55pPWv7RVYzlj2Z
q3cmx2rGeAnPWV8Nq2pZY6jn43aeo8yzmiLv363Tn7Y6mtWUewhKObPsqehq
lzBWU84C5hbyyImYBdCspsxvry++bHs9DPvw8M2tlLqVNOpxtS2TSJeGWQth
0ebnZZjGy3Y4jU/z9GafJUfzdsm/ktq/X6LrdGZk/nrUwwjOXtYYvu2xesbU
tisLx3s63ocw9+1arkTkzhJRiX6ootE7KbVm/tZzPf+k8iEbwfGR0m/R/r2j
fHK10Ai/o/I9i6kK6fdr/yWQYHg4rOuflSwjdfq8400ox6a8Jl9U2tpWfvF5
oZyxekHeLp2tmHmr3vnC7L8YqrGvl8ZOM9OXkoHK/oa0XrS9ZWZOxszN1U+w
YQ2ZUQtmhLbTu0/bSubBJHKGYFmyF14qTWoLz3zVGJkQ892V7DGXSqN6hZyI
W/KE47zi5scz4Tch0jBEYT6I5Ojp1damfd981hnCkzTD5x0p3KttFFzRZUfd
RBxQuIcfaI+uWyoPNo2y8gwQtiPHCHQ/6xLPg+SYkJBdm/6ZOnqo6e8fIuOT
WhOv91zP/6h0Chfv6XuVv/BoKKQGnPx3VbxiexJ9ZfINLHG0pPfU1cTw7E+F
6/fBrkjPzDTfgkT2aCxnZt4515ZvzTSVMzBxzsGxSXM5A/Pb1c/5mmFKbMSw
p1iS9iFe5U5Jv8OyPdoOUctj5CKGOGPytPEs2TMym6NjwuxpaHZiqK/7hbJC
28LefCPcGgZmI9Kf1WivmmK948agn/RsDT0yTJ0LGO7MRJp16O4RPPUWGI6N
ac/ZtwPn39wX3uJOcNiOVhmCfaHH6yAupdkuxVTPwov65ppHM0lYKkaz0/ia
nZRp0ZZoTtYL4lFGe16e99toxOwqikUa7ZfhXFyLxjR9Z6NW5eX4hO68BjIr
N4Ql4k6To/YM+Ev09iCaeafnev5XxSsbdzAt0hpgP/iLQDZXetSOZjLUN+/I
+TeFGLnO4vurV4r/u2f/U1cTwzMqzzTKsElGpQq8fF4i39piKqxF9fOSbpVF
3TjVn8W0kOZhkfy1zrDvjhErHQJtDtfIXPDSKvCt8BpPHhN0t/DUUZfhcK+1
DnGs3Y61/hAIzFrH0l2MMWv78a9QpWv/tf4WpWCdlvx0iP7XqVViPZfzzchx
TKnC6c9ur35+O0hZTFtcUPeV/QXuGJOeD2AkqhrodmR3dvk9+c3fSx2+8H+Q
rtbb\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{564, 169},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10004031]
}, Open  ]],

Cell["The \"textbook\" answer:", "ExampleText",
 CellID->18631],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqns2", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "]"}], "[", "f", "]"}], 
       "[", 
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}], ",", 
        RowBox[{
         RowBox[{"y", "'"}], "[", "x", "]"}], ",", 
        RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}], ",", "x", ",", "x"}],
      "]"}], "-", 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "]"}], "[", "f", "]"}], 
       "[", 
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}], ",", 
        RowBox[{
         RowBox[{"y", "'"}], "[", "x", "]"}], ",", 
        RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}], ",", "x"}], "]"}], 
    "+", 
    RowBox[{
     RowBox[{
      RowBox[{"Derivative", "[", 
       RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "]"}], "[", "f", "]"}], 
     "[", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}], ",", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], ",", 
      RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]}], "==", 
   "0"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->23572],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{565, 198},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->213501463]
}, Open  ]],

Cell["Check:", "ExampleText",
 CellID->10966],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqn1", "==", 
  RowBox[{"Expand", "[", "eqns2", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->25988],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->18170]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28168],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VariationalMethods`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->29876887],

Cell[TextData[{
 "The brachistochrone problem. The time taken for a particle to fall an arc \
length ",
 Cell[BoxData[
  StyleBox["ds", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{
   StyleBox["ds", "TI"], "/", 
   StyleBox["v", "TI"]}]], "InlineFormula"],
 ". If ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " measures the decrease in height from an initial point of release, then the \
velocity ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " satisfies:"
}], "ExampleText",
 CellID->22199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], "m", " ", 
     SuperscriptBox["v", "2"]}], "==", 
    RowBox[{"m", " ", "g", " ", "y"}]}], ",", "v"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->655],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"v", "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       SqrtBox["2"]}], " ", 
      SqrtBox["g"], " ", 
      SqrtBox["y"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", "\[Rule]", 
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox["g"], " ", 
      SqrtBox["y"]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{267, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3850]
}, Open  ]],

Cell["\<\
The equation for a curve joining two points, where a particle starting at \
rest from the higher point takes the least amount of time to reach the lower \
point:\
\>", "ExampleText",
 CellID->13444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EulerEquations", "[", 
  RowBox[{
   SqrtBox[
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{
        RowBox[{"x", "'"}], "[", "\[Theta]", "]"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{
        RowBox[{"y", "'"}], "[", "\[Theta]", "]"}], "2"]}], 
     RowBox[{"2", "g", " ", 
      RowBox[{"y", "[", "\[Theta]", "]"}]}]]], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "[", "\[Theta]", "]"}], ",", 
     RowBox[{"y", "[", "\[Theta]", "]"}]}], "}"}], ",", "\[Theta]"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->12936],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{445, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->345606337]
}, Open  ]],

Cell["\<\
It is well known that the solution to the brachistochrone problem is a \
cycloid:\
\>", "ExampleText",
 CellID->19406],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "/.", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"x", "->", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"k", 
         RowBox[{"(", 
          RowBox[{"#", "-", 
           RowBox[{"Sin", "[", "#", "]"}]}], ")"}]}], "&"}], ")"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"y", "->", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"k", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"Cos", "[", "#", "]"}]}], ")"}]}], "&"}], ")"}]}]}], 
    "\[IndentingNewLine]", "}"}]}], "//", "Simplify"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->29427],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->10313]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7523],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VariationalMethods`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->509346203],

Cell["\<\
The Lagrangian for a vibrating string yields the classical wave equation:\
\>", "ExampleText",
 CellID->32371],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EulerEquations", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], "\[Rho]", " ", 
     SuperscriptBox[
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}], "2"]}], "-", 
    RowBox[{
     FractionBox["1", "2"], "\[Tau]", " ", 
     SuperscriptBox[
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "x"}], "]"}], "2"]}]}], ",", 
   RowBox[{"u", "[", 
    RowBox[{"x", ",", "t"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "t"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23327],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", "\[Rho]"}], " ", 
    RowBox[{
     SuperscriptBox["u", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"x", ",", "t"}], "]"}]}], "+", 
   RowBox[{"\[Tau]", " ", 
    RowBox[{
     SuperscriptBox["u", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"2", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"x", ",", "t"}], "]"}]}]}], "\[Equal]", "0"}]], "Output",
 ImageSize->{212, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->17073]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8437],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["VariationalD",
   BaseStyle->"Link",
   ButtonData->"paclet:VariationalMethods/ref/VariationalD"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->19198]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23495],

Cell[TextData[ButtonBox["Variational Methods",
 BaseStyle->"Link",
 ButtonData->
  "paclet:VariationalMethods/tutorial/VariationalMethods"]], "Tutorials",
 CellID->3566]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EulerEquations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 12, 50.8408202}", "context" -> 
    "VariationalMethods`", "keywords" -> {}, "index" -> True, "label" -> 
    "Variational Methods Package Symbol", "language" -> "en", "paclet" -> 
    "VariationalMethods Package", "status" -> "None", "summary" -> 
    "EulerEquations[f, u[x ], x] returns the Euler-Lagrange differential \
equation obeyed by u[x] derived from the functional f, where f depends on the \
function u[x] and its derivatives as well as the independent variable x. \
EulerEquations[f, u[x, y, ...], {x, y, ...}] returns the Euler-Lagrange \
differential equation obeyed by u[x, y, ...]. EulerEquations[f, {u[x, y, \
...], v[x, y, ...], ...}, {x, y, ...}] returns a list of Euler-Lagrange \
differential equations obeyed by u[x, y, ...], v[x, y, ...], ....", 
    "synonyms" -> {}, "title" -> "EulerEquations", "type" -> "Symbol", "uri" -> 
    "VariationalMethods/ref/EulerEquations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5472, 178, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 47149, 1438}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1235, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1858, 60, 51, 1, 70, "ObjectName",
 CellID->9515],
Cell[1912, 63, 3523, 110, 70, "Usage",
 CellID->23542]
}, Open  ]],
Cell[CellGroupData[{
Cell[5472, 178, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[5849, 192, 148, 5, 70, "ExampleSection",
 CellID->103929230],
Cell[6000, 199, 143, 4, 70, "Input",
 CellID->173292438],
Cell[6146, 205, 266, 8, 70, "ExampleText",
 CellID->31665],
Cell[CellGroupData[{
Cell[6437, 217, 288, 10, 40, "Input",
 CellID->18908],
Cell[6728, 229, 568, 19, 58, "Output",
 CellID->20340]
}, Open  ]],
Cell[CellGroupData[{
Cell[7333, 253, 159, 5, 28, "Input",
 CellID->1360],
Cell[7495, 260, 373, 13, 36, "Output",
 CellID->2814]
}, Open  ]],
Cell[7883, 276, 121, 3, 70, "ExampleDelimiter",
 CellID->21154],
Cell[8007, 281, 143, 4, 70, "Input",
 CellID->434503559],
Cell[8153, 287, 633, 24, 70, "ExampleText",
 CellID->18012],
Cell[CellGroupData[{
Cell[8811, 315, 491, 15, 70, "Input",
 CellID->19752],
Cell[9305, 332, 533, 18, 36, "Output",
 CellID->10810198]
}, Open  ]],
Cell[9853, 353, 268, 9, 70, "ExampleText",
 CellID->8706],
Cell[CellGroupData[{
Cell[10146, 366, 167, 5, 70, "Input",
 CellID->12525],
Cell[10316, 373, 453, 8, 70, "Message",
 CellID->383974733],
Cell[10772, 383, 2694, 77, 199, "Output",
 CellID->212433079]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13515, 466, 215, 7, 70, "ExampleSection",
 CellID->3079],
Cell[13733, 475, 142, 4, 70, "Input",
 CellID->75593681],
Cell[13878, 481, 156, 4, 70, "ExampleText",
 CellID->8313],
Cell[CellGroupData[{
Cell[14059, 489, 672, 23, 70, "Input",
 CellID->28838],
Cell[14734, 514, 1151, 23, 70, "Output",
 Evaluatable->False,
 CellID->386621683]
}, Open  ]],
Cell[15900, 540, 120, 3, 70, "ExampleDelimiter",
 CellID->8421],
Cell[16023, 545, 142, 4, 70, "Input",
 CellID->16412222],
Cell[16168, 551, 123, 3, 70, "ExampleText",
 CellID->14145],
Cell[CellGroupData[{
Cell[16316, 558, 724, 26, 70, "Input",
 CellID->5991],
Cell[17043, 586, 1261, 25, 70, "Output",
 Evaluatable->False,
 CellID->371229768]
}, Open  ]],
Cell[18319, 614, 121, 3, 70, "ExampleDelimiter",
 CellID->21839],
Cell[18443, 619, 143, 4, 70, "Input",
 CellID->159366811],
Cell[18589, 625, 180, 4, 70, "ExampleText",
 CellID->24308],
Cell[CellGroupData[{
Cell[18794, 633, 471, 16, 70, "Input",
 CellID->16565],
Cell[19268, 651, 411, 15, 36, "Output",
 CellID->23762]
}, Open  ]],
Cell[19694, 669, 121, 3, 70, "ExampleDelimiter",
 CellID->19473],
Cell[19818, 674, 143, 4, 70, "Input",
 CellID->613063760],
Cell[19964, 680, 301, 11, 70, "ExampleText",
 CellID->23681],
Cell[CellGroupData[{
Cell[20290, 695, 557, 19, 70, "Input",
 CellID->21970],
Cell[20850, 716, 1029, 21, 70, "Output",
 Evaluatable->False,
 CellID->109316962]
}, Open  ]],
Cell[21894, 740, 84, 1, 70, "ExampleText",
 CellID->27053],
Cell[CellGroupData[{
Cell[22003, 745, 267, 8, 70, "Input",
 CellID->22708],
Cell[22273, 755, 909, 32, 36, "Output",
 CellID->6508]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23231, 793, 223, 7, 70, "ExampleSection",
 CellID->14663],
Cell[23457, 802, 143, 4, 70, "Input",
 CellID->312502197],
Cell[23603, 808, 489, 19, 70, "ExampleText",
 CellID->11771],
Cell[CellGroupData[{
Cell[24117, 831, 414, 13, 70, "Input",
 CellID->5541],
Cell[24534, 846, 4791, 83, 70, "Output",
 Evaluatable->False,
 CellID->10004031]
}, Open  ]],
Cell[29340, 932, 63, 1, 70, "ExampleText",
 CellID->18631],
Cell[CellGroupData[{
Cell[29428, 937, 1366, 45, 70, "Input",
 CellID->23572],
Cell[30797, 984, 4832, 83, 70, "Output",
 Evaluatable->False,
 CellID->213501463]
}, Open  ]],
Cell[35644, 1070, 45, 1, 70, "ExampleText",
 CellID->10966],
Cell[CellGroupData[{
Cell[35714, 1075, 129, 4, 70, "Input",
 CellID->25988],
Cell[35846, 1081, 157, 5, 36, "Output",
 CellID->18170]
}, Open  ]],
Cell[36018, 1089, 121, 3, 70, "ExampleDelimiter",
 CellID->28168],
Cell[36142, 1094, 142, 4, 70, "Input",
 CellID->29876887],
Cell[36287, 1100, 538, 19, 70, "ExampleText",
 CellID->22199],
Cell[CellGroupData[{
Cell[36850, 1123, 259, 9, 70, "Input",
 CellID->655],
Cell[37112, 1134, 500, 20, 43, "Output",
 CellID->3850]
}, Open  ]],
Cell[37627, 1157, 208, 5, 70, "ExampleText",
 CellID->13444],
Cell[CellGroupData[{
Cell[37860, 1166, 590, 20, 70, "Input",
 CellID->12936],
Cell[38453, 1188, 3210, 57, 70, "Output",
 Evaluatable->False,
 CellID->345606337]
}, Open  ]],
Cell[41678, 1248, 128, 4, 70, "ExampleText",
 CellID->19406],
Cell[CellGroupData[{
Cell[41831, 1256, 651, 22, 70, "Input",
 CellID->29427],
Cell[42485, 1280, 205, 7, 36, "Output",
 CellID->10313]
}, Open  ]],
Cell[42705, 1290, 120, 3, 70, "ExampleDelimiter",
 CellID->7523],
Cell[42828, 1295, 143, 4, 70, "Input",
 CellID->509346203],
Cell[42974, 1301, 120, 3, 70, "ExampleText",
 CellID->32371],
Cell[CellGroupData[{
Cell[43119, 1308, 686, 23, 70, "Input",
 CellID->23327],
Cell[43808, 1333, 695, 26, 36, "Output",
 CellID->17073]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[44564, 1366, 310, 9, 70, "SeeAlsoSection",
 CellID->8437],
Cell[44877, 1377, 223, 6, 70, "SeeAlso",
 CellID->19198]
}, Open  ]],
Cell[CellGroupData[{
Cell[45137, 1388, 314, 9, 70, "TutorialsSection",
 CellID->23495],
Cell[45454, 1399, 169, 4, 70, "Tutorials",
 CellID->3566]
}, Open  ]],
Cell[45638, 1406, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

