(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8640,        319]
NotebookOptionsPosition[      6171,        237]
NotebookOutlinePosition[      7480,        274]
CellTagsIndexPosition[      7396,        269]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VARIATIONAL METHODS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Variational Methods" :> 
          Documentation`HelpLookup[
           "paclet:VariationalMethods/tutorial/VariationalMethods"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Variational Methods\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FirstIntegrals" :> 
          Documentation`HelpLookup[
           "paclet:VariationalMethods/ref/FirstIntegrals"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"FirstIntegrals\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FirstIntegral", "ObjectName",
 CellID->28099],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FirstIntegral", "[", 
       StyleBox["u", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a first integral associated with the \
variable ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " in the output of the function ",
     Cell[BoxData[
      ButtonBox["FirstIntegrals",
       BaseStyle->"Link",
       ButtonData->"paclet:VariationalMethods/ref/FirstIntegrals"]], 
      "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16519]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->36279176],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VariationalMethods`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->24845025],

Cell["\<\
FirstIntegral[x] appears in the output for this variational problem:\
\>", "ExampleText",
 CellID->473554596],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], 
    SqrtBox[
     RowBox[{"1", "+", 
      SuperscriptBox[
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}], "2"]}]]}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21364],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FirstIntegrals", "[", 
  RowBox[{"f", ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->19714],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"FirstIntegral", "[", "x", "]"}], "\[Rule]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"y", "[", "x", "]"}], 
     SqrtBox[
      RowBox[{"1", "+", 
       SuperscriptBox[
        RowBox[{
         SuperscriptBox["y", "\[Prime]",
          MultilineFunction->None], "[", "x", "]"}], "2"]}]]]}]}], 
  "}"}]], "Output",
 ImageSize->{234, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->36896553]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FirstIntegral", "[", "x", "]"}], "/.", "%"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->774280455],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"y", "[", "x", "]"}], 
   SqrtBox[
    RowBox[{"1", "+", 
     SuperscriptBox[
      RowBox[{
       SuperscriptBox["y", "\[Prime]",
        MultilineFunction->None], "[", "x", "]"}], "2"]}]]]}]], "Output",
 ImageSize->{92, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->25770741]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14753],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["FirstIntegrals",
   BaseStyle->"Link",
   ButtonData->"paclet:VariationalMethods/ref/FirstIntegrals"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->8257]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8596],

Cell[TextData[ButtonBox["Variational Methods",
 BaseStyle->"Link",
 ButtonData->
  "paclet:VariationalMethods/tutorial/VariationalMethods"]], "Tutorials",
 CellID->5715]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FirstIntegral - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 12, 51.3252076}", "context" -> 
    "VariationalMethods`", "keywords" -> {}, "index" -> True, "label" -> 
    "Variational Methods Package Symbol", "language" -> "en", "paclet" -> 
    "VariationalMethods Package", "status" -> "None", "summary" -> 
    "FirstIntegral[u] represents a first integral associated with the \
variable u in the output of the function FirstIntegrals.", "synonyms" -> {}, 
    "title" -> "FirstIntegral", "type" -> "Symbol", "uri" -> 
    "VariationalMethods/ref/FirstIntegral"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2669, 91, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7262, 262}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1249, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1872, 61, 51, 1, 70, "ObjectName",
 CellID->28099],
Cell[1926, 64, 706, 22, 70, "Usage",
 CellID->16519]
}, Open  ]],
Cell[CellGroupData[{
Cell[2669, 91, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3046, 105, 147, 5, 70, "ExampleSection",
 CellID->36279176],
Cell[3196, 112, 142, 4, 70, "Input",
 CellID->24845025],
Cell[3341, 118, 119, 3, 70, "ExampleText",
 CellID->473554596],
Cell[3463, 123, 280, 11, 70, "Input",
 CellID->21364],
Cell[CellGroupData[{
Cell[3768, 138, 168, 5, 28, "Input",
 CellID->19714],
Cell[3939, 145, 504, 18, 62, "Output",
 CellID->36896553]
}, Open  ]],
Cell[CellGroupData[{
Cell[4480, 168, 133, 4, 28, "Input",
 CellID->774280455],
Cell[4616, 174, 390, 14, 62, "Output",
 CellID->25770741]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5067, 195, 311, 9, 70, "SeeAlsoSection",
 CellID->14753],
Cell[5381, 206, 226, 6, 70, "SeeAlso",
 CellID->8257]
}, Open  ]],
Cell[CellGroupData[{
Cell[5644, 217, 313, 9, 70, "TutorialsSection",
 CellID->8596],
Cell[5960, 228, 169, 4, 70, "Tutorials",
 CellID->5715]
}, Open  ]],
Cell[6144, 235, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

