(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20216,        695]
NotebookOptionsPosition[     16211,        578]
NotebookOutlinePosition[     18390,        627]
CellTagsIndexPosition[     18305,        622]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VARIATIONAL METHODS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Variational Methods" :> 
          Documentation`HelpLookup[
           "paclet:VariationalMethods/tutorial/VariationalMethods"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Variational Methods\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"VariationalBound" :> 
          Documentation`HelpLookup[
           "paclet:VariationalMethods/ref/VariationalBound"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"VariationalBound\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NVariationalBound", "ObjectName",
 CellID->20523],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NVariationalBound", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{
         StyleBox["u", "TI"], "[", 
         RowBox[{
          RowBox[{
           StyleBox["x", "TI"], 
           RowBox[{"]", ","}], 
           RowBox[{"{", 
            RowBox[{
             StyleBox["x", "TI"], ",", 
             SubscriptBox[
              StyleBox["x", "TI"], 
              StyleBox["min", "TI"]], ",", 
             SubscriptBox[
              StyleBox["x", "TI"], 
              StyleBox["max", "TI"]]}], "}"}]}], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["t", "TI"]], ",", 
          RowBox[{"{", 
           RowBox[{
            StyleBox["a", "TI"], ",", 
            SubscriptBox[
             StyleBox["a", "TI"], 
             StyleBox["0", "TR"]]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            StyleBox["b", "TI"], ",", 
            SubscriptBox[
             StyleBox["b", "TI"], 
             StyleBox["0", "TR"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TI"]}], "]"}]}]}]], "InlineFormula"],
     "\[LineSeparator]numerically searches for values of the parameters ",
     Cell[BoxData[
      RowBox[{
       StyleBox["a", "TI"], ",", 
       StyleBox["b", "TI"], ",", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
     " of a trial function ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["t", "TI"]]], "InlineFormula"],
     ", starting from ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        StyleBox["a", "TI"], "=", 
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["0", "TR"]]}], ",", 
       RowBox[{
        StyleBox["b", "TI"], "=", 
        SubscriptBox[
         StyleBox["b", "TI"], 
         StyleBox["0", "TR"]]}], ",", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
     ", that extremize the functional ",
     Cell[BoxData[
      RowBox[{
       SubsuperscriptBox["\[Integral]", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["min", "TI"]], 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["max", "TI"]]], 
       RowBox[{
        UnderscriptBox[
         StyleBox["f", "TI"], "\[InvisibleSpace]"], 
        RowBox[{"\[DifferentialD]", 
         StyleBox["x", "TI"]}]}]}]], "InlineFormula"],
     ", where the integrand ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " is a function of ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     ", its derivatives, and ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NVariationalBound", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{
         StyleBox["u", "TI"], "[", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            StyleBox["x", "TI"], ",", 
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["min", "TI"]], ",", 
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["max", "TI"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        SubscriptBox[
         StyleBox["u", "TI"], 
         StyleBox["t", "TI"]], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["a", "TI"], ",", 
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["0", "TR"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["b", "TI"], ",", 
          SubscriptBox[
           StyleBox["b", "TI"], 
           StyleBox["0", "TR"]]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]searches for values of the parameters of a trial \
function of two or more variables."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NVariationalBound", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["f", "TI"], ",", 
          StyleBox["g", "TI"]}], "}"}], ",", 
        RowBox[{
         StyleBox["u", "TI"], "[", 
         StyleBox["x", "TI"], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        SubscriptBox[
         StyleBox["u", "TI"], 
         StyleBox["t", "TI"]], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["a", "TI"], ",", 
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["0", "TR"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["b", "TI"], ",", 
          SubscriptBox[
           StyleBox["b", "TI"], 
           StyleBox["0", "TR"]]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]searches for values of the parameters that extremize \
the ratio ",
     Cell[BoxData[
      RowBox[{
       SubsuperscriptBox["\[Integral]", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["min", "TI"]], 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["max", "TI"]]], 
       RowBox[{
        UnderscriptBox[
         StyleBox["f", "TI"], "\[InvisibleSpace]"], 
        RowBox[{
         RowBox[{"\[DifferentialD]", 
          StyleBox["x", "TI"]}], 
         StyleBox["/", "TI"], 
         RowBox[{
          SubsuperscriptBox["\[Integral]", 
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["min", "TI"]], 
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["max", "TI"]]], 
          RowBox[{
           UnderscriptBox[
            StyleBox["g", "TI"], "\[InvisibleSpace]"], 
           RowBox[{"\[DifferentialD]", 
            StyleBox["x", "TI"]}]}]}]}]}]}]], "InlineFormula"],
     ", where the integrands ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     " are functions of ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     ", its derivatives, and ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->26539]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["NVariationalBound"], "InlineFormula"],
 " returns the extremal value of the functional as well as the optimal \
parameter values."
}], "Notes",
 CellID->20609],

Cell[TextData[{
 Cell[BoxData["NVariationalBound"], "InlineFormula"],
 " uses ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " to search for values of the parameters that extremize the functional. "
}], "Notes",
 CellID->11827],

Cell[TextData[{
 "A parameter specification of ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    SubscriptBox[
     StyleBox["a", "TI"], 
     StyleBox["0", "TR"]], ",", 
    SubscriptBox[
     StyleBox["a", "TI"], 
     StyleBox["1", "TR"]]}], "}"}]], "InlineFormula"],
 " searches for an extremum using ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["a", "TI"], 
   StyleBox["0", "TR"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["a", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 " as the first two values of ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 ", avoiding the use of derivatives."
}], "Notes",
 CellID->6637],

Cell[TextData[{
 "A parameter specification of ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    SubscriptBox[
     StyleBox["a", "TI"], 
     StyleBox["0", "TR"]], ",", 
    SubscriptBox[
     StyleBox["a", "TI"], 
     StyleBox["min", "TI"]], ",", 
    SubscriptBox[
     StyleBox["a", "TI"], 
     StyleBox["max", "TI"]]}], "}"}]], "InlineFormula"],
 " searches for an extremum, stopping the search if ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " ever gets outside the range ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["a", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["a", "TI"], 
   StyleBox["max", "TI"]]], "InlineFormula"],
 "."
}], "Notes",
 CellID->8186]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->284788811],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->310742209],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VariationalMethods`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->458337469],

Cell["\<\
Eigenvalue problem for a third order ordinary differential equation:\
\>", "ExampleText",
 CellID->465509604],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"eqn", " ", "=", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "'''"}], "[", "x", "]"}], "+", 
      RowBox[{"7", "  ", 
       RowBox[{
        RowBox[{"y", "''"}], "[", "x", "]"}]}], "+", 
      RowBox[{"Pi", "  ", 
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}]}]}], " ", "\[Equal]", 
     RowBox[{"\[Lambda]", " ", 
      RowBox[{"y", "[", "x", "]"}]}]}]}], ";"}], " "}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24687720],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", " ", "=", " ", 
  RowBox[{"NVariationalBound", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], " ", 
       RowBox[{"eqn", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ",", " ", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "^", "2"}]}], "}"}], ",", " ", 
    RowBox[{"y", "[", "x", "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}], ",", " ", 
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{"c", " ", "x"}], ")"}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"c", ",", " ", "1"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->496150263],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.3646889927896787`"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", "\[Rule]", 
     RowBox[{"-", "0.23637198511714672`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{194, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->17978148]
}, Open  ]],

Cell["The solution fits the equation well in this case:", "ExampleText",
 CellID->612009702],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "[", "x_", "]"}], " ", "=", " ", 
  RowBox[{
   RowBox[{"E", "^", 
    RowBox[{"(", 
     RowBox[{"c", " ", "x"}], ")"}]}], "/.", 
   RowBox[{"sol", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->340536490],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{
   RowBox[{"-", "0.23637198511714672`"}], " ", "x"}]]], "Output",
 ImageSize->{64, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->538460903]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"eqn", "[", 
     RowBox[{"[", "1", "]"}], "]"}], " ", "-", 
    RowBox[{"eqn", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "/.", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]", " ", "\[Rule]", " ", 
     RowBox[{"sol", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], "}"}]}], "//", "Chop"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->460029263],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->53870089]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", "y", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->275555294]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14899],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["VariationalBound",
   BaseStyle->"Link",
   ButtonData->"paclet:VariationalMethods/ref/VariationalBound"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->22514]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27416],

Cell[TextData[ButtonBox["Variational Methods",
 BaseStyle->"Link",
 ButtonData->
  "paclet:VariationalMethods/tutorial/VariationalMethods"]], "Tutorials",
 CellID->1827]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NVariationalBound - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 12, 51.8252204}", "context" -> 
    "VariationalMethods`", "keywords" -> {}, "index" -> True, "label" -> 
    "Variational Methods Package Symbol", "language" -> "en", "paclet" -> 
    "VariationalMethods Package", "status" -> "None", "summary" -> 
    "NVariationalBound[f, u[x ], {x, x_min, x_max}, u_t, {a, a_0}, {b, b_0}, \
...] numerically searches for values of the parameters a, b, ... of a trial \
function u_t, starting from a = a_0, b = b_0, ..., that extremize the \
functional SubsuperscriptBox[\\[Integral], x_min, x_max] UnderscriptBox[f, ] \
\\[DifferentialD]x, where the integrand f is a function of u, its \
derivatives, and x. NVariationalBound[f, u[x, y, ...], {{x, x_min, x_max}, \
...}, u_t, {a, a_0}, {b, b_0}, ...] searches for values of the parameters of \
a trial function of two or more variables. NVariationalBound[{f, g}, u[x], \
{x, x_min, x_max}, u_t, {a, a_0}, {b, b_0}, ...] searches for values of the \
parameters that extremize the ratio SubsuperscriptBox[\\[Integral], x_min, \
x_max] UnderscriptBox[f, ] \\[DifferentialD]x/ \
SubsuperscriptBox[\\[Integral], x_min, x_max] UnderscriptBox[g, ] \
\\[DifferentialD]x, where the integrands f and g are functions of u, its \
derivatives, and x.", "synonyms" -> {}, "title" -> "NVariationalBound", 
    "type" -> "Symbol", "uri" -> 
    "VariationalMethods/ref/NVariationalBound"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11295, 384, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->284788811]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18161, 615}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1255, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1878, 61, 55, 1, 70, "ObjectName",
 CellID->20523],
Cell[1936, 64, 6820, 216, 70, "Usage",
 CellID->26539]
}, Open  ]],
Cell[CellGroupData[{
Cell[8793, 285, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9271, 302, 190, 5, 70, "Notes",
 CellID->20609],
Cell[9464, 309, 309, 9, 70, "Notes",
 CellID->11827],
Cell[9776, 320, 704, 27, 70, "Notes",
 CellID->6637],
Cell[10483, 349, 775, 30, 70, "Notes",
 CellID->8186]
}, Closed]],
Cell[CellGroupData[{
Cell[11295, 384, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->284788811],
Cell[CellGroupData[{
Cell[11680, 398, 148, 5, 70, "ExampleSection",
 CellID->310742209],
Cell[11831, 405, 143, 4, 70, "Input",
 CellID->458337469],
Cell[11977, 411, 119, 3, 70, "ExampleText",
 CellID->465509604],
Cell[12099, 416, 508, 17, 70, "Input",
 CellID->24687720],
Cell[CellGroupData[{
Cell[12632, 437, 694, 21, 47, "Input",
 CellID->496150263],
Cell[13329, 460, 335, 11, 36, "Output",
 CellID->17978148]
}, Open  ]],
Cell[13679, 474, 92, 1, 70, "ExampleText",
 CellID->612009702],
Cell[CellGroupData[{
Cell[13796, 479, 286, 10, 70, "Input",
 CellID->340536490],
Cell[14085, 491, 256, 8, 36, "Output",
 CellID->538460903]
}, Open  ]],
Cell[CellGroupData[{
Cell[14378, 504, 398, 13, 70, "Input",
 CellID->460029263],
Cell[14779, 519, 157, 5, 36, "Output",
 CellID->53870089]
}, Open  ]],
Cell[14951, 527, 101, 3, 70, "Input",
 CellID->275555294]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15101, 536, 311, 9, 70, "SeeAlsoSection",
 CellID->14899],
Cell[15415, 547, 231, 6, 70, "SeeAlso",
 CellID->22514]
}, Open  ]],
Cell[CellGroupData[{
Cell[15683, 558, 314, 9, 70, "TutorialsSection",
 CellID->27416],
Cell[16000, 569, 169, 4, 70, "Tutorials",
 CellID->1827]
}, Open  ]],
Cell[16184, 576, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

