(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13596,        471]
NotebookOptionsPosition[     10513,        379]
NotebookOutlinePosition[     12304,        422]
CellTagsIndexPosition[     12219,        417]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VARIATIONAL METHODS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Variational Methods" :> 
          Documentation`HelpLookup[
           "paclet:VariationalMethods/tutorial/VariationalMethods"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Variational Methods\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EulerEquations" :> 
          Documentation`HelpLookup[
           "paclet:VariationalMethods/ref/EulerEquations"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"EulerEquations\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["VariationalD", "ObjectName",
 CellID->22972],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"VariationalD", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{
         StyleBox["u", "TI"], "[", 
         RowBox[{
          StyleBox["x", "TI"], 
          RowBox[{"]", ","}], 
          StyleBox["x", "TI"]}], "]"}]}]}]], "InlineFormula"],
     "\[LineSeparator]returns the variational derivative of the integral ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Integral]", 
        RowBox[{
         StyleBox["f", "TI"], 
         RowBox[{"\[DifferentialD]", 
          StyleBox["x", "TI"]}]}]}], TraditionalForm]], "InlineFormula"],
     " with respect to ",
     Cell[BoxData[
      RowBox[{
       StyleBox["u", "TI"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     ", where the integrand ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " is a function of ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     ", its derivatives, and ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"VariationalD", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{
         StyleBox["u", "TI"], "[", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns the variational derivative of the multiple \
integral ",
     Cell[BoxData[
      RowBox[{"\[Integral]", 
       RowBox[{
        StyleBox["f", "TI"], 
        RowBox[{"\[DifferentialD]", 
         StyleBox["x", "TI"]}], 
        RowBox[{"\[DifferentialD]", 
         StyleBox["y", "TI"]}], " ", 
        StyleBox["\[Ellipsis]", "TR"]}]}]], "InlineFormula"],
     " with respect to ",
     Cell[BoxData[
      RowBox[{
       StyleBox["u", "TI"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " is a function of ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     ", its derivatives and the coordinates ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], ",", 
       StyleBox["y", "TI"], ",", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"VariationalD", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           StyleBox["u", "TI"], "[", 
           RowBox[{
            StyleBox["x", "TI"], ",", 
            StyleBox["y", "TI"], ",", 
            StyleBox["\[Ellipsis]", "TR"]}], "]"}], ",", 
          RowBox[{
           StyleBox["v", "TI"], "[", 
           RowBox[{
            StyleBox["x", "TI"], ",", 
            StyleBox["y", "TI"], ",", 
            StyleBox["\[Ellipsis]", "TR"]}], "]"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a list of variational derivatives with respect \
to ",
     Cell[BoxData[
      RowBox[{
       StyleBox["u", "TI"], ",", 
       StyleBox["v", "TI"], ",", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->24348]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->241701699],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VariationalMethods`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->373868785],

Cell[TextData[{
 "Variational derivative for the arc length ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Integral]", 
    RowBox[{"\[DifferentialD]", "s"}]}], TraditionalForm]], "InlineMath"],
 " of a plane curve:"
}], "ExampleText",
 CellID->31665],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VariationalD", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"1", "+", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], "^", "2"}]}], "]"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18908],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["y", "\[Prime]\[Prime]",
     MultilineFunction->None], "[", "x", "]"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["y", "\[Prime]",
         MultilineFunction->None], "[", "x", "]"}], "2"]}], ")"}], 
    RowBox[{"3", "/", "2"}]]]}]], "Output",
 ImageSize->{102, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->66583697]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21154],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VariationalMethods`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->504284300],

Cell["\<\
Variational derivative for the Dirichlet integral in two variables:\
\>", "ExampleText",
 CellID->18012],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VariationalD", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"u", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}], "^", "2"}], "+", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"u", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}], "^", "2"}]}], ",", 
   " ", 
   RowBox[{"u", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19752],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     SuperscriptBox["u", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"x", ",", "y"}], "]"}], "+", 
    RowBox[{
     SuperscriptBox["u", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"2", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"x", ",", "y"}], "]"}]}], ")"}]}]], "Output",
 ImageSize->{192, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->375248277]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18333],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["EulerEquations",
   BaseStyle->"Link",
   ButtonData->"paclet:VariationalMethods/ref/EulerEquations"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->27437]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16453],

Cell[TextData[ButtonBox["Variational Methods",
 BaseStyle->"Link",
 ButtonData->
  "paclet:VariationalMethods/tutorial/VariationalMethods"]], "Tutorials",
 CellID->9503]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"VariationalD - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 12, 52.3096078}", "context" -> 
    "VariationalMethods`", "keywords" -> {}, "index" -> True, "label" -> 
    "Variational Methods Package Symbol", "language" -> "en", "paclet" -> 
    "VariationalMethods Package", "status" -> "None", "summary" -> 
    "VariationalD[f, u[x ], x] returns the variational derivative of the \
integral \\[Integral]f \\[DifferentialD]x with respect to u[x], where the \
integrand f is a function of u, its derivatives, and x. VariationalD[f, u[x, \
y, ...], {x, y, ...}] returns the variational derivative of the multiple \
integral \\[Integral]f \\[DifferentialD]x \\[DifferentialD]y ... with respect \
to u[x, y, ...], where f is a function of u, its derivatives and the \
coordinates x, y, .... VariationalD[f, {u[x, y, ...], v[x, y, ...], ...}, {x, \
y, ...}] gives a list of variational derivatives with respect to u, v, ....", 
    "synonyms" -> {}, "title" -> "VariationalD", "type" -> "Symbol", "uri" -> 
    "VariationalMethods/ref/VariationalD"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5913, 193, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12084, 410}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1249, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1872, 61, 50, 1, 70, "ObjectName",
 CellID->22972],
Cell[1925, 64, 3951, 124, 70, "Usage",
 CellID->24348]
}, Open  ]],
Cell[CellGroupData[{
Cell[5913, 193, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[6290, 207, 148, 5, 70, "ExampleSection",
 CellID->241701699],
Cell[6441, 214, 143, 4, 70, "Input",
 CellID->373868785],
Cell[6587, 220, 247, 8, 70, "ExampleText",
 CellID->31665],
Cell[CellGroupData[{
Cell[6859, 232, 304, 10, 28, "Input",
 CellID->18908],
Cell[7166, 244, 529, 18, 58, "Output",
 CellID->66583697]
}, Open  ]],
Cell[7710, 265, 121, 3, 70, "ExampleDelimiter",
 CellID->21154],
Cell[7834, 270, 143, 4, 70, "Input",
 CellID->504284300],
Cell[7980, 276, 114, 3, 70, "ExampleText",
 CellID->18012],
Cell[CellGroupData[{
Cell[8119, 283, 568, 20, 70, "Input",
 CellID->19752],
Cell[8690, 305, 656, 25, 39, "Output",
 CellID->375248277]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9407, 337, 311, 9, 70, "SeeAlsoSection",
 CellID->18333],
Cell[9721, 348, 227, 6, 70, "SeeAlso",
 CellID->27437]
}, Open  ]],
Cell[CellGroupData[{
Cell[9985, 359, 314, 9, 70, "TutorialsSection",
 CellID->16453],
Cell[10302, 370, 169, 4, 70, "Tutorials",
 CellID->9503]
}, Open  ]],
Cell[10486, 377, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

