(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13264,        450]
NotebookOptionsPosition[      9594,        341]
NotebookOutlinePosition[     10983,        375]
CellTagsIndexPosition[     10940,        372]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Vector Analysis Package", "GuideTitle",
 CellID->942062912],

Cell["\<\
Frequently, physical systems exhibit special symmetries or structures that \
make a particular coordinate system especially useful. In a mathematically \
elegant solution to problems related to these systems, often the main step is \
choosing the correct coordinates. A variety of tools for doing calculus in \
various three\[Hyphen]dimensional coordinate systems are provided in this \
package. \
\>", "GuideAbstract",
 CellID->2001916300],

Cell[TextData[{
 Cell[TextData[ButtonBox["SetCoordinates",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorAnalysis/ref/SetCoordinates"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " set the default coordinate system"
}], "GuideText",
 CellID->1991412910],

Cell[CellGroupData[{

Cell["\t", "GuideMoreAboutDelimiter",
 CellID->887840185],

Cell[TextData[{
 Cell[TextData[ButtonBox["CoordinateSystem",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorAnalysis/ref/CoordinateSystem"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " default coordinate system"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["Coordinates",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorAnalysis/ref/Coordinates"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " default variables in the default coordinate system"
}], "GuideText",
 CellID->1463276848],

Cell["\t", "GuideDelimiterSubsection",
 CellID->311258892]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Coordinate Systems \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:VectorAnalysis/guide/CoordinateSystems"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->1014509246],

Cell[TextData[{
 Cell[TextData[ButtonBox["Bipolar",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorAnalysis/ref/Bipolar"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Bispherical",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorAnalysis/ref/Bispherical"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Cartesian",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorAnalysis/ref/Cartesian"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorAnalysis/guide/CoordinateSystems"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->986592853],

Cell["\t", "GuideDelimiterSubsection",
 CellID->1636699344]
}, Open  ]],

Cell[CellGroupData[{

Cell["Parameters", "GuideFunctionsSubsection",
 CellID->1984223989],

Cell[TextData[{
 Cell[TextData[ButtonBox["CoordinateRanges",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorAnalysis/ref/CoordinateRanges"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " interval over which the coordinate variables range"
}], "GuideText",
 CellID->1344237236],

Cell[TextData[{
 Cell[TextData[ButtonBox["Parameters",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorAnalysis/ref/Parameters"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " default parameters of the coordinate system"
}], "GuideText",
 CellID->1067259012],

Cell[TextData[{
 Cell[TextData[ButtonBox["ParameterRanges",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorAnalysis/ref/ParameterRanges"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " range of values of the parameters of the coordinate system"
}], "GuideText",
 CellID->1638794940]
}, Open  ]],

Cell[CellGroupData[{

Cell["Coordinate Transformations", "GuideFunctionsSubsection",
 CellID->579028860],

Cell[TextData[{
 Cell[TextData[ButtonBox["CoordinatesToCartesian",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorAnalysis/ref/CoordinatesToCartesian"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " transform coordinates to Cartesian coordinates"
}], "GuideText",
 CellID->1333569398],

Cell[TextData[{
 Cell[TextData[ButtonBox["CoordinatesFromCartesian",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorAnalysis/ref/CoordinatesFromCartesian"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 StyleBox["transform coordinates from Cartesian coordinates",
  GridBoxOptions->{
  GridBoxDividers->{
   "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
    "RowsIndexed" -> {}},
  GridBoxSpacings->{"Columns" -> {
      Offset[0.28], {
       Offset[0.56]}, 
      Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
      Offset[0.2], {
       Offset[0.16]}, 
      Offset[0.2]}, "RowsIndexed" -> {}}}]
}], "GuideText",
 CellID->14048447]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vector Calculus", "GuideFunctionsSubsection",
 CellID->1489645463],

Cell[TextData[{
 Cell[TextData[ButtonBox["Div",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorAnalysis/ref/Div"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Curl",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorAnalysis/ref/Curl"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Grad",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorAnalysis/ref/Grad"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Laplacian",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorAnalysis/ref/Laplacian"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Biharmonic",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorAnalysis/ref/Biharmonic"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->1191819428],

Cell[TextData[{
 Cell[TextData[ButtonBox["ArcLengthFactor",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorAnalysis/ref/ArcLengthFactor"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " derivative of the arc length along parameterized curve  "
}], "GuideText",
 CellID->1309978304],

Cell[TextData[{
 Cell[TextData[ButtonBox["JacobianMatrix",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorAnalysis/ref/JacobianMatrix"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " derivative matrix of the coordinate transformation "
}], "GuideText",
 CellID->803006284],

Cell[TextData[{
 Cell[TextData[ButtonBox["JacobianDeterminant",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorAnalysis/ref/JacobianDeterminant"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " determinant of the Jacobian matrix"
}], "GuideText",
 CellID->1339377440],

Cell[TextData[{
 Cell[TextData[ButtonBox["ScaleFactors",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorAnalysis/ref/ScaleFactors"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list the scale factors"
}], "GuideText",
 CellID->993046226],

Cell[TextData[{
 Cell[TextData[ButtonBox["DotProduct",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorAnalysis/ref/DotProduct"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CrossProduct",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorAnalysis/ref/CrossProduct"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ScalarTripleProduct",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorAnalysis/ref/ScalarTripleProduct"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->1106939915]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Packages for Symbolic Mathematics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PackagesForSymbolicMathematics"]], "GuideTutorial",
 CellID->164417897],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "GuideTutorial",
 CellID->219558142]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Calculus",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Calculus"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Variational Methods Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:VariationalMethods/guide/VariationalMethodsPackage"]], \
"GuideMoreAbout",
 CellID->623399252]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Vector Analysis Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 12, 58.5910186}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Guide", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "Frequently, physical systems exhibit special symmetries or structures \
that make a particular coordinate system especially useful. In a \
mathematically elegant solution to problems related to these systems, often \
the main step is choosing the correct coordinates. A variety of tools for \
doing calculus in various three-dimensional coordinate systems are provided \
in this package. ", "synonyms" -> {}, "title" -> "Vector Analysis Package", 
    "type" -> "Guide", "uri" -> 
    "VectorAnalysis/guide/VectorAnalysisPackage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 65, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[687, 28, 450, 8, 70, "GuideAbstract",
 CellID->2001916300],
Cell[1140, 38, 288, 9, 70, "GuideText",
 CellID->1991412910],
Cell[CellGroupData[{
Cell[1453, 51, 57, 1, 70, "GuideMoreAboutDelimiter",
 CellID->887840185],
Cell[1513, 54, 283, 9, 70, "GuideText",
 CellID->203374175],
Cell[1799, 65, 299, 9, 70, "GuideText",
 CellID->1463276848],
Cell[2101, 76, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->311258892]
}, Open  ]],
Cell[CellGroupData[{
Cell[2196, 82, 239, 5, 70, "GuideFunctionsSubsection",
 CellID->1014509246],
Cell[2438, 89, 890, 25, 70, "InlineGuideFunctionListing",
 CellID->986592853],
Cell[3331, 116, 59, 1, 70, "GuideDelimiterSubsection",
 CellID->1636699344]
}, Open  ]],
Cell[CellGroupData[{
Cell[3427, 122, 67, 1, 70, "GuideFunctionsSubsection",
 CellID->1984223989],
Cell[3497, 125, 309, 9, 70, "GuideText",
 CellID->1344237236],
Cell[3809, 136, 290, 9, 70, "GuideText",
 CellID->1067259012],
Cell[4102, 147, 315, 9, 70, "GuideText",
 CellID->1638794940]
}, Open  ]],
Cell[CellGroupData[{
Cell[4454, 161, 82, 1, 70, "GuideFunctionsSubsection",
 CellID->579028860],
Cell[4539, 164, 317, 9, 70, "GuideText",
 CellID->1333569398],
Cell[4859, 175, 700, 21, 70, "GuideText",
 CellID->14048447]
}, Open  ]],
Cell[CellGroupData[{
Cell[5596, 201, 72, 1, 70, "GuideFunctionsSubsection",
 CellID->1489645463],
Cell[5671, 204, 1076, 29, 70, "InlineGuideFunctionListing",
 CellID->1191819428],
Cell[6750, 235, 313, 9, 70, "GuideText",
 CellID->1309978304],
Cell[7066, 246, 305, 9, 70, "GuideText",
 CellID->803006284],
Cell[7374, 257, 299, 9, 70, "GuideText",
 CellID->1339377440],
Cell[7676, 268, 272, 9, 70, "GuideText",
 CellID->993046226],
Cell[7951, 279, 693, 20, 70, "InlineGuideFunctionListing",
 CellID->1106939915]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8693, 305, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[8758, 308, 185, 4, 70, "GuideTutorial",
 CellID->164417897],
Cell[8946, 314, 174, 4, 70, "GuideTutorial",
 CellID->219558142]
}, Open  ]],
Cell[CellGroupData[{
Cell[9157, 323, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[9222, 326, 134, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[9359, 331, 193, 5, 70, "GuideMoreAbout",
 CellID->623399252]
}, Open  ]],
Cell[9567, 339, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

