(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21186,        677]
NotebookOptionsPosition[     17916,        572]
NotebookOutlinePosition[     19457,        612]
CellTagsIndexPosition[     19372,        607]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"JacobianMatrix" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/JacobianMatrix"], "JacobianDeterminant" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/JacobianDeterminant"], "ScaleFactors" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/ScaleFactors"], 
          "Div" :> Documentation`HelpLookup["paclet:VectorAnalysis/ref/Div"], 
          "Curl" :> Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/Curl"], "Grad" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Grad"], 
          "Laplacian" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Laplacian"], 
          "Biharmonic" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Biharmonic"], 
          "DotProduct" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/DotProduct"], 
          "CrossProduct" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/CrossProduct"], 
          "ScalarTripleProduct" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/ScalarTripleProduct"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"JacobianMatrix\"\>", 
       2->"\<\"JacobianDeterminant\"\>", 3->"\<\"ScaleFactors\"\>", 
       4->"\<\"Div\"\>", 5->"\<\"Curl\"\>", 6->"\<\"Grad\"\>", 
       7->"\<\"Laplacian\"\>", 8->"\<\"Biharmonic\"\>", 
       9->"\<\"DotProduct\"\>", 10->"\<\"CrossProduct\"\>", 
       11->"\<\"ScalarTripleProduct\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ArcLengthFactor", "ObjectName",
 CellID->14852],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ArcLengthFactor", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["f", "TI"], "1"], ",", 
          SubscriptBox[
           StyleBox["f", "TI"], "2"], ",", 
          SubscriptBox[
           StyleBox["f", "TI"], "3"]}], "}"}], ",", 
        StyleBox["t", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the derivative of the arc length of the curve \
described by the parametrized curve coordinates ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["f", "TI"], "1"], ",", 
        SubscriptBox[
         StyleBox["f", "TI"], "2"], ",", 
        SubscriptBox[
         StyleBox["f", "TI"], "3"]}], "}"}]], "InlineFormula"],
     " with respect to the parameter ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " in the default coordinate system. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ArcLengthFactor", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["f", "TI"], "1"], ",", 
          SubscriptBox[
           StyleBox["f", "TI"], "2"], ",", 
          SubscriptBox[
           StyleBox["f", "TI"], "3"]}], "}"}], ",", 
        StyleBox["t", "TI"], ",", 
        StyleBox["coordsys", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the derivative of the arc length of a curve in \
the coordinate system ",
     Cell[BoxData[
      StyleBox["coordsys", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->15625]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The parametrized curve coordinates ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["f", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["f", "TI"], 
     StyleBox["2", "TR"]], ",", 
    SubscriptBox[
     StyleBox["f", "TI"], 
     StyleBox["3", "TR"]]}], "}"}]], "InlineFormula"],
 " should be given in ",
 Cell[BoxData[
  StyleBox["coordsys", "TI"]], "InlineFormula"],
 ", if specified, or the default coordinate system otherwise."
}], "Notes",
 CellID->17611],

Cell[TextData[{
 "If the parametrized curve coordinates ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["f", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["f", "TI"], 
     StyleBox["2", "TR"]], ",", 
    SubscriptBox[
     StyleBox["f", "TI"], 
     StyleBox["3", "TR"]]}], "}"}]], "InlineFormula"],
 " are not given, the default coordinate variables for ",
 Cell[BoxData[
  StyleBox["coordsys", "TI"]], "InlineFormula"],
 " are used."
}], "Notes",
 CellID->27842],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Integrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integrate"], "[", 
   RowBox[{
    RowBox[{"ArcLengthFactor", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["3", "TR"]]}], "}"}], ",", 
      StyleBox["t", "TI"]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["t", "TI"], ",", 
      SubscriptBox[
       StyleBox["t", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["t", "TI"], 
       StyleBox["2", "TR"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " gives the length of the arc described by ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["f", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["f", "TI"], 
     StyleBox["2", "TR"]], ",", 
    SubscriptBox[
     StyleBox["f", "TI"], 
     StyleBox["3", "TR"]]}], "}"}]], "InlineFormula"],
 " from ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["t", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["t", "TI"], 
   StyleBox["2", "TR"]]], "InlineFormula"],
 "."
}], "Notes",
 CellID->8724]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->55175243],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->19610608],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->360122203],

Cell["Arc length factor a helix:", "ExampleText",
 CellID->210726402],

Cell[BoxData[
 RowBox[{
  RowBox[{"Helix", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"Cos", "[", "t", "]"}]}], ",", " ", 
     RowBox[{"2", 
      RowBox[{"Sin", "[", "t", "]"}]}], ",", 
     RowBox[{
      RowBox[{"t", "^", "2"}], "/", "39"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->461386063],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{"Helix", ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->183830112],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlnOmO3EQQx73j8cxkszuZPbMhWXZzkzuRuCJBAAkFIQTvEEUrhQ8IBHzI
m/BqvIwFru5qT/vXNWuPd1YEiJKx+/pXdbmubrfz/avf35z89Or3H1+/Ov7m
11e/vPnx9W/HL3/+tarK17Ise1v9+/Mgq+7/qu7cv7dlWWbZD9VvfnJycteV
vtPSoLoOqusdV/utlgopSXN1rX6z2671pY4Zm61f69h1KQ19q+9wy7V/paM3
pFTU7Ypx0/V5oX0uRRTkdoDysev9mVLc7tT7uWLvojVH+cj1/kSxL6N1iPL7
rveHin0FrQXKh673M+19rVPvJ8rJEVpHKDu07KFiX0frGOWrrvd9xb7Vqfdd
xb6D1gnK77netxX7HlovoOxklt1Q7AdoXUf5wPU+0t6PO/U+VE6eofUiyu5Z
O+6lUsbuvPjsD85uA+V9N+pAacg1r0bt6JXPdBPlPTfaYeSVrfoGV5bRV/RK
je6GIpo+qEYf6TWZ+7Cq9OWqYb/GEIhtHXMzUKruBcKNK+pxfqjSF6sdVGOL
wIe2brlyPSarMbUsdNYTfjzm1NV7LFfhLXBeU3uLOT61eYD2SUJr9zRaRV2j
89lQ2dwFnVzrJ6aMdhbQyCNpBZTUXubc0/oKtLNM3Zl15IOebgxczn5k8ZFI
YbsjddoNZ0WvQurDFik4nak1dgjq9K1EI3XKJjfL8/5u/t5qIqr0utTb+2if
mHOkDOA1zkzV6WPjuYpfoMRsWt7y6l7VwEcYBz9Q3ZC/DRM5jirCTzsu/frF
Glc0oo4NfoiLq2ns8I1CbzFazGU8Sm4Z7aS99obkfjGa+nuibYAaI++FVh7F
YttQyevERK1HKa/UKspTeMtDNrkYTXlsQxuV82y3I6+N+EB7T7UpVwr0WzaF
zYTCB9azSaxMOlDTbArThAL9Nb2HNCVRMqGzCzqXEj4FhjFqHHFz4v7QQ3aj
NjOp3cbYOhZ4Ukns6EZry6TF3MLFfEiOsWgxPfE0khf47MyTkEZmSP7ZlE4J
anmeYtn2jHajUSe65qrXgFU1Mw1a9thE3SvT7PKw+hlGyPR73ZAv6+hrKuM6
imouutkLVXLqqfKUKyr574cskigiJLkN+WAR+Qh3XZjVL0s16I/Tunlsrf6M
NHpeMNYh9OJcC9m0tspYU5oWty7THfpp+79m5F6a5qUy1qFm7xAhBsYMqXNc
t9nUpi2jZIIDXXNYz7AfVT75KUaFfQvq6TrGcV1oU+NzmOmcuHtBf0Cu5uji
xziHGXofhLJab3f00zKoLYtKI8Okr+Tekqez0yKjFjr6bLhOoAzOQAsxp5l9
7JwLnaHOijtm/wR6Z+3Scog8XM2QqzNQK+KnLxrNPIO0RiYtehzqZ6xpsV9d
zJ1Nh7sktLfYPkvD+smXTWWmcif6ftnuvTjGprCNUYwLwU/SM/ejFqIrqciz
zWuLX+z/6ZHnVMRnhn0+ZohTrW+LoIwu9hzkyYb8g1niyFht9qNyWPq8itpI
W6IkbbRj9KJ9nw8qbZGSOU/UbaByB//fjErfY+WP/xQqsx5K4N+EyqdVnCOq
Wz/p3qlcV4PqejV23Kt793Yo7vve/wrbvW8wdqnpd/qjp+8fVk1lU+ewLHqb
n7c1/F1G3QIq7YaobdH4v4/allOdN+qggyW3ZZf9eGzLwVeDyoxt2AuV+8lc
/fRD5VqHZz36oXKHluvnfqgFULmy7YfKPYW9laBy/31/JahcbV/uj1rU5dKv
rk25dMNqrJ6vmjgz4Cy0d10d8+xON5QrQT6+yp/wMVHC6nBi7GweRFKuav0Z
pFZepFzoWnNcXcPuOtfJ3WY21dGxPbrlffUTdom5Nu6GzChKiw+75+EUhnkO
6sxUBHWo6PWZjpVTCXvXzX1zZlDdn8hp/nddZ8SYfGjIN0UPu/DWntZQn3Vu
vBnohh52U/xby9jyC917GRi7Id2wxQtvq6Za7wm6odCS9yBtWlE/1LBLthq0
g9J+M7c8En3vGVHUh9oo7s1KBcJ3oKknp13Mx8dcmDhJdGFUWALrlPhn7twv
jcpYzajaD5V5BTOAfqjMgZit9ENlvmae4W1F5TNuywL7obZlrP1QmV2bZ56X
RuVKgN79XULlCourln6oXAWaJ8/PEVXyPJ4pIRpX1Vxb9uOxG+oUqG28MuPh
qvpdQm17198NVXy8hKXZStB2FY25M3nl3pKNTh0QryFFZmltO1fd0KfKO59O
27mPbujhvA49H22tH/pYeWcUbDu51A09V/Q2n9YTvbrl3iR9MKWyZiLfUD6p
lYw+3dDCVxrxyTbzZODSyFdL20qIzghvo4uUBdydGaiuhZYPlH+u/XiSkjmP
TcWf2pjPIdNscV7DcvAFxONZUWZyq6I/U/qMXjwNy/x0KfrJO5OZSp3ZGM/4
Mtc+G9WN0rZ/d/o5WS3Qwy1HK5xtZpbrzpg3zi7ZdIKe5qX9Xih4m0OMjs/E
L57FZoTmjPck/Zqs/u5KV3KMdR7J7Q3E73wETqRi7Kc/Dk9T/YSNOI54y3Tm
VgZVo5XzL3ZSNE3Fs8CT9Q3KQl4bZ6tt3btg4J32PsnhJieOGRNs7JHySsxH
kSTK2lbpf60n19Rkp7PVlXuNxLe+GlqrioI7f4bhC4uBgfgQiNzfGyWI+4rE
/QAica5FgrSls4wt2esH32YTmzFimGDzbSK1jRQegAL1IE8ouB0+wx+EN/Tc
jbgPClbGevocRlE5y7JkD4EUnG9peFPR8IGJPUaZOwn3gO2iVOO7Yxt3otLg
HgLx6vWlOi6PFt4HBu0NPkR+uc79AIg1J+rjvEyvlvabcaI9dwJHLKln6XfH
Yot1USDLkrXnxxEdmVetMQYGNYlYzgqS+CYcCaOTBajBr5powxhNCpsLUIIf
YRS7B55l0NYCjEnUN8uyJIe4g3a53Ws8tXVQo5UeJjRFOiKy7TKKjk5X8ixL
zgUdGrO5TK7c9VY5913Si37zioF0DXVel26jlppJZJepFfEcA/51jFwz8UMU
N78hNGW3o3PlnoeNH/J583tISOQAdRcTHnKTRoi/+kpeq+e5R1OHKPfGCZ8E
e9KUr+KO0Kuoo/+8zn9te6s0fFbIxQwZhNOplK5HEysdZs3c1sfIMH4/kRnX
bx7pESWjyKmdhtND/jvtx0A7Tvr7/03iCfrtqh5MOvY3v5Q1xj1M6i+VdiSe
lFG+6uYf9H5oSMnNs+Gvs4W9npbItbWVOu57f4raoBlPzdbPXe1HySy/qPmT
sV+60tvkN1v7G+ys8v4=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{120, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->4619213]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", " ", "=", 
  RowBox[{
   RowBox[{"ArcLengthFactor", "[", 
    RowBox[{"Helix", ",", " ", "t"}], "]"}], "//", "Simplify"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->34698673],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SqrtBox[
    RowBox[{"1521", "+", 
     SuperscriptBox["t", "2"]}]]}], "39"]], "Output",
 ImageSize->{91, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->279415513]
}, Open  ]],

Cell["Compute the arc length of the helix from t = 0 to t = 20:", \
"ExampleText",
 CellID->195366754],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{"a", ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->549023429],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"20", " ", 
    SqrtBox["1921"]}], "39"], "+", 
  RowBox[{"39", " ", 
   RowBox[{"ArcSinh", "[", 
    FractionBox["20", "39"], "]"}]}]}]], "Output",
 ImageSize->{181, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->588314311]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7328],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobianMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/JacobianMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobianDeterminant",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/JacobianDeterminant"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScaleFactors",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/ScaleFactors"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Div",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Div"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Curl",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Curl"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Grad",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Grad"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Laplacian",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Laplacian"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Biharmonic",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Biharmonic"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DotProduct",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/DotProduct"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CrossProduct",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/CrossProduct"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScalarTripleProduct",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/ScalarTripleProduct"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23855]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31149],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->20135]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ArcLengthFactor - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 12, 58.7785234}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "ArcLengthFactor[{f_1, f_2, f_3}, t] gives the derivative of the arc \
length of the curve described by the parametrized curve coordinates {f_1, \
f_2, f_3} with respect to the parameter t in the default coordinate system. \
ArcLengthFactor[{f_1, f_2, f_3}, t, coordsys] gives the derivative of the arc \
length of a curve in the coordinate system coordsys.", "synonyms" -> {}, 
    "title" -> "ArcLengthFactor", "type" -> "Symbol", "uri" -> 
    "VectorAnalysis/ref/ArcLengthFactor"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8063, 264, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->55175243]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19230, 600}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2547, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3170, 82, 53, 1, 70, "ObjectName",
 CellID->14852],
Cell[3226, 85, 1802, 55, 70, "Usage",
 CellID->15625]
}, Open  ]],
Cell[CellGroupData[{
Cell[5065, 145, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5543, 162, 535, 19, 70, "Notes",
 CellID->17611],
Cell[6081, 183, 522, 19, 70, "Notes",
 CellID->27842],
Cell[6606, 204, 1420, 55, 70, "Notes",
 CellID->8724]
}, Closed]],
Cell[CellGroupData[{
Cell[8063, 264, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->55175243],
Cell[CellGroupData[{
Cell[8447, 278, 147, 5, 70, "ExampleSection",
 CellID->19610608],
Cell[8597, 285, 139, 4, 70, "Input",
 CellID->360122203],
Cell[8739, 291, 69, 1, 70, "ExampleText",
 CellID->210726402],
Cell[8811, 294, 357, 12, 70, "Input",
 CellID->461386063],
Cell[CellGroupData[{
Cell[9193, 310, 204, 6, 28, "Input",
 CellID->183830112],
Cell[9400, 318, 3525, 62, 237, "Output",
 Evaluatable->False,
 CellID->4619213]
}, Open  ]],
Cell[CellGroupData[{
Cell[12962, 385, 204, 6, 70, "Input",
 CellID->34698673],
Cell[13169, 393, 270, 10, 61, "Output",
 CellID->279415513]
}, Open  ]],
Cell[13454, 406, 102, 2, 70, "ExampleText",
 CellID->195366754],
Cell[CellGroupData[{
Cell[13581, 412, 193, 6, 70, "Input",
 CellID->549023429],
Cell[13777, 420, 329, 12, 56, "Output",
 CellID->588314311]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14167, 439, 310, 9, 70, "SeeAlsoSection",
 CellID->7328],
Cell[14480, 450, 2877, 98, 70, "SeeAlso",
 CellID->23855]
}, Open  ]],
Cell[CellGroupData[{
Cell[17394, 553, 314, 9, 70, "TutorialsSection",
 CellID->31149],
Cell[17711, 564, 163, 3, 70, "Tutorials",
 CellID->20135]
}, Open  ]],
Cell[17889, 570, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

