(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11750,        425]
NotebookOptionsPosition[      8714,        327]
NotebookOutlinePosition[     10209,        366]
CellTagsIndexPosition[     10125,        361]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Bispherical" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Bispherical"], 
          "Toroidal" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Toroidal"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Bispherical\"\>", 
       2->"\<\"Toroidal\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Bipolar", "ObjectName",
 CellID->26224],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Bipolar"], "InlineFormula"],
     "\[LineSeparator]represents the bipolar coordinate system with default \
variables ",
     Cell[BoxData[
      ButtonBox["Uu",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Uu"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Vv",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Vv"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      ButtonBox["Zz",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Zz"]], "InlineFormula"],
     " and default parameter value ",
     Cell[BoxData[
      StyleBox["1", "TR"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Bipolar", "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["v", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the bipolar coordinate system with variables \
",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     " and default parameter value ",
     Cell[BoxData[
      StyleBox["1", "TR"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Bipolar", "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["v", "TI"], ",", 
        StyleBox["z", "TI"], ",", 
        StyleBox["a", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the bipolar coordinate system with variables \
",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     ", and parameter ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->17728]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->469419034],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->577726068],

Cell[TextData[{
 "Use ",
 Cell[BoxData["Bipolar"], "InlineFormula"],
 " as the default coordinate system:"
}], "ExampleText",
 CellID->428269499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetCoordinates", "[", "Bipolar", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->443597938],

Cell[BoxData[
 RowBox[{"Bipolar", "[", 
  RowBox[{"Uu", ",", "Vv", ",", "Zz", ",", "1"}], "]"}]], "Output",
 ImageSize->{150, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->457761355]
}, Open  ]],

Cell["All evaluations now use bipolar coordinates as the default:", \
"ExampleText",
 CellID->116864137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoordinateRanges", "[", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->709779145],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "\[Pi]"}], "<", "Uu", "\[LessEqual]", "\[Pi]"}], ",", 
   RowBox[{
    RowBox[{"-", "\[Infinity]"}], "<", "Vv", "<", "\[Infinity]"}], ",", 
   RowBox[{
    RowBox[{"-", "\[Infinity]"}], "<", "Zz", "<", "\[Infinity]"}]}], 
  "}"}]], "Output",
 ImageSize->{238, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->95756673]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobianDeterminant", "[", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->33744766],

Cell[BoxData[
 FractionBox["1", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cos", "[", "Uu", "]"}]}], "+", 
     RowBox[{"Cosh", "[", "Vv", "]"}]}], ")"}], "2"]]], "Output",
 ImageSize->{153, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->219675518]
}, Open  ]],

Cell[TextData[{
 "Reset the default coordinate system to ",
 Cell[BoxData[
  ButtonBox["Cartesian",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Cartesian"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->31402094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetCoordinates", "[", "Cartesian", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->74704059],

Cell[BoxData[
 RowBox[{"Cartesian", "[", 
  RowBox[{"Xx", ",", "Yy", ",", "Zz"}], "]"}]], "Output",
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->354367842]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19312],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Bispherical",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Bispherical"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Toroidal",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Toroidal"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->734]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26260],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->12158]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Bipolar - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 12, 59.3879140}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "Bipolar represents the bipolar coordinate system with default variables \
Uu, Vv, and Zz and default parameter value 1. Bipolar[u, v, z] represents the \
bipolar coordinate system with variables u, v, and z and default parameter \
value 1. Bipolar[u, v, z, a] represents the bipolar coordinate system with \
variables u, v, and z, and parameter a.", "synonyms" -> {}, "title" -> 
    "Bipolar", "type" -> "Symbol", "uri" -> "VectorAnalysis/ref/Bipolar"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4284, 143, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9990, 354}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1339, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1962, 61, 45, 1, 70, "ObjectName",
 CellID->26224],
Cell[2010, 64, 2237, 74, 70, "Usage",
 CellID->17728]
}, Open  ]],
Cell[CellGroupData[{
Cell[4284, 143, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4661, 157, 148, 5, 70, "ExampleSection",
 CellID->469419034],
Cell[4812, 164, 139, 4, 70, "Input",
 CellID->577726068],
Cell[4954, 170, 145, 5, 70, "ExampleText",
 CellID->428269499],
Cell[CellGroupData[{
Cell[5124, 179, 116, 3, 28, "Input",
 CellID->443597938],
Cell[5243, 184, 238, 7, 36, "Output",
 CellID->457761355]
}, Open  ]],
Cell[5496, 194, 104, 2, 70, "ExampleText",
 CellID->116864137],
Cell[CellGroupData[{
Cell[5625, 200, 107, 3, 28, "Input",
 CellID->709779145],
Cell[5735, 205, 440, 14, 36, "Output",
 CellID->95756673]
}, Open  ]],
Cell[CellGroupData[{
Cell[6212, 224, 109, 3, 70, "Input",
 CellID->33744766],
Cell[6324, 229, 343, 12, 54, "Output",
 CellID->219675518]
}, Open  ]],
Cell[6682, 244, 238, 8, 70, "ExampleText",
 CellID->31402094],
Cell[CellGroupData[{
Cell[6945, 256, 117, 3, 70, "Input",
 CellID->74704059],
Cell[7065, 261, 230, 7, 36, "Output",
 CellID->354367842]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7356, 275, 311, 9, 70, "SeeAlsoSection",
 CellID->19312],
Cell[7670, 286, 485, 17, 70, "SeeAlso",
 CellID->734]
}, Open  ]],
Cell[CellGroupData[{
Cell[8192, 308, 314, 9, 70, "TutorialsSection",
 CellID->26260],
Cell[8509, 319, 163, 3, 70, "Tutorials",
 CellID->12158]
}, Open  ]],
Cell[8687, 325, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

