(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12996,        485]
NotebookOptionsPosition[      9815,        376]
NotebookOutlinePosition[     11159,        414]
CellTagsIndexPosition[     11074,        409]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cylindrical" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Cylindrical"], 
          "Spherical" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Spherical"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Cylindrical\"\>", 
       2->"\<\"Spherical\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Cartesian", "ObjectName",
 CellID->3916],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Cartesian"], "InlineFormula"],
     "\[LineSeparator]represents the ",
     Cell[BoxData["Cartesian"], "InlineFormula"],
     " coordinate system with default variables ",
     Cell[BoxData[
      ButtonBox["Xx",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Xx"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Yy",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Yy"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      ButtonBox["Zz",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Zz"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Cartesian", "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the ",
     Cell[BoxData["Cartesian"], "InlineFormula"],
     " coordinate system with variables ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->26182]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->270058656],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->304592041],

Cell["\<\
By default, all calculations are done in Cartesian coordinates:\
\>", "ExampleText",
 CellID->112245260],

Cell[CellGroupData[{

Cell[BoxData["CoordinateSystem"], "Input",
 CellLabel->"In[2]:=",
 CellID->830195658],

Cell[BoxData["Cartesian"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->50143018]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coordinates", "[", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->84393120],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Xx", ",", "Yy", ",", "Zz"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->931894449]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Laplacian", "[", 
  RowBox[{"f", "[", 
   RowBox[{"Xx", ",", " ", "Yy", ",", " ", "Zz"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->12234442],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["f", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "0", ",", "2"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"Xx", ",", "Yy", ",", "Zz"}], "]"}], "+", 
  RowBox[{
   SuperscriptBox["f", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "2", ",", "0"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"Xx", ",", "Yy", ",", "Zz"}], "]"}], "+", 
  RowBox[{
   SuperscriptBox["f", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"2", ",", "0", ",", "0"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"Xx", ",", "Yy", ",", "Zz"}], "]"}]}]], "Output",
 ImageSize->{392, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->98923534]
}, Open  ]],

Cell["Use another coordinate system as the default:", "ExampleText",
 CellID->176904404],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetCoordinates", "[", "Cylindrical", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->644208518],

Cell[BoxData[
 RowBox[{"Cylindrical", "[", 
  RowBox[{"Rr", ",", "Ttheta", ",", "Zz"}], "]"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->29897026]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Laplacian", "[", 
   RowBox[{"f", "[", 
    RowBox[{"Rr", ",", " ", "Ttheta", ",", " ", "Zz"}], "]"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->640938159],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["f", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "0", ",", "2"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"Rr", ",", "Ttheta", ",", "Zz"}], "]"}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["f", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "2", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"Rr", ",", "Ttheta", ",", "Zz"}], "]"}], 
   SuperscriptBox["Rr", "2"]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["f", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "0", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"Rr", ",", "Ttheta", ",", "Zz"}], "]"}], "Rr"], "+", 
  RowBox[{
   SuperscriptBox["f", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"2", ",", "0", ",", "0"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"Rr", ",", "Ttheta", ",", "Zz"}], "]"}]}]], "Output",
 ImageSize->{329, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->275699923]
}, Open  ]],

Cell[TextData[{
 "Reset ",
 Cell[BoxData["Cartesian"], "InlineFormula"],
 " as the default:"
}], "ExampleText",
 CellID->343364971],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetCoordinates", "[", "Cartesian", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->6509379],

Cell[BoxData[
 RowBox[{"Cartesian", "[", 
  RowBox[{"Xx", ",", "Yy", ",", "Zz"}], "]"}]], "Output",
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->275319423]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4583],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cylindrical",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Cylindrical"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Spherical",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Spherical"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22399]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19029],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->25316]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Cartesian - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 0.2316856}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "Cartesian represents the Cartesian coordinate system with default \
variables Xx, Yy, and Zz. Cartesian[x, y, z] represents the Cartesian \
coordinate system with variables x, y, and z.", "synonyms" -> {}, "title" -> 
    "Cartesian", "type" -> "Symbol", "uri" -> 
    "VectorAnalysis/ref/Cartesian"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3513, 116, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10939, 402}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1342, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1965, 61, 46, 1, 70, "ObjectName",
 CellID->3916],
Cell[2014, 64, 1462, 47, 70, "Usage",
 CellID->26182]
}, Open  ]],
Cell[CellGroupData[{
Cell[3513, 116, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3890, 130, 148, 5, 70, "ExampleSection",
 CellID->270058656],
Cell[4041, 137, 139, 4, 70, "Input",
 CellID->304592041],
Cell[4183, 143, 114, 3, 70, "ExampleText",
 CellID->112245260],
Cell[CellGroupData[{
Cell[4322, 150, 85, 2, 28, "Input",
 CellID->830195658],
Cell[4410, 154, 165, 5, 36, "Output",
 CellID->50143018]
}, Open  ]],
Cell[CellGroupData[{
Cell[4612, 164, 101, 3, 28, "Input",
 CellID->84393120],
Cell[4716, 169, 216, 7, 36, "Output",
 CellID->931894449]
}, Open  ]],
Cell[CellGroupData[{
Cell[4969, 181, 179, 5, 28, "Input",
 CellID->12234442],
Cell[5151, 188, 826, 30, 36, "Output",
 CellID->98923534]
}, Open  ]],
Cell[5992, 221, 88, 1, 70, "ExampleText",
 CellID->176904404],
Cell[CellGroupData[{
Cell[6105, 226, 120, 3, 70, "Input",
 CellID->644208518],
Cell[6228, 231, 235, 7, 36, "Output",
 CellID->29897026]
}, Open  ]],
Cell[CellGroupData[{
Cell[6500, 243, 220, 7, 70, "Input",
 CellID->640938159],
Cell[6723, 252, 1150, 41, 88, "Output",
 CellID->275699923]
}, Open  ]],
Cell[7888, 296, 131, 5, 70, "ExampleText",
 CellID->343364971],
Cell[CellGroupData[{
Cell[8044, 305, 116, 3, 70, "Input",
 CellID->6509379],
Cell[8163, 310, 230, 7, 36, "Output",
 CellID->275319423]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8454, 324, 310, 9, 70, "SeeAlsoSection",
 CellID->4583],
Cell[8767, 335, 489, 17, 70, "SeeAlso",
 CellID->22399]
}, Open  ]],
Cell[CellGroupData[{
Cell[9293, 357, 314, 9, 70, "TutorialsSection",
 CellID->19029],
Cell[9610, 368, 163, 3, 70, "Tutorials",
 CellID->25316]
}, Open  ]],
Cell[9788, 374, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

