(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12521,        448]
NotebookOptionsPosition[      9380,        348]
NotebookOutlinePosition[     10983,        389]
CellTagsIndexPosition[     10898,        384]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ConfocalEllipsoidal" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/ConfocalEllipsoidal"], 
          "ConfocalParaboloidal" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/ConfocalParaboloidal"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ConfocalEllipsoidal\"\>", 
       2->"\<\"ConfocalParaboloidal\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Conical", "ObjectName",
 CellID->4099],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Conical"], "InlineFormula"],
     "\[LineSeparator]represents the conical coordinate system with default \
variables ",
     Cell[BoxData[
      ButtonBox["Llambda",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Llambda"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Mmu",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Mmu"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      ButtonBox["Nnu",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Nnu"]], "InlineFormula"],
     " and default parameter values ",
     Cell[BoxData[
      StyleBox["1", "TR"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["2", "TR"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Conical", "[", 
       RowBox[{
        StyleBox["\[Lambda]", "TR"], ",", 
        StyleBox["\[Mu]", "TR"], ",", 
        StyleBox["\[Nu]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the conical coordinate system with variables \
",
     Cell[BoxData[
      RowBox[{
       StyleBox["\[Lambda]", "TR"], ",", 
       StyleBox["\[Mu]", "TR"]}]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["\[Nu]", "TR"]], "InlineFormula"],
     " and default parameter values 1 and 2. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Conical", "[", 
       RowBox[{
        StyleBox["\[Lambda]", "TR"], ",", 
        StyleBox["\[Mu]", "TR"], ",", 
        StyleBox["\[Nu]", "TR"], ",", 
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the conical coordinate system with variables \
",
     Cell[BoxData[
      RowBox[{
       StyleBox["\[Lambda]", "TR"], ",", 
       StyleBox["\[Mu]", "TR"]}]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["\[Nu]", "TR"]], "InlineFormula"],
     " and parameters ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->14363]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->579042284],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->126116253],

Cell[TextData[{
 "Use ",
 Cell[BoxData["Conical"], "InlineFormula"],
 " as the default coordinate system:"
}], "ExampleText",
 CellID->428269499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetCoordinates", "[", "Conical", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->443597938],

Cell[BoxData[
 RowBox[{"Conical", "[", 
  RowBox[{"Llambda", ",", "Mmu", ",", "Nnu", ",", "1", ",", "2"}], 
  "]"}]], "Output",
 ImageSize->{217, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->133628004]
}, Open  ]],

Cell["All evaluations now use conical coordinates as the default:", \
"ExampleText",
 CellID->116864137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoordinateRanges", "[", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->709779145],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "\[Infinity]"}], "<", "Llambda", "<", "\[Infinity]"}], ",", 
   RowBox[{"1", "<", 
    SuperscriptBox["Mmu", "2"], "<", "4"}], ",", 
   RowBox[{
    SuperscriptBox["Nnu", "2"], "<", "1"}]}], "}"}]], "Output",
 ImageSize->{258, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->94797954]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobianDeterminant", "[", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->33744766],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["Mmu", "2"], "-", 
     SuperscriptBox["Nnu", "2"]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"Abs", "[", "Llambda", "]"}], "2"]}], 
  RowBox[{
   SqrtBox[
    RowBox[{"4", "-", 
     SuperscriptBox["Mmu", "2"]}]], " ", 
   SqrtBox[
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["Mmu", "2"]}]], " ", 
   SqrtBox[
    RowBox[{
     RowBox[{"-", "4"}], "+", 
     SuperscriptBox["Nnu", "2"]}]], " ", 
   SqrtBox[
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["Nnu", "2"]}]]}]]], "Output",
 ImageSize->{301, 46},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->394608378]
}, Open  ]],

Cell[TextData[{
 "Reset the default coordinate system to ",
 Cell[BoxData[
  ButtonBox["Cartesian",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Cartesian"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->31402094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetCoordinates", "[", "Cartesian", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->74704059],

Cell[BoxData[
 RowBox[{"Cartesian", "[", 
  RowBox[{"Xx", ",", "Yy", ",", "Zz"}], "]"}]], "Output",
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->230644]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24083],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ConfocalEllipsoidal",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/ConfocalEllipsoidal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ConfocalParaboloidal",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/ConfocalParaboloidal"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7389]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13245],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->14726]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Conical - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 1.7942256}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "Conical represents the conical coordinate system with default variables \
Llambda, Mmu, and Nnu and default parameter values 1 and 2. \
Conical[\\[Lambda], \\[Mu], \\[Nu]] represents the conical coordinate system \
with variables \\[Lambda], \\[Mu] and \\[Nu] and default parameter values 1 \
and 2. Conical[\\[Lambda], \\[Mu], \\[Nu], a, b] represents the conical \
coordinate system with variables \\[Lambda], \\[Mu] and \\[Nu] and parameters \
a and b.", "synonyms" -> {}, "title" -> "Conical", "type" -> "Symbol", "uri" -> 
    "VectorAnalysis/ref/Conical"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4522, 147, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10763, 377}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1422, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2045, 63, 44, 1, 70, "ObjectName",
 CellID->4099],
Cell[2092, 66, 2393, 76, 70, "Usage",
 CellID->14363]
}, Open  ]],
Cell[CellGroupData[{
Cell[4522, 147, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4899, 161, 148, 5, 70, "ExampleSection",
 CellID->579042284],
Cell[5050, 168, 139, 4, 70, "Input",
 CellID->126116253],
Cell[5192, 174, 145, 5, 70, "ExampleText",
 CellID->428269499],
Cell[CellGroupData[{
Cell[5362, 183, 116, 3, 28, "Input",
 CellID->443597938],
Cell[5481, 188, 258, 8, 36, "Output",
 CellID->133628004]
}, Open  ]],
Cell[5754, 199, 104, 2, 70, "ExampleText",
 CellID->116864137],
Cell[CellGroupData[{
Cell[5883, 205, 107, 3, 28, "Input",
 CellID->709779145],
Cell[5993, 210, 407, 13, 39, "Output",
 CellID->94797954]
}, Open  ]],
Cell[CellGroupData[{
Cell[6437, 228, 109, 3, 70, "Input",
 CellID->33744766],
Cell[6549, 233, 746, 29, 67, "Output",
 CellID->394608378]
}, Open  ]],
Cell[7310, 265, 238, 8, 70, "ExampleText",
 CellID->31402094],
Cell[CellGroupData[{
Cell[7573, 277, 117, 3, 70, "Input",
 CellID->74704059],
Cell[7693, 282, 227, 7, 36, "Output",
 CellID->230644]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7981, 296, 311, 9, 70, "SeeAlsoSection",
 CellID->24083],
Cell[8295, 307, 526, 17, 70, "SeeAlso",
 CellID->7389]
}, Open  ]],
Cell[CellGroupData[{
Cell[8858, 329, 314, 9, 70, "TutorialsSection",
 CellID->13245],
Cell[9175, 340, 163, 3, 70, "Tutorials",
 CellID->14726]
}, Open  ]],
Cell[9353, 346, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

