(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9259,        326]
NotebookOptionsPosition[      6554,        238]
NotebookOutlinePosition[      7962,        277]
CellTagsIndexPosition[      7878,        272]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Parameters" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Parameters"], 
          "ParameterRanges" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/ParameterRanges"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Parameters\"\>", 
       2->"\<\"ParameterRanges\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CoordinateRanges", "ObjectName",
 CellID->20106],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CoordinateRanges", "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the intervals over which each of the coordinates \
in the default coordinate system may range. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CoordinateRanges", "[", 
       StyleBox["coordsys", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the ranges for each of the coordinates in the \
coordinate system ",
     Cell[BoxData[
      StyleBox["coordsys", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->9868]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->32042024],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->675599352],

Cell["Range of coordinate values in the default system:", "ExampleText",
 CellID->3631386],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoordinateRanges", "[", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->135998680],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "\[Infinity]"}], "<", "Xx", "<", "\[Infinity]"}], ",", 
   RowBox[{
    RowBox[{"-", "\[Infinity]"}], "<", "Yy", "<", "\[Infinity]"}], ",", 
   RowBox[{
    RowBox[{"-", "\[Infinity]"}], "<", "Zz", "<", "\[Infinity]"}]}], 
  "}"}]], "Output",
 ImageSize->{238, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->74755470]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->160666124],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->581912288],

Cell["Range of coordinate values in another system:", "ExampleText",
 CellID->35654584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoordinateRanges", "[", "Spherical", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->286699313],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0", "\[LessEqual]", "Rr", "<", "\[Infinity]"}], ",", 
   RowBox[{"0", "\[LessEqual]", "Ttheta", "\[LessEqual]", "\[Pi]"}], ",", 
   RowBox[{
    RowBox[{"-", "\[Pi]"}], "<", "Pphi", "\[LessEqual]", "\[Pi]"}]}], 
  "}"}]], "Output",
 ImageSize->{263, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1864993]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11592],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Parameters",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Parameters"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ParameterRanges",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/ParameterRanges"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24988]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8644],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->23826]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CoordinateRanges - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 6.5912234}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "CoordinateRanges[] gives the intervals over which each of the \
coordinates in the default coordinate system may range. \
CoordinateRanges[coordsys] gives the ranges for each of the coordinates in \
the coordinate system coordsys.", "synonyms" -> {}, "title" -> 
    "CoordinateRanges", "type" -> "Symbol", "uri" -> 
    "VectorAnalysis/ref/CoordinateRanges"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2855, 92, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7744, 265}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1368, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1991, 62, 54, 1, 70, "ObjectName",
 CellID->20106],
Cell[2048, 65, 770, 22, 70, "Usage",
 CellID->9868]
}, Open  ]],
Cell[CellGroupData[{
Cell[2855, 92, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3232, 106, 147, 5, 70, "ExampleSection",
 CellID->32042024],
Cell[3382, 113, 139, 4, 70, "Input",
 CellID->675599352],
Cell[3524, 119, 90, 1, 70, "ExampleText",
 CellID->3631386],
Cell[CellGroupData[{
Cell[3639, 124, 107, 3, 28, "Input",
 CellID->135998680],
Cell[3749, 129, 441, 14, 36, "Output",
 CellID->74755470]
}, Open  ]],
Cell[4205, 146, 125, 3, 70, "ExampleDelimiter",
 CellID->160666124],
Cell[4333, 151, 139, 4, 70, "Input",
 CellID->581912288],
Cell[4475, 157, 87, 1, 70, "ExampleText",
 CellID->35654584],
Cell[CellGroupData[{
Cell[4587, 162, 120, 3, 70, "Input",
 CellID->286699313],
Cell[4710, 167, 412, 12, 36, "Output",
 CellID->1864993]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5183, 186, 311, 9, 70, "SeeAlsoSection",
 CellID->11592],
Cell[5497, 197, 499, 17, 70, "SeeAlso",
 CellID->24988]
}, Open  ]],
Cell[CellGroupData[{
Cell[6033, 219, 313, 9, 70, "TutorialsSection",
 CellID->8644],
Cell[6349, 230, 163, 3, 70, "Tutorials",
 CellID->23826]
}, Open  ]],
Cell[6527, 236, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

