(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9751,        356]
NotebookOptionsPosition[      6782,        257]
NotebookOutlinePosition[      8151,        295]
CellTagsIndexPosition[      8067,        290]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CoordinateSystem" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/CoordinateSystem"], "SetCoordinates" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/SetCoordinates"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"CoordinateSystem\"\>", 
       2->"\<\"SetCoordinates\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Coordinates", "ObjectName",
 CellID->29743],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Coordinates", "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the default coordinate variables in the \
default coordinate system. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Coordinates", "[", 
       StyleBox["coordsys", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the default coordinate variables in the \
coordinate system ",
     Cell[BoxData[
      StyleBox["coordsys", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->26439]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->270252543],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->18244908],

Cell["Coordinates used in the default coordinate system:", "ExampleText",
 CellID->326038064],

Cell[CellGroupData[{

Cell[BoxData["CoordinateSystem"], "Input",
 CellLabel->"In[2]:=",
 CellID->321648984],

Cell[BoxData["Cartesian"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->229981309]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coordinates", "[", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->199673880],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Xx", ",", "Yy", ",", "Zz"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->82046533]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->239332677],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->444206368],

Cell["Coordinates used in other systems:", "ExampleText",
 CellID->785194674],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coordinates", "[", "Spherical", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->304428337],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Rr", ",", "Ttheta", ",", "Pphi"}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18910973]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coordinates", "[", "Bipolar", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->466971067],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Uu", ",", "Vv", ",", "Zz"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->781089914]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30393],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CoordinateSystem",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/CoordinateSystem"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetCoordinates",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/SetCoordinates"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21033]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21301],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->21493]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Coordinates - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 6.9506076}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "Coordinates[] gives a list of the default coordinate variables in the \
default coordinate system. Coordinates[coordsys] gives a list of the default \
coordinate variables in the coordinate system coordsys.", "synonyms" -> {}, 
    "title" -> "Coordinates", "type" -> "Symbol", "uri" -> 
    "VectorAnalysis/ref/Coordinates"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2845, 92, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7933, 283}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1384, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2007, 62, 49, 1, 70, "ObjectName",
 CellID->29743],
Cell[2059, 65, 749, 22, 70, "Usage",
 CellID->26439]
}, Open  ]],
Cell[CellGroupData[{
Cell[2845, 92, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3222, 106, 148, 5, 70, "ExampleSection",
 CellID->270252543],
Cell[3373, 113, 138, 4, 70, "Input",
 CellID->18244908],
Cell[3514, 119, 93, 1, 70, "ExampleText",
 CellID->326038064],
Cell[CellGroupData[{
Cell[3632, 124, 85, 2, 28, "Input",
 CellID->321648984],
Cell[3720, 128, 166, 5, 36, "Output",
 CellID->229981309]
}, Open  ]],
Cell[CellGroupData[{
Cell[3923, 138, 102, 3, 28, "Input",
 CellID->199673880],
Cell[4028, 143, 215, 7, 36, "Output",
 CellID->82046533]
}, Open  ]],
Cell[4258, 153, 125, 3, 70, "ExampleDelimiter",
 CellID->239332677],
Cell[4386, 158, 139, 4, 70, "Input",
 CellID->444206368],
Cell[4528, 164, 77, 1, 70, "ExampleText",
 CellID->785194674],
Cell[CellGroupData[{
Cell[4630, 169, 115, 3, 70, "Input",
 CellID->304428337],
Cell[4748, 174, 222, 7, 36, "Output",
 CellID->18910973]
}, Open  ]],
Cell[CellGroupData[{
Cell[5007, 186, 113, 3, 70, "Input",
 CellID->466971067],
Cell[5123, 191, 216, 7, 36, "Output",
 CellID->781089914]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5400, 205, 311, 9, 70, "SeeAlsoSection",
 CellID->30393],
Cell[5714, 216, 509, 17, 70, "SeeAlso",
 CellID->21033]
}, Open  ]],
Cell[CellGroupData[{
Cell[6260, 238, 314, 9, 70, "TutorialsSection",
 CellID->21301],
Cell[6577, 249, 163, 3, 70, "Tutorials",
 CellID->21493]
}, Open  ]],
Cell[6755, 255, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

