(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8829,        309]
NotebookOptionsPosition[      6176,        225]
NotebookOutlinePosition[      7655,        264]
CellTagsIndexPosition[      7571,        259]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CoordinatesToCartesian" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/CoordinatesToCartesian"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"CoordinatesToCartesian\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CoordinatesFromCartesian", "ObjectName",
 CellID->15864],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CoordinatesFromCartesian", "[", 
       StyleBox["pt", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the coordinates in the default coordinate system \
of the point ",
     Cell[BoxData[
      StyleBox["pt", "TI"]], "InlineFormula"],
     " given in ",
     Cell[BoxData["Cartesian"], "InlineFormula"],
     " coordinates. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CoordinatesFromCartesian", "[", 
       RowBox[{
        StyleBox["pt", "TI"], ",", 
        StyleBox["coordsys", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the coordinates in the coordinate system ",
     Cell[BoxData[
      StyleBox["coordsys", "TI"]], "InlineFormula"],
     " of the point given in ",
     Cell[BoxData["Cartesian"], "InlineFormula"],
     " coordinates."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->20537]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->55468338],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->665207144],

Cell["Find the cylindrical coordinates for a point in space:", "ExampleText",
 CellID->534486770],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoordinatesFromCartesian", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"7", "/", "2"}], ",", " ", 
     RowBox[{"7", 
      RowBox[{
       RowBox[{"Sqrt", "[", "3", "]"}], "/", "2"}]}], ",", " ", "5"}], "}"}], 
   ",", " ", "Cylindrical"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->119535582],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7", ",", 
   FractionBox["\[Pi]", "3"], ",", "5"}], "}"}]], "Output",
 ImageSize->{67, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->809870008]
}, Open  ]],

Cell["Transform back to Cartesian coordinates:", "ExampleText",
 CellID->9655293],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoordinatesToCartesian", "[", 
  RowBox[{"%", ",", " ", "Cylindrical"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->248318185],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["7", "2"], ",", 
   FractionBox[
    RowBox[{"7", " ", 
     SqrtBox["3"]}], "2"], ",", "5"}], "}"}]], "Output",
 ImageSize->{97, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->44128197]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29788],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["CoordinatesToCartesian",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/CoordinatesToCartesian"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->30794]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2695],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->18525]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CoordinatesFromCartesian - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 6.7787282}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "CoordinatesFromCartesian[pt] gives the coordinates in the default \
coordinate system of the point pt given in Cartesian coordinates. \
CoordinatesFromCartesian[pt, coordsys] gives the coordinates in the \
coordinate system coordsys of the point given in Cartesian coordinates.", 
    "synonyms" -> {}, "title" -> "CoordinatesFromCartesian", "type" -> 
    "Symbol", "uri" -> "VectorAnalysis/ref/CoordinatesFromCartesian"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3054, 99, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7437, 252}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1260, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1883, 60, 62, 1, 70, "ObjectName",
 CellID->15864],
Cell[1948, 63, 1069, 31, 70, "Usage",
 CellID->20537]
}, Open  ]],
Cell[CellGroupData[{
Cell[3054, 99, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3431, 113, 147, 5, 70, "ExampleSection",
 CellID->55468338],
Cell[3581, 120, 139, 4, 70, "Input",
 CellID->665207144],
Cell[3723, 126, 97, 1, 70, "ExampleText",
 CellID->534486770],
Cell[CellGroupData[{
Cell[3845, 131, 341, 11, 28, "Input",
 CellID->119535582],
Cell[4189, 144, 239, 8, 49, "Output",
 CellID->809870008]
}, Open  ]],
Cell[4443, 155, 81, 1, 70, "ExampleText",
 CellID->9655293],
Cell[CellGroupData[{
Cell[4549, 160, 156, 4, 28, "Input",
 CellID->248318185],
Cell[4708, 166, 296, 11, 56, "Output",
 CellID->44128197]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5065, 184, 311, 9, 70, "SeeAlsoSection",
 CellID->29788],
Cell[5379, 195, 239, 6, 70, "SeeAlso",
 CellID->30794]
}, Open  ]],
Cell[CellGroupData[{
Cell[5655, 206, 313, 9, 70, "TutorialsSection",
 CellID->2695],
Cell[5971, 217, 163, 3, 70, "Tutorials",
 CellID->18525]
}, Open  ]],
Cell[6149, 223, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

