(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8708,        308]
NotebookOptionsPosition[      6097,        224]
NotebookOutlinePosition[      7536,        263]
CellTagsIndexPosition[      7452,        258]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CoordinatesFromCartesian" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/CoordinatesFromCartesian"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"CoordinatesFromCartesian\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CoordinatesToCartesian", "ObjectName",
 CellID->5041],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CoordinatesToCartesian", "[", 
       StyleBox["pt", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the ",
     Cell[BoxData["Cartesian"], "InlineFormula"],
     " coordinates of the point ",
     Cell[BoxData[
      StyleBox["pt", "TI"]], "InlineFormula"],
     " given in the default coordinate system. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CoordinatesToCartesian", "[", 
       RowBox[{
        StyleBox["pt", "TI"], ",", 
        StyleBox["coordsys", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the ",
     Cell[BoxData["Cartesian"], "InlineFormula"],
     " coordinates of the point given in the coordinate system ",
     Cell[BoxData[
      StyleBox["coordsys", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->15264]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->482674081],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->213998274],

Cell["\<\
Find the Cartesian coordinates for a point in space whose cylindrical \
coordinates are given:\
\>", "ExampleText",
 CellID->534486770],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoordinatesToCartesian", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"7", ",", 
     RowBox[{"Pi", "/", "3"}], ",", "5"}], "}"}], ",", " ", "Cylindrical"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->119535582],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["7", "2"], ",", 
   FractionBox[
    RowBox[{"7", " ", 
     SqrtBox["3"]}], "2"], ",", "5"}], "}"}]], "Output",
 ImageSize->{97, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->54348054]
}, Open  ]],

Cell["Transform back to cylindrical coordinates:", "ExampleText",
 CellID->9655293],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoordinatesFromCartesian", "[", 
  RowBox[{"%", ",", "Cylindrical"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->248318185],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7", ",", 
   FractionBox["\[Pi]", "3"], ",", "5"}], "}"}]], "Output",
 ImageSize->{67, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->56851949]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14077],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["CoordinatesFromCartesian",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/CoordinatesFromCartesian"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->18213]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8383],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->8720]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CoordinatesToCartesian - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 7.1381124}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "CoordinatesToCartesian[pt] gives the Cartesian coordinates of the point \
pt given in the default coordinate system. CoordinatesToCartesian[pt, \
coordsys] gives the Cartesian coordinates of the point given in the \
coordinate system coordsys.", "synonyms" -> {}, "title" -> 
    "CoordinatesToCartesian", "type" -> "Symbol", "uri" -> 
    "VectorAnalysis/ref/CoordinatesToCartesian"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3021, 98, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7318, 251}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1266, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1889, 60, 59, 1, 70, "ObjectName",
 CellID->5041],
Cell[1951, 63, 1033, 30, 70, "Usage",
 CellID->15264]
}, Open  ]],
Cell[CellGroupData[{
Cell[3021, 98, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3398, 112, 148, 5, 70, "ExampleSection",
 CellID->482674081],
Cell[3549, 119, 139, 4, 70, "Input",
 CellID->213998274],
Cell[3691, 125, 145, 4, 70, "ExampleText",
 CellID->534486770],
Cell[CellGroupData[{
Cell[3861, 133, 245, 8, 28, "Input",
 CellID->119535582],
Cell[4109, 143, 296, 11, 56, "Output",
 CellID->54348054]
}, Open  ]],
Cell[4420, 157, 83, 1, 70, "ExampleText",
 CellID->9655293],
Cell[CellGroupData[{
Cell[4528, 162, 153, 4, 28, "Input",
 CellID->248318185],
Cell[4684, 168, 238, 8, 49, "Output",
 CellID->56851949]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4983, 183, 311, 9, 70, "SeeAlsoSection",
 CellID->14077],
Cell[5297, 194, 243, 6, 70, "SeeAlso",
 CellID->18213]
}, Open  ]],
Cell[CellGroupData[{
Cell[5577, 205, 313, 9, 70, "TutorialsSection",
 CellID->8383],
Cell[5893, 216, 162, 3, 70, "Tutorials",
 CellID->8720]
}, Open  ]],
Cell[6070, 222, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

