(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14685,        548]
NotebookOptionsPosition[     10904,        422]
NotebookOutlinePosition[     12287,        460]
CellTagsIndexPosition[     12202,        455]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CrossProduct" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/CrossProduct"], 
          "ScalarTripleProduct" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/ScalarTripleProduct"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CrossProduct\"\>", 
       2->"\<\"ScalarTripleProduct\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DotProduct", "ObjectName",
 CellID->1932],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DotProduct", "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["2", "TR"]]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the dot product of the two 3-vectors ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["2", "TR"]]}]], "InlineFormula"],
     " in the default coordinate system. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DotProduct", "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["coordsys", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the dot product of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " in the coordinate system ",
     Cell[BoxData[
      StyleBox["coordsys", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->4953]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"DotProduct", "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["v", "TI"], "1"], ",", 
    SubscriptBox[
     StyleBox["v", "TI"], "2"], ",", 
    StyleBox["coordsys", "TI"]}], "]"}]], "InlineFormula"],
 " is computed by converting ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["2", "TR"]]], "InlineFormula"],
 " to Cartesian coordinates and then forming the dot product."
}], "Notes",
 CellID->10824]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->56133949],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->5526377],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->15297194],

Cell["Dot product of two Cartesian vectors:", "ExampleText",
 CellID->42590682],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", " ", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", " ", "5"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->135365747],

Cell[BoxData[
 RowBox[{
  RowBox[{"b", "=", " ", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", 
     RowBox[{"-", "7"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->760294164],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DotProduct", "[", 
  RowBox[{"a", ",", " ", "b"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->317043030],

Cell[BoxData[
 RowBox[{"-", "27"}]], "Output",
 ImageSize->{26, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->274920912]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->191943954],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->428479197],

Cell["Verify that a pair of vectors are orthogonal:", "ExampleText",
 CellID->543883409],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", " ", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", " ", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->40063377],

Cell[BoxData[
 RowBox[{
  RowBox[{"b", "=", " ", 
   RowBox[{"{", 
    RowBox[{"2", ",", "5", ",", " ", "17"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->38462077],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DotProduct", "[", 
  RowBox[{"a", ",", " ", "b"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->26511299],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->36748814]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->261071157],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->255060841],

Cell["Dot product of vectors in cylindrical coordinates:", "ExampleText",
 CellID->246544227],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "3"}], ",", 
     RowBox[{"1", "/", "2"}], ",", " ", "7"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->102589244],

Cell[BoxData[
 RowBox[{
  RowBox[{"b", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{"1", "/", "5"}], ",", "1"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->781772050],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DotProduct", "[", 
   RowBox[{"a", ",", " ", "b", ",", " ", "Cylindrical"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->45470161],

Cell[BoxData[
 RowBox[{"7", "+", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   RowBox[{"Cos", "[", 
    FractionBox["3", "10"], "]"}]}]}]], "Output",
 ImageSize->{91, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->4518870]
}, Open  ]],

Cell["\<\
Compare with the result from conversion to Cartesian coordinates:\
\>", "ExampleText",
 CellID->360740099],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DotProduct", "[", 
   RowBox[{
    RowBox[{"CoordinatesToCartesian", "[", 
     RowBox[{"a", ",", " ", "Cylindrical"}], "]"}], ",", " ", 
    RowBox[{"CoordinatesToCartesian", "[", 
     RowBox[{"b", ",", " ", "Cylindrical"}], "]"}]}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->275377357],

Cell[BoxData[
 RowBox[{"7", "+", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   RowBox[{"Cos", "[", 
    FractionBox["3", "10"], "]"}]}]}]], "Output",
 ImageSize->{91, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->184350338]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12280],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CrossProduct",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/CrossProduct"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScalarTripleProduct",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/ScalarTripleProduct"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25167]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5033],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->30057]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DotProduct - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 14.6070536}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "DotProduct[v_1, v_2] gives the dot product of the two 3-vectors v_1, v_2 \
in the default coordinate system. DotProduct[v_1, v_2, coordsys] gives the \
dot product of v_1 and v_2 in the coordinate system coordsys.", 
    "synonyms" -> {}, "title" -> "DotProduct", "type" -> "Symbol", "uri" -> 
    "VectorAnalysis/ref/DotProduct"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4782, 166, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->56133949]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12060, 448}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1386, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2009, 62, 47, 1, 70, "ObjectName",
 CellID->1932],
Cell[2059, 65, 1593, 53, 70, "Usage",
 CellID->4953]
}, Open  ]],
Cell[CellGroupData[{
Cell[3689, 123, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4167, 140, 578, 21, 70, "Notes",
 CellID->10824]
}, Closed]],
Cell[CellGroupData[{
Cell[4782, 166, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->56133949],
Cell[CellGroupData[{
Cell[5166, 180, 146, 5, 70, "ExampleSection",
 CellID->5526377],
Cell[5315, 187, 138, 4, 70, "Input",
 CellID->15297194],
Cell[5456, 193, 79, 1, 70, "ExampleText",
 CellID->42590682],
Cell[5538, 196, 179, 6, 70, "Input",
 CellID->135365747],
Cell[5720, 204, 195, 7, 70, "Input",
 CellID->760294164],
Cell[CellGroupData[{
Cell[5940, 215, 134, 4, 70, "Input",
 CellID->317043030],
Cell[6077, 221, 176, 6, 36, "Output",
 CellID->274920912]
}, Open  ]],
Cell[6268, 230, 125, 3, 70, "ExampleDelimiter",
 CellID->191943954],
Cell[6396, 235, 139, 4, 70, "Input",
 CellID->428479197],
Cell[6538, 241, 88, 1, 70, "ExampleText",
 CellID->543883409],
Cell[6629, 244, 199, 7, 70, "Input",
 CellID->40063377],
Cell[6831, 253, 179, 6, 70, "Input",
 CellID->38462077],
Cell[CellGroupData[{
Cell[7035, 263, 133, 4, 70, "Input",
 CellID->26511299],
Cell[7171, 269, 157, 5, 36, "Output",
 CellID->36748814]
}, Open  ]],
Cell[7343, 277, 125, 3, 70, "ExampleDelimiter",
 CellID->261071157],
Cell[7471, 282, 139, 4, 70, "Input",
 CellID->255060841],
Cell[7613, 288, 93, 1, 70, "ExampleText",
 CellID->246544227],
Cell[7709, 291, 231, 8, 70, "Input",
 CellID->102589244],
Cell[7943, 301, 226, 8, 70, "Input",
 CellID->781772050],
Cell[CellGroupData[{
Cell[8194, 313, 193, 6, 70, "Input",
 CellID->45470161],
Cell[8390, 321, 278, 10, 51, "Output",
 CellID->4518870]
}, Open  ]],
Cell[8683, 334, 116, 3, 70, "ExampleText",
 CellID->360740099],
Cell[CellGroupData[{
Cell[8824, 341, 353, 10, 70, "Input",
 CellID->275377357],
Cell[9180, 353, 280, 10, 51, "Output",
 CellID->184350338]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9521, 370, 311, 9, 70, "SeeAlsoSection",
 CellID->12280],
Cell[9835, 381, 511, 17, 70, "SeeAlso",
 CellID->25167]
}, Open  ]],
Cell[CellGroupData[{
Cell[10383, 403, 313, 9, 70, "TutorialsSection",
 CellID->5033],
Cell[10699, 414, 163, 3, 70, "Tutorials",
 CellID->30057]
}, Open  ]],
Cell[10877, 420, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

