(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12083,        433]
NotebookOptionsPosition[      9323,        341]
NotebookOutlinePosition[     10640,        378]
CellTagsIndexPosition[     10555,        373]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Div" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Div"], "Curl" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Curl"], 
          "Laplacian" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Laplacian"], 
          "Biharmonic" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/Biharmonic"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Div\"\>", 2->"\<\"Curl\"\>", 
       3->"\<\"Laplacian\"\>", 4->"\<\"Biharmonic\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Grad", "ObjectName",
 CellID->13929],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Grad", "[", 
       StyleBox["f", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the gradient, ",
     Cell[BoxData[
      RowBox[{"\[Del]", 
       StyleBox["f", "TI"]}]], "InlineFormula"],
     ", of the scalar function ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " in the default coordinate system. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Grad", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["coordsys", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the gradient of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " in the coordinate system ",
     Cell[BoxData[
      StyleBox["coordsys", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->731]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->42884996],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->207256698],

Cell["Gradient of a function in Cartesian coordinates:", "ExampleText",
 CellID->5662607],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", " ", "=", 
   RowBox[{
    RowBox[{"Xx", "^", "2"}], " ", "+", " ", 
    RowBox[{"Yy", " ", 
     RowBox[{"E", "^", 
      RowBox[{"(", "Zz", ")"}]}]}]}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->498412687],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"v1", ",", " ", "v2", ",", " ", "v3"}], "}"}], " ", "=", " ", 
  RowBox[{"Grad", "[", "f", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->301487301],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", "Xx"}], ",", 
   SuperscriptBox["\[ExponentialE]", "Zz"], ",", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", "Zz"], " ", "Yy"}]}], "}"}]], "Output",
 ImageSize->{117, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->822897908]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", "f", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->523309130],

Cell[TextData[{
 "Recover the original function using ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->637153765],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", " ", "=", " ", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"Xx", ",", " ", "Yy", ",", " ", "Zz"}], "]"}], ",", " ", 
         "Xx"}], "]"}], "\[Equal]", " ", "v1"}], ",", " ", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"Xx", ",", " ", "Yy", ",", " ", "Zz"}], "]"}], ",", " ", 
         "Yy"}], "]"}], "\[Equal]", " ", "v2"}], ",", "  ", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"Xx", ",", " ", "Yy", ",", " ", "Zz"}], "]"}], ",", " ", 
         "Zz"}], "]"}], "\[Equal]", " ", "v3"}]}], "}"}], ",", " ", "f", ",", 
    " ", 
    RowBox[{"{", 
     RowBox[{"Xx", ",", " ", "Yy", ",", " ", "Zz"}], "}"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->26745529],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Xx", ",", "Yy", ",", "Zz"}], "}"}], ",", 
      RowBox[{
       SuperscriptBox["Xx", "2"], "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", "Zz"], " ", "Yy"}], "+", 
       RowBox[{"C", "[", "1", "]"}]}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{322, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->197408719]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Xx", ",", " ", "Yy", ",", " ", "Zz"}], "]"}], "/.", 
   RowBox[{"sol", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"C", "[", "1", "]"}], " ", "\[Rule]", " ", "0"}], 
   "}"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->523518630],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["Xx", "2"], "+", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "Zz"], " ", "Yy"}]}]], "Output",
 ImageSize->{71, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->350128488]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31958],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Div",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Div"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Curl",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Curl"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Laplacian",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Laplacian"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Biharmonic",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Biharmonic"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20238]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4278],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->17859]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Grad - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 15.4195744}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "Grad[f] gives the gradient, \\[Del]f, of the scalar function f in the \
default coordinate system. Grad[f, coordsys] gives the gradient of f in the \
coordinate system coordsys.", "synonyms" -> {}, "title" -> "Grad", "type" -> 
    "Symbol", "uri" -> "VectorAnalysis/ref/Grad"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3296, 106, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10420, 366}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1558, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2181, 65, 42, 1, 70, "ObjectName",
 CellID->13929],
Cell[2226, 68, 1033, 33, 70, "Usage",
 CellID->731]
}, Open  ]],
Cell[CellGroupData[{
Cell[3296, 106, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3673, 120, 147, 5, 70, "ExampleSection",
 CellID->42884996],
Cell[3823, 127, 139, 4, 70, "Input",
 CellID->207256698],
Cell[3965, 133, 89, 1, 70, "ExampleText",
 CellID->5662607],
Cell[4057, 136, 255, 9, 70, "Input",
 CellID->498412687],
Cell[CellGroupData[{
Cell[4337, 149, 203, 6, 28, "Input",
 CellID->301487301],
Cell[4543, 157, 345, 11, 39, "Output",
 CellID->822897908]
}, Open  ]],
Cell[4903, 171, 101, 3, 70, "Input",
 CellID->523309130],
Cell[5007, 176, 215, 8, 70, "ExampleText",
 CellID->637153765],
Cell[CellGroupData[{
Cell[5247, 188, 956, 29, 70, "Input",
 CellID->26745529],
Cell[6206, 219, 539, 17, 39, "Output",
 CellID->197408719]
}, Open  ]],
Cell[CellGroupData[{
Cell[6782, 241, 347, 12, 70, "Input",
 CellID->523518630],
Cell[7132, 255, 269, 9, 36, "Output",
 CellID->350128488]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7462, 271, 311, 9, 70, "SeeAlsoSection",
 CellID->31958],
Cell[7776, 282, 989, 35, 70, "SeeAlso",
 CellID->20238]
}, Open  ]],
Cell[CellGroupData[{
Cell[8802, 322, 313, 9, 70, "TutorialsSection",
 CellID->4278],
Cell[9118, 333, 163, 3, 70, "Tutorials",
 CellID->17859]
}, Open  ]],
Cell[9296, 339, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

