(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15924,        543]
NotebookOptionsPosition[     12720,        441]
NotebookOutlinePosition[     14289,        481]
CellTagsIndexPosition[     14204,        476]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"JacobianMatrix" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/JacobianMatrix"], "ArcLengthFactor" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/ArcLengthFactor"], "ScaleFactors" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/ScaleFactors"], 
          "Div" :> Documentation`HelpLookup["paclet:VectorAnalysis/ref/Div"], 
          "Curl" :> Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/Curl"], "Grad" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Grad"], 
          "Laplacian" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Laplacian"], 
          "Biharmonic" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Biharmonic"], 
          "DotProduct" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/DotProduct"], 
          "CrossProduct" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/CrossProduct"], 
          "ScalarTripleProduct" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/ScalarTripleProduct"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"JacobianMatrix\"\>", 
       2->"\<\"ArcLengthFactor\"\>", 3->"\<\"ScaleFactors\"\>", 
       4->"\<\"Div\"\>", 5->"\<\"Curl\"\>", 6->"\<\"Grad\"\>", 
       7->"\<\"Laplacian\"\>", 8->"\<\"Biharmonic\"\>", 
       9->"\<\"DotProduct\"\>", 10->"\<\"CrossProduct\"\>", 
       11->"\<\"ScalarTripleProduct\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["JacobianDeterminant", "ObjectName",
 CellID->6612],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"JacobianDeterminant", "[", 
       StyleBox["pt", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the determinant of the Jacobian matrix of the \
transformation from the default coordinate system to the Cartesian coordinate \
system at the point ",
     Cell[BoxData[
      StyleBox["pt", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"JacobianDeterminant", "[", 
       RowBox[{
        StyleBox["pt", "TI"], ",", 
        StyleBox["coordsys", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the determinant of the Jacobian matrix of the \
transformation from the coordinate system ",
     Cell[BoxData[
      StyleBox["coordsys", "TI"]], "InlineFormula"],
     " to the Cartesian coordinate system at the point ",
     Cell[BoxData[
      StyleBox["pt", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->24387]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"JacobianDeterminant", "[", 
   RowBox[{
    StyleBox["pt", "TI"], ",", 
    StyleBox["coordsys", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Det",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Det"], "[", 
   RowBox[{
    ButtonBox["JacobianMatrix",
     BaseStyle->"Link",
     ButtonData->"paclet:VectorAnalysis/ref/JacobianMatrix"], "[", 
    RowBox[{
     StyleBox["pt", "TI"], ",", 
     StyleBox["coordsys", "TI"]}], "]"}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->11957],

Cell[TextData[{
 "The coordinates of ",
 Cell[BoxData[
  StyleBox["pt", "TI"]], "InlineFormula"],
 " should be given in the coordinate system ",
 Cell[BoxData[
  StyleBox["coordsys", "TI"]], "InlineFormula"],
 ", if specified, or the default coordinate system otherwise."
}], "Notes",
 CellID->15503],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["pt", "TI"]], "InlineFormula"],
 " is not given, the default coordinate variables for ",
 Cell[BoxData[
  StyleBox["coordsys", "TI"]], "InlineFormula"],
 " are used."
}], "Notes",
 CellID->19491]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->178201846],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->617704872],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->14704686],

Cell["\<\
Jacobian determinant for transformation from cylindrical to Cartesian \
coordinates:\
\>", "ExampleText",
 CellID->68464257],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"jdet", " ", "=", " ", 
  RowBox[{"JacobianDeterminant", "[", "Cylindrical", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23387808],

Cell[BoxData["Rr"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->442327903]
}, Open  ]],

Cell["\<\
Use the Jacobian determinant to change variables in a multiple integral:\
\>", "ExampleText",
 CellID->481340010],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"E", "^", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"x", "^", "2"}]}], "-", 
      RowBox[{"y", "^", "2"}], "-", "z"}], ")"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", "Infinity"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", " ", "0", ",", " ", "Infinity"}], "}"}], ",", " ", "\n",
    "  ", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", "0", ",", " ", "Infinity"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->364904106],

Cell[BoxData[
 FractionBox["\[Pi]", "4"]], "Output",
 ImageSize->{17, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->113145365]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"Rr", "^", "2"}]}], "-", "z"}], ")"}]}], "*", "jdet"}], ",", 
   " ", 
   RowBox[{"{", 
    RowBox[{"Rr", ",", "0", ",", " ", "Infinity"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"Ttheta", ",", "0", ",", " ", 
     RowBox[{"Pi", "/", "2"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", "0", ",", " ", "Infinity"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->223433414],

Cell[BoxData[
 FractionBox["\[Pi]", "4"]], "Output",
 ImageSize->{17, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->69730439]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->952],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobianMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/JacobianMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcLengthFactor",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/ArcLengthFactor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScaleFactors",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/ScaleFactors"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Div",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Div"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Curl",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Curl"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Grad",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Grad"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Laplacian",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Laplacian"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Biharmonic",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Biharmonic"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DotProduct",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/DotProduct"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CrossProduct",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/CrossProduct"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScalarTripleProduct",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/ScalarTripleProduct"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8496]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10482],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->2829]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"JacobianDeterminant - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 15.7945840}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "JacobianDeterminant[pt] gives the determinant of the Jacobian matrix of \
the transformation from the default coordinate system to the Cartesian \
coordinate system at the point pt. JacobianDeterminant[pt, coordsys] gives \
the determinant of the Jacobian matrix of the transformation from the \
coordinate system coordsys to the Cartesian coordinate system at the point \
pt.", "synonyms" -> {}, "title" -> "JacobianDeterminant", "type" -> "Symbol", 
    "uri" -> "VectorAnalysis/ref/JacobianDeterminant"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6050, 187, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->178201846]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14061, 469}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2535, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3158, 82, 56, 1, 70, "ObjectName",
 CellID->6612],
Cell[3217, 85, 1140, 32, 70, "Usage",
 CellID->24387]
}, Open  ]],
Cell[CellGroupData[{
Cell[4394, 122, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4872, 139, 590, 21, 70, "Notes",
 CellID->11957],
Cell[5465, 162, 300, 9, 70, "Notes",
 CellID->15503],
Cell[5768, 173, 245, 9, 70, "Notes",
 CellID->19491]
}, Closed]],
Cell[CellGroupData[{
Cell[6050, 187, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->178201846],
Cell[CellGroupData[{
Cell[6435, 201, 148, 5, 70, "ExampleSection",
 CellID->617704872],
Cell[6586, 208, 138, 4, 70, "Input",
 CellID->14704686],
Cell[6727, 214, 134, 4, 70, "ExampleText",
 CellID->68464257],
Cell[CellGroupData[{
Cell[6886, 222, 160, 4, 28, "Input",
 CellID->23387808],
Cell[7049, 228, 159, 5, 36, "Output",
 CellID->442327903]
}, Open  ]],
Cell[7223, 236, 123, 3, 70, "ExampleText",
 CellID->481340010],
Cell[CellGroupData[{
Cell[7371, 243, 572, 18, 70, "Input",
 CellID->364904106],
Cell[7946, 263, 182, 6, 49, "Output",
 CellID->113145365]
}, Open  ]],
Cell[CellGroupData[{
Cell[8165, 274, 572, 19, 70, "Input",
 CellID->223433414],
Cell[8740, 295, 181, 6, 49, "Output",
 CellID->69730439]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8982, 308, 309, 9, 70, "SeeAlsoSection",
 CellID->952],
Cell[9294, 319, 2868, 98, 70, "SeeAlso",
 CellID->8496]
}, Open  ]],
Cell[CellGroupData[{
Cell[12199, 422, 314, 9, 70, "TutorialsSection",
 CellID->10482],
Cell[12516, 433, 162, 3, 70, "Tutorials",
 CellID->2829]
}, Open  ]],
Cell[12693, 439, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

