(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12303,        442]
NotebookOptionsPosition[      9298,        343]
NotebookOutlinePosition[     10666,        381]
CellTagsIndexPosition[     10581,        376]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Div" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Div"], "Curl" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Curl"], "Grad" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Grad"], 
          "Biharmonic" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/Biharmonic"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Div\"\>", 2->"\<\"Curl\"\>", 3->"\<\"Grad\"\>", 
       4->"\<\"Biharmonic\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Laplacian", "ObjectName",
 CellID->25726],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Laplacian", "[", 
       StyleBox["f", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Laplacian, ",
     Cell[BoxData[
      RowBox[{
       SuperscriptBox["\[Del]", "2"], 
       StyleBox["f", "TI"]}]], "InlineFormula"],
     ", of the scalar function or vector field ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " in the default coordinate system. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Laplacian", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["coordsys", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Laplacian of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " in the coordinate system ",
     Cell[BoxData[
      StyleBox["coordsys", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->23201]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->167040309],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->237597224],

Cell["Laplacian of a function in Cartesian coordinates:", "ExampleText",
 CellID->207823316],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Laplacian", "[", 
  RowBox[{
   RowBox[{"Xx", "^", "2"}], " ", "+", 
   RowBox[{"Sin", "[", 
    RowBox[{"Yy", " ", "Zz"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->184172878],

Cell[BoxData[
 RowBox[{"2", "-", 
  RowBox[{
   SuperscriptBox["Yy", "2"], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"Yy", " ", "Zz"}], "]"}]}], "-", 
  RowBox[{
   SuperscriptBox["Zz", "2"], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"Yy", " ", "Zz"}], "]"}]}]}]], "Output",
 ImageSize->{214, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->8732268]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->42192037],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->43121872],

Cell["Verify that a function is harmonic:", "ExampleText",
 CellID->4868947],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Laplacian", "[", 
  RowBox[{
   RowBox[{"Xx", "^", "2"}], " ", "+", " ", 
   RowBox[{"7", 
    RowBox[{"Yy", "^", "2"}]}], " ", "-", " ", 
   RowBox[{"8", " ", 
    RowBox[{"Zz", "^", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->87127824],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->90979782]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->104411563],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->250626155],

Cell["Expression for the Laplacian in cylindrical coordinates:", "ExampleText",
 CellID->25176529],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Laplacian", "[", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"Rr", ",", " ", "Ttheta", ",", " ", "Zz"}], "]"}], ",", " ", 
    "Cylindrical"}], "]"}], "//", "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->246806304],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["f", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "0", ",", "2"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"Rr", ",", "Ttheta", ",", "Zz"}], "]"}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["f", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "2", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"Rr", ",", "Ttheta", ",", "Zz"}], "]"}], 
   SuperscriptBox["Rr", "2"]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["f", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "0", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"Rr", ",", "Ttheta", ",", "Zz"}], "]"}], "Rr"], "+", 
  RowBox[{
   SuperscriptBox["f", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"2", ",", "0", ",", "0"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"Rr", ",", "Ttheta", ",", "Zz"}], "]"}]}]], "Output",
 ImageSize->{329, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->262457319]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23990],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Div",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Div"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Curl",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Curl"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Grad",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Grad"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Biharmonic",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Biharmonic"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4591]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->773],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->25306]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Laplacian - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 16.4039746}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "Laplacian[f] gives the Laplacian, \\[Del]^2 f, of the scalar function or \
vector field f in the default coordinate system. Laplacian[f, coordsys] gives \
the Laplacian of f in the coordinate system coordsys.", "synonyms" -> {}, 
    "title" -> "Laplacian", "type" -> "Symbol", "uri" -> 
    "VectorAnalysis/ref/Laplacian"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3334, 106, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10446, 369}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1532, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2155, 64, 47, 1, 70, "ObjectName",
 CellID->25726],
Cell[2205, 67, 1092, 34, 70, "Usage",
 CellID->23201]
}, Open  ]],
Cell[CellGroupData[{
Cell[3334, 106, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3711, 120, 148, 5, 70, "ExampleSection",
 CellID->167040309],
Cell[3862, 127, 139, 4, 70, "Input",
 CellID->237597224],
Cell[4004, 133, 92, 1, 70, "ExampleText",
 CellID->207823316],
Cell[CellGroupData[{
Cell[4121, 138, 216, 7, 28, "Input",
 CellID->184172878],
Cell[4340, 147, 403, 14, 36, "Output",
 CellID->8732268]
}, Open  ]],
Cell[4758, 164, 124, 3, 70, "ExampleDelimiter",
 CellID->42192037],
Cell[4885, 169, 138, 4, 70, "Input",
 CellID->43121872],
Cell[5026, 175, 76, 1, 70, "ExampleText",
 CellID->4868947],
Cell[CellGroupData[{
Cell[5127, 180, 277, 9, 70, "Input",
 CellID->87127824],
Cell[5407, 191, 157, 5, 36, "Output",
 CellID->90979782]
}, Open  ]],
Cell[5579, 199, 125, 3, 70, "ExampleDelimiter",
 CellID->104411563],
Cell[5707, 204, 139, 4, 70, "Input",
 CellID->250626155],
Cell[5849, 210, 98, 1, 70, "ExampleText",
 CellID->25176529],
Cell[CellGroupData[{
Cell[5972, 215, 263, 8, 70, "Input",
 CellID->246806304],
Cell[6238, 225, 1150, 41, 88, "Output",
 CellID->262457319]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7449, 273, 311, 9, 70, "SeeAlsoSection",
 CellID->23990],
Cell[7763, 284, 978, 35, 70, "SeeAlso",
 CellID->4591]
}, Open  ]],
Cell[CellGroupData[{
Cell[8778, 324, 312, 9, 70, "TutorialsSection",
 CellID->773],
Cell[9093, 335, 163, 3, 70, "Tutorials",
 CellID->25306]
}, Open  ]],
Cell[9271, 341, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

