(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8802,        322]
NotebookOptionsPosition[      6279,        236]
NotebookOutlinePosition[      7541,        273]
CellTagsIndexPosition[      7457,        268]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Llambda" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Llambda"], 
          "Nnu" :> Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/Nnu"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Llambda\"\>", 
       2->"\<\"Nnu\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Mmu", "ObjectName",
 CellID->18361],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Mmu"], "InlineFormula"],
     "\[LineSeparator]is one of the default coordinates for the ",
     Cell[BoxData[
      ButtonBox["Conical",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Conical"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["ConfocalEllipsoidal",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/ConfocalEllipsoidal"]], 
      "InlineFormula"],
     ", and ",
     Cell[BoxData[
      ButtonBox["ConfocalParaboloidal",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/ConfocalParaboloidal"]], 
      "InlineFormula"],
     " coordinate systems."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13132]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->98280009],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->343240863],

Cell[TextData[{
 Cell[BoxData["Mmu"], "InlineFormula"],
 " is used as a coordinate in several coordinate systems:"
}], "ExampleText",
 CellID->35004531],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coordinates", "[", "Conical", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->406403560],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Llambda", ",", "Mmu", ",", "Nnu"}], "}"}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->780025779]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coordinates", "[", "ConfocalEllipsoidal", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->566909803],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Llambda", ",", "Mmu", ",", "Nnu"}], "}"}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->341502721]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coordinates", "[", "ConfocalParaboloidal", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->6802135],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Llambda", ",", "Mmu", ",", "Nnu"}], "}"}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->121484862]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31826],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Llambda",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Llambda"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Nnu",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Nnu"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29348]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19728],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->30522]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Mmu - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 17.3414986}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "Mmu is one of the default coordinates for the Conical, \
ConfocalEllipsoidal, and ConfocalParaboloidal coordinate systems.", 
    "synonyms" -> {}, "title" -> "Mmu", "type" -> "Symbol", "uri" -> 
    "VectorAnalysis/ref/Mmu"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2913, 96, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7323, 261}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1312, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1935, 61, 41, 1, 70, "ObjectName",
 CellID->18361],
Cell[1979, 64, 897, 27, 70, "Usage",
 CellID->13132]
}, Open  ]],
Cell[CellGroupData[{
Cell[2913, 96, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3290, 110, 147, 5, 70, "ExampleSection",
 CellID->98280009],
Cell[3440, 117, 139, 4, 70, "Input",
 CellID->343240863],
Cell[3582, 123, 152, 4, 70, "ExampleText",
 CellID->35004531],
Cell[CellGroupData[{
Cell[3759, 131, 113, 3, 28, "Input",
 CellID->406403560],
Cell[3875, 136, 224, 7, 36, "Output",
 CellID->780025779]
}, Open  ]],
Cell[CellGroupData[{
Cell[4136, 148, 125, 3, 28, "Input",
 CellID->566909803],
Cell[4264, 153, 224, 7, 36, "Output",
 CellID->341502721]
}, Open  ]],
Cell[CellGroupData[{
Cell[4525, 165, 124, 3, 28, "Input",
 CellID->6802135],
Cell[4652, 170, 224, 7, 36, "Output",
 CellID->121484862]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4937, 184, 311, 9, 70, "SeeAlsoSection",
 CellID->31826],
Cell[5251, 195, 469, 17, 70, "SeeAlso",
 CellID->29348]
}, Open  ]],
Cell[CellGroupData[{
Cell[5757, 217, 314, 9, 70, "TutorialsSection",
 CellID->19728],
Cell[6074, 228, 163, 3, 70, "Tutorials",
 CellID->30522]
}, Open  ]],
Cell[6252, 234, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

