(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11893,        423]
NotebookOptionsPosition[      8930,        326]
NotebookOutlinePosition[     10351,        364]
CellTagsIndexPosition[     10266,        359]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["VECTOR ANALYSIS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vector Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/tutorial/VectorAnalysis"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Vector Analysis Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Paraboloidal" :> 
          Documentation`HelpLookup["paclet:VectorAnalysis/ref/Paraboloidal"], 
          "EllipticCylindrical" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/EllipticCylindrical"], 
          "ProlateSpheroidal" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/ProlateSpheroidal"], "OblateSpheroidal" :> 
          Documentation`HelpLookup[
           "paclet:VectorAnalysis/ref/OblateSpheroidal"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Paraboloidal\"\>", 
       2->"\<\"EllipticCylindrical\"\>", 3->"\<\"ProlateSpheroidal\"\>", 
       4->"\<\"OblateSpheroidal\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ParabolicCylindrical", "ObjectName",
 CellID->13037],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["ParabolicCylindrical"], "InlineFormula"],
     " \[LineSeparator]represents the parabolic cylindrical coordinate system \
with default variables ",
     Cell[BoxData[
      ButtonBox["Uu",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Uu"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Vv",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Vv"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      ButtonBox["Zz",
       BaseStyle->"Link",
       ButtonData->"paclet:VectorAnalysis/ref/Zz"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ParabolicCylindrical", "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["v", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the parabolic cylindrical coordinate system \
with variables ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->19035]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->2439361],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<VectorAnalysis`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->629156641],

Cell[TextData[{
 "Use ",
 Cell[BoxData["ParabolicCylindrical"], "InlineFormula"],
 " as the default coordinate system:"
}], "ExampleText",
 CellID->428269499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetCoordinates", "[", "ParabolicCylindrical", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->443597938],

Cell[BoxData[
 RowBox[{"ParabolicCylindrical", "[", 
  RowBox[{"Uu", ",", "Vv", ",", "Zz"}], "]"}]], "Output",
 ImageSize->{223, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->746771869]
}, Open  ]],

Cell["\<\
All evaluations now use parabolic cylindrical coordinates as the default:\
\>", "ExampleText",
 CellID->116864137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoordinateRanges", "[", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->709779145],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "\[Infinity]"}], "<", "Uu", "<", "\[Infinity]"}], ",", 
   RowBox[{"0", "\[LessEqual]", "Vv", "<", "\[Infinity]"}], ",", 
   RowBox[{
    RowBox[{"-", "\[Infinity]"}], "<", "Zz", "<", "\[Infinity]"}]}], 
  "}"}]], "Output",
 ImageSize->{229, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->132439191]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ScaleFactors", "[", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->33744766],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SqrtBox[
    RowBox[{
     SuperscriptBox["Uu", "2"], "+", 
     SuperscriptBox["Vv", "2"]}]], ",", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["Uu", "2"], "+", 
     SuperscriptBox["Vv", "2"]}]], ",", "1"}], "}"}]], "Output",
 ImageSize->{189, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->676539416]
}, Open  ]],

Cell[TextData[{
 "Reset the default coordinate system to ",
 Cell[BoxData[
  ButtonBox["Cartesian",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorAnalysis/ref/Cartesian"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->31402094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetCoordinates", "[", "Cartesian", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->74704059],

Cell[BoxData[
 RowBox[{"Cartesian", "[", 
  RowBox[{"Xx", ",", "Yy", ",", "Zz"}], "]"}]], "Output",
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->764293644]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11221],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Paraboloidal",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/Paraboloidal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipticCylindrical",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/EllipticCylindrical"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ProlateSpheroidal",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/ProlateSpheroidal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OblateSpheroidal",
    BaseStyle->"Link",
    ButtonData->"paclet:VectorAnalysis/ref/OblateSpheroidal"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17975]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13316],

Cell[TextData[ButtonBox["Vector Analysis Package",
 BaseStyle->"Link",
 ButtonData->"paclet:VectorAnalysis/tutorial/VectorAnalysis"]], "Tutorials",
 CellID->1890]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ParabolicCylindrical - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 13, 23.0291442}", "context" -> 
    "VectorAnalysis`", "keywords" -> {}, "index" -> True, "label" -> 
    "Vector Analysis Package Symbol", "language" -> "en", "paclet" -> 
    "VectorAnalysis Package", "status" -> "None", "summary" -> 
    "ParabolicCylindrical represents the parabolic cylindrical coordinate \
system with default variables Uu, Vv, and Zz. ParabolicCylindrical[u, v, z] \
represents the parabolic cylindrical coordinate system with variables u, v, \
and z.", "synonyms" -> {}, "title" -> "ParabolicCylindrical", "type" -> 
    "Symbol", "uri" -> "VectorAnalysis/ref/ParabolicCylindrical"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3839, 121, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10131, 352}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1704, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2327, 68, 58, 1, 70, "ObjectName",
 CellID->13037],
Cell[2388, 71, 1414, 45, 70, "Usage",
 CellID->19035]
}, Open  ]],
Cell[CellGroupData[{
Cell[3839, 121, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4216, 135, 146, 5, 70, "ExampleSection",
 CellID->2439361],
Cell[4365, 142, 139, 4, 70, "Input",
 CellID->629156641],
Cell[4507, 148, 158, 5, 70, "ExampleText",
 CellID->428269499],
Cell[CellGroupData[{
Cell[4690, 157, 129, 3, 28, "Input",
 CellID->443597938],
Cell[4822, 162, 241, 7, 36, "Output",
 CellID->746771869]
}, Open  ]],
Cell[5078, 172, 124, 3, 70, "ExampleText",
 CellID->116864137],
Cell[CellGroupData[{
Cell[5227, 179, 107, 3, 28, "Input",
 CellID->709779145],
Cell[5337, 184, 423, 13, 36, "Output",
 CellID->132439191]
}, Open  ]],
Cell[CellGroupData[{
Cell[5797, 202, 102, 3, 70, "Input",
 CellID->33744766],
Cell[5902, 207, 402, 15, 48, "Output",
 CellID->676539416]
}, Open  ]],
Cell[6319, 225, 238, 8, 70, "ExampleText",
 CellID->31402094],
Cell[CellGroupData[{
Cell[6582, 237, 117, 3, 70, "Input",
 CellID->74704059],
Cell[6702, 242, 230, 7, 36, "Output",
 CellID->764293644]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6993, 256, 311, 9, 70, "SeeAlsoSection",
 CellID->11221],
Cell[7307, 267, 1065, 35, 70, "SeeAlso",
 CellID->17975]
}, Open  ]],
Cell[CellGroupData[{
Cell[8409, 307, 314, 9, 70, "TutorialsSection",
 CellID->13316],
Cell[8726, 318, 162, 3, 70, "Tutorials",
 CellID->1890]
}, Open  ]],
Cell[8903, 324, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

